/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.context.ContextPartitionSelector;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.mgr.ContextPropertyRegistryImpl;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPPreparedQueryResult;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StreamJoinAnalysisResult;
import com.espertech.esper.core.service.speccompiled.StatementSpecCompiled;
import com.espertech.esper.core.start.EPPreparedExecuteMethod;
import com.espertech.esper.core.start.EPPreparedExecuteMethodHelper;
import com.espertech.esper.core.start.EPPreparedExecuteTableHelper;
import com.espertech.esper.core.start.EPStatementStartMethodHelperAssignExpr;
import com.espertech.esper.core.start.EPStatementStartMethodHelperValidate;
import com.espertech.esper.core.start.FireAndForgetInstance;
import com.espertech.esper.core.start.FireAndForgetProcessor;
import com.espertech.esper.core.start.FireAndForgetProcessorFactory;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessor;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessorFactoryFactory;
import com.espertech.esper.epl.core.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.epl.join.base.HistoricalViewableDesc;
import com.espertech.esper.epl.join.base.JoinSetComposer;
import com.espertech.esper.epl.join.base.JoinSetComposerDesc;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototype;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototypeFactory;
import com.espertech.esper.epl.join.base.JoinSetFilter;
import com.espertech.esper.epl.join.hint.ExcludePlanHint;
import com.espertech.esper.epl.join.plan.FilterExprAnalyzer;
import com.espertech.esper.epl.join.plan.OuterJoinAnalyzer;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.TableQueryStreamSpec;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.epl.virtualdw.VirtualDWViewProviderForAgentInstance;
import com.espertech.esper.event.EventBeanReader;
import com.espertech.esper.event.EventBeanReaderDefaultImpl;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.view.Viewable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPreparedExecuteMethodQuery
implements EPPreparedExecuteMethod {
    private static final Logger QUERY_PLAN_LOG = LoggerFactory.getLogger((String)"com.espertech.esper.queryplan");
    private static final Logger log = LoggerFactory.getLogger(EPPreparedExecuteMethodQuery.class);
    private final StatementSpecCompiled statementSpec;
    private final EventType resultEventType;
    private final ResultSetProcessor resultSetProcessor;
    private final FireAndForgetProcessor[] processors;
    private final AgentInstanceContext agentInstanceContext;
    private final EPServicesContext services;
    private EventBeanReader eventBeanReader;
    private JoinSetComposerPrototype joinSetComposerPrototype;
    private final QueryGraph queryGraph;
    private boolean hasTableAccess;

    public EPPreparedExecuteMethodQuery(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext) throws ExprValidationException {
        boolean queryPlanLogging = services.getConfigSnapshot().getEngineDefaults().getLogging().isEnableQueryPlan();
        if (queryPlanLogging) {
            QUERY_PLAN_LOG.info("Query plans for Fire-and-forget query '" + statementContext.getExpression() + "'");
        }
        this.hasTableAccess = statementSpec.getTableNodes() != null && statementSpec.getTableNodes().length > 0;
        for (StreamSpecCompiled streamSpec : statementSpec.getStreamSpecs()) {
            this.hasTableAccess |= streamSpec instanceof TableQueryStreamSpec;
        }
        this.statementSpec = statementSpec;
        this.services = services;
        EPPreparedExecuteMethodHelper.validateFAFQuery(statementSpec);
        int numStreams = statementSpec.getStreamSpecs().length;
        EventType[] typesPerStream = new EventType[numStreams];
        String[] namesPerStream = new String[numStreams];
        this.processors = new FireAndForgetProcessor[numStreams];
        this.agentInstanceContext = new AgentInstanceContext(statementContext, null, -1, null, null, statementContext.getDefaultAgentInstanceScriptContext());
        for (int i = 0; i < numStreams; ++i) {
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[i];
            this.processors[i] = FireAndForgetProcessorFactory.validateResolveProcessor(streamSpec, services);
            String streamName = this.processors[i].getNamedWindowOrTableName();
            if (streamSpec.getOptionalStreamName() != null) {
                streamName = streamSpec.getOptionalStreamName();
            }
            namesPerStream[i] = streamName;
            typesPerStream[i] = this.processors[i].getEventTypeResultSetProcessor();
        }
        boolean optionalStreamsIfAny = OuterJoinAnalyzer.optionalStreamsIfAny(statementSpec.getOuterJoinDescList());
        StreamTypeServiceImpl types = new StreamTypeServiceImpl(typesPerStream, namesPerStream, new boolean[numStreams], services.getEngineURI(), false, optionalStreamsIfAny);
        ExcludePlanHint excludePlanHint = ExcludePlanHint.getHint(types.getStreamNames(), statementContext);
        this.queryGraph = new QueryGraph(numStreams, excludePlanHint, false);
        if (statementSpec.getFilterRootNode() != null) {
            for (int i = 0; i < numStreams; ++i) {
                try {
                    ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(statementContext, false);
                    ExprValidationContext validationContext = new ExprValidationContext(types, statementContext.getEngineImportService(), statementContext.getStatementExtensionServicesContext(), null, statementContext.getTimeProvider(), statementContext.getVariableService(), statementContext.getTableService(), evaluatorContextStmt, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor(), false, false, true, false, null, true);
                    ExprNode validated = ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.FILTER, statementSpec.getFilterRootNode(), validationContext);
                    FilterExprAnalyzer.analyze(validated, this.queryGraph, false);
                    continue;
                }
                catch (Exception ex) {
                    log.warn("Unexpected exception analyzing filter paths: " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
        boolean[] isIStreamOnly = new boolean[namesPerStream.length];
        Arrays.fill(isIStreamOnly, true);
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(typesPerStream, namesPerStream, isIStreamOnly, services.getEngineURI(), true, optionalStreamsIfAny);
        EPStatementStartMethodHelperValidate.validateNodes(statementSpec, statementContext, typeService, null);
        ResultSetProcessorFactoryDesc resultSetProcessorPrototype = ResultSetProcessorFactoryFactory.getProcessorPrototype(statementSpec, statementContext, typeService, null, new boolean[0], true, ContextPropertyRegistryImpl.EMPTY_REGISTRY, null, services.getConfigSnapshot(), services.getResultSetProcessorHelperFactory(), true, false);
        this.resultEventType = resultSetProcessorPrototype.getResultEventType();
        this.resultSetProcessor = EPStatementStartMethodHelperAssignExpr.getAssignResultSetProcessor(this.agentInstanceContext, resultSetProcessorPrototype, false, null, true);
        if (statementSpec.getSelectClauseSpec().isDistinct()) {
            if (this.resultEventType instanceof EventTypeSPI) {
                this.eventBeanReader = ((EventTypeSPI)this.resultEventType).getReader();
            }
            if (this.eventBeanReader == null) {
                this.eventBeanReader = new EventBeanReaderDefaultImpl(this.resultEventType);
            }
        }
        if (statementSpec.getOptionalContextName() != null && numStreams > 1) {
            throw new ExprValidationException("Joins in runtime queries for context partitions are not supported");
        }
        if (numStreams > 1) {
            StreamJoinAnalysisResult streamJoinAnalysisResult = new StreamJoinAnalysisResult(numStreams);
            Arrays.fill(streamJoinAnalysisResult.getNamedWindow(), true);
            for (int i = 0; i < numStreams; ++i) {
                final FireAndForgetInstance processorInstance = this.processors[i].getProcessorInstance(this.agentInstanceContext);
                if (this.processors[i].isVirtualDataWindow()) {
                    streamJoinAnalysisResult.getViewExternal()[i] = new VirtualDWViewProviderForAgentInstance(){

                        @Override
                        public VirtualDWView getView(AgentInstanceContext agentInstanceContext) {
                            return processorInstance.getVirtualDataWindow();
                        }
                    };
                }
                String[][] uniqueIndexes = this.processors[i].getUniqueIndexes(processorInstance);
                streamJoinAnalysisResult.getUniqueKeys()[i] = uniqueIndexes;
            }
            boolean hasAggregations = !resultSetProcessorPrototype.getAggregationServiceFactoryDesc().getExpressions().isEmpty();
            this.joinSetComposerPrototype = JoinSetComposerPrototypeFactory.makeComposerPrototype(null, -1, statementSpec.getOuterJoinDescList(), statementSpec.getFilterRootNode(), typesPerStream, namesPerStream, streamJoinAnalysisResult, queryPlanLogging, statementContext, new HistoricalViewableDesc(numStreams), this.agentInstanceContext, false, hasAggregations, services.getTableService(), true, services.getEventTableIndexService().allowInitIndex(false));
        }
    }

    @Override
    public EventType getEventType() {
        return this.resultEventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EPPreparedQueryResult execute(ContextPartitionSelector[] contextPartitionSelectors) {
        try {
            int numStreams = this.processors.length;
            if (contextPartitionSelectors != null && contextPartitionSelectors.length != numStreams) {
                throw new IllegalArgumentException("Number of context partition selectors does not match the number of named windows in the from-clause");
            }
            if (this.statementSpec.getOptionalContextName() == null) {
                Collection[] snapshots = new Collection[numStreams];
                for (int i = 0; i < numStreams; ++i) {
                    ContextPartitionSelector selector = contextPartitionSelectors == null ? null : contextPartitionSelectors[i];
                    snapshots[i] = this.getStreamFilterSnapshot(i, selector);
                }
                this.resultSetProcessor.clear();
                EPPreparedQueryResult i = this.process(snapshots);
                return i;
            }
            ArrayList<ContextPartitionResult> contextPartitionResults = new ArrayList<ContextPartitionResult>();
            ContextPartitionSelector singleSelector = contextPartitionSelectors != null && contextPartitionSelectors.length > 0 ? contextPartitionSelectors[0] : null;
            Collection<Integer> agentInstanceIds = EPPreparedExecuteMethodHelper.getAgentInstanceIds(this.processors[0], singleSelector, this.services.getContextManagementService(), this.statementSpec.getOptionalContextName());
            for (int agentInstanceId : agentInstanceIds) {
                FireAndForgetInstance processorInstance = this.processors[0].getProcessorInstanceContextById(agentInstanceId);
                if (processorInstance == null) continue;
                EPPreparedExecuteTableHelper.assignTableAccessStrategies(this.services, this.statementSpec.getTableNodes(), processorInstance.getAgentInstanceContext());
                Collection<EventBean> coll = processorInstance.snapshotBestEffort(this, this.queryGraph, this.statementSpec.getAnnotations());
                contextPartitionResults.add(new ContextPartitionResult(coll, processorInstance.getAgentInstanceContext()));
            }
            ArrayDeque<EventBean[]> events = new ArrayDeque<EventBean[]>();
            for (ContextPartitionResult contextPartitionResult : contextPartitionResults) {
                Collection<EventBean> snapshot = contextPartitionResult.getEvents();
                if (this.statementSpec.getFilterRootNode() != null) {
                    snapshot = this.getFiltered(snapshot, Collections.singletonList(this.statementSpec.getFilterRootNode()));
                }
                EventBean[] rows = snapshot.toArray(new EventBean[snapshot.size()]);
                this.resultSetProcessor.setAgentInstanceContext(contextPartitionResult.getContext());
                UniformPair<EventBean[]> results = this.resultSetProcessor.processViewResult(rows, null, true);
                if (results == null || results.getFirst() == null || results.getFirst().length <= 0) continue;
                events.add(results.getFirst());
            }
            EPPreparedQueryResult ePPreparedQueryResult = new EPPreparedQueryResult(this.resultEventType, EventBeanUtility.flatten(events));
            return ePPreparedQueryResult;
        }
        finally {
            if (this.hasTableAccess) {
                this.services.getTableService().getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
        }
    }

    private Collection<EventBean> getStreamFilterSnapshot(int streamNum, ContextPartitionSelector contextPartitionSelector) {
        StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs()[streamNum];
        List<ExprNode> filterExpressions = Collections.emptyList();
        if (streamSpec instanceof NamedWindowConsumerStreamSpec) {
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            filterExpressions = namedSpec.getFilterExpressions();
        } else {
            TableQueryStreamSpec tableSpec = (TableQueryStreamSpec)streamSpec;
            filterExpressions = tableSpec.getFilterExpressions();
        }
        FireAndForgetProcessor fireAndForgetProcessor = this.processors[streamNum];
        FireAndForgetInstance processorInstance = fireAndForgetProcessor.getProcessorInstance(this.agentInstanceContext);
        if (processorInstance != null) {
            EPPreparedExecuteTableHelper.assignTableAccessStrategies(this.services, this.statementSpec.getTableNodes(), this.agentInstanceContext);
            return this.getStreamSnapshotInstance(streamNum, filterExpressions, processorInstance);
        }
        Collection<Integer> contextPartitions = EPPreparedExecuteMethodHelper.getAgentInstanceIds(fireAndForgetProcessor, contextPartitionSelector, this.services.getContextManagementService(), fireAndForgetProcessor.getContextName());
        ArrayDeque<EventBean> events = new ArrayDeque<EventBean>();
        for (int agentInstanceId : contextPartitions) {
            processorInstance = fireAndForgetProcessor.getProcessorInstanceContextById(agentInstanceId);
            if (processorInstance == null) continue;
            Collection<EventBean> coll = processorInstance.snapshotBestEffort(this, this.queryGraph, this.statementSpec.getAnnotations());
            events.addAll(coll);
        }
        return events;
    }

    private Collection<EventBean> getStreamSnapshotInstance(int streamNum, List<ExprNode> filterExpressions, FireAndForgetInstance processorInstance) {
        Collection<EventBean> coll = processorInstance.snapshotBestEffort(this, this.queryGraph, this.statementSpec.getAnnotations());
        if (filterExpressions.size() != 0) {
            coll = this.getFiltered(coll, filterExpressions);
        }
        return coll;
    }

    private EPPreparedQueryResult process(Collection<EventBean>[] snapshots) {
        EventBean[] queryResult;
        UniformPair<EventBean[]> results;
        int numStreams = this.processors.length;
        if (numStreams == 1) {
            if (this.statementSpec.getFilterRootNode() != null) {
                snapshots[0] = this.getFiltered(snapshots[0], Arrays.asList(this.statementSpec.getFilterRootNode()));
            }
            EventBean[] rows = snapshots[0].toArray(new EventBean[snapshots[0].size()]);
            results = this.resultSetProcessor.processViewResult(rows, null, true);
        } else {
            Viewable[] viewablePerStream = new Viewable[numStreams];
            for (int i = 0; i < numStreams; ++i) {
                FireAndForgetInstance instance = this.processors[i].getProcessorInstance(this.agentInstanceContext);
                if (instance == null) {
                    throw new UnsupportedOperationException("Joins against named windows that are under context are not supported");
                }
                viewablePerStream[i] = instance.getTailViewInstance();
            }
            JoinSetComposerDesc joinSetComposerDesc = this.joinSetComposerPrototype.create(viewablePerStream, true, this.agentInstanceContext, false);
            JoinSetComposer joinComposer = joinSetComposerDesc.getJoinSetComposer();
            JoinSetFilter joinFilter = joinSetComposerDesc.getPostJoinFilterEvaluator() != null ? new JoinSetFilter(joinSetComposerDesc.getPostJoinFilterEvaluator()) : null;
            EventBean[][] oldDataPerStream = new EventBean[numStreams][];
            EventBean[][] newDataPerStream = new EventBean[numStreams][];
            for (int i = 0; i < numStreams; ++i) {
                newDataPerStream[i] = snapshots[i].toArray(new EventBean[snapshots[i].size()]);
            }
            UniformPair<Set<MultiKey<EventBean>>> result = joinComposer.join(newDataPerStream, oldDataPerStream, this.agentInstanceContext);
            if (joinFilter != null) {
                joinFilter.process(result.getFirst(), null, this.agentInstanceContext);
            }
            results = this.resultSetProcessor.processJoinResult(result.getFirst(), null, true);
        }
        EventBean[] eventBeanArray = queryResult = results == null ? null : results.getFirst();
        if (queryResult != null && this.statementSpec.getSelectClauseSpec().isDistinct()) {
            queryResult = EventBeanUtility.getDistinctByProp(queryResult, this.eventBeanReader);
        }
        return new EPPreparedQueryResult(this.resultEventType, queryResult);
    }

    private Collection<EventBean> getFiltered(Collection<EventBean> snapshot, List<ExprNode> filterExpressions) {
        ArrayDeque<EventBean> deque = new ArrayDeque<EventBean>(Math.min(snapshot.size(), 16));
        ExprNodeUtilityCore.applyFilterExpressionsIterable(snapshot, filterExpressions, this.agentInstanceContext, deque);
        return deque;
    }

    public EPServicesContext getServices() {
        return this.services;
    }

    public ExprTableAccessNode[] getTableNodes() {
        return this.statementSpec.getTableNodes();
    }

    public AgentInstanceContext getAgentInstanceContext() {
        return this.agentInstanceContext;
    }

    private static class ContextPartitionResult {
        private final Collection<EventBean> events;
        private final AgentInstanceContext context;

        private ContextPartitionResult(Collection<EventBean> events, AgentInstanceContext context) {
            this.events = events;
            this.context = context;
        }

        public Collection<EventBean> getEvents() {
            return this.events;
        }

        public AgentInstanceContext getContext() {
            return this.context;
        }
    }
}

