/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.core.service.UpdateDispatchViewBlockingSpin;
import com.espertech.esper.dispatch.Dispatchable;
import com.espertech.esper.timer.TimeSourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDispatchFutureSpin
implements Dispatchable {
    private static final Logger log = LoggerFactory.getLogger(UpdateDispatchFutureSpin.class);
    private UpdateDispatchViewBlockingSpin view;
    private UpdateDispatchFutureSpin earlier;
    private volatile boolean isCompleted;
    private long msecTimeout;
    private TimeSourceService timeSourceService;

    public UpdateDispatchFutureSpin(UpdateDispatchViewBlockingSpin view, UpdateDispatchFutureSpin earlier, long msecTimeout, TimeSourceService timeSourceService) {
        this.view = view;
        this.earlier = earlier;
        this.msecTimeout = msecTimeout;
        this.timeSourceService = timeSourceService;
    }

    public UpdateDispatchFutureSpin(TimeSourceService timeSourceService) {
        this.isCompleted = true;
        this.timeSourceService = timeSourceService;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    @Override
    public void execute() {
        if (!this.earlier.isCompleted) {
            long spinStartTime = this.timeSourceService.getTimeMillis();
            while (!this.earlier.isCompleted) {
                Thread.yield();
                long spinDelta = this.timeSourceService.getTimeMillis() - spinStartTime;
                if (spinDelta <= this.msecTimeout) continue;
                log.info("Spin wait timeout exceeded in listener dispatch for statement '" + this.view.getStatementResultService().getStatementName() + "'");
                break;
            }
        }
        this.view.execute();
        this.isCompleted = true;
        this.earlier = null;
    }
}

