/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.SafeIterator;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import java.util.Iterator;

public class SafeIteratorImpl<E>
implements SafeIterator<E> {
    private final StatementAgentInstanceLock iteratorLock;
    private final Iterator<E> underlying;
    private boolean lockTaken;

    public SafeIteratorImpl(StatementAgentInstanceLock iteratorLock, Iterator<E> underlying) {
        this.iteratorLock = iteratorLock;
        this.underlying = underlying;
        this.lockTaken = true;
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public E next() {
        return this.underlying.next();
    }

    @Override
    public void close() {
        if (this.lockTaken) {
            this.iteratorLock.releaseReadLock();
            this.lockTaken = false;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove operation not supported");
    }
}

