/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.service.ResultDeliveryStrategy;
import com.espertech.esper.core.service.ResultDeliveryStrategyImpl;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.event.NaturalEventBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultDeliveryStrategyObjectArr
implements ResultDeliveryStrategy {
    private static final Logger log = LoggerFactory.getLogger(ResultDeliveryStrategyImpl.class);
    protected final EPStatement statement;
    protected final Object subscriber;
    protected final FastMethod fastMethod;

    public ResultDeliveryStrategyObjectArr(EPStatement statement, Object subscriber, Method method, EngineImportService engineImportService) {
        this.statement = statement;
        this.subscriber = subscriber;
        FastClass fastClass = FastClass.create((ClassLoader)engineImportService.getFastClassClassLoader(subscriber.getClass()), subscriber.getClass());
        this.fastMethod = fastClass.getMethod(method);
    }

    @Override
    public void execute(UniformPair<EventBean[]> result) {
        Object[][] oldData;
        Object[][] newData;
        if (result == null) {
            newData = null;
            oldData = null;
        } else {
            newData = this.convert(result.getFirst());
            oldData = this.convert(result.getSecond());
        }
        Object[] parameters = new Object[]{newData, oldData};
        try {
            this.fastMethod.invoke(this.subscriber, parameters);
        }
        catch (InvocationTargetException e) {
            ResultDeliveryStrategyImpl.handle(this.statement.getName(), log, e, parameters, this.subscriber, this.fastMethod);
        }
    }

    protected Object[][] convert(EventBean[] events) {
        if (events == null || events.length == 0) {
            return null;
        }
        Object[][] result = new Object[events.length][];
        int length = 0;
        for (int i = 0; i < result.length; ++i) {
            if (!(events[i] instanceof NaturalEventBean)) continue;
            NaturalEventBean natural = (NaturalEventBean)events[i];
            result[length] = natural.getNatural();
            ++length;
        }
        if (length == 0) {
            return null;
        }
        if (length != events.length) {
            Object[][] reduced = new Object[length][];
            System.arraycopy(result, 0, reduced, 0, length);
            result = reduced;
        }
        return result;
    }
}

