/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.StatementResultService;
import com.espertech.esper.event.NaturalEventBean;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.ViewSupport;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalRoutePreprocessView
extends ViewSupport {
    private static final Logger log = LoggerFactory.getLogger(InternalRoutePreprocessView.class);
    private final EventType eventType;
    private final StatementResultService statementResultService;

    public InternalRoutePreprocessView(EventType eventType, StatementResultService statementResultService) {
        this.eventType = eventType;
        this.statementResultService = statementResultService;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return CollectionUtil.NULL_EVENT_ITERATOR;
    }

    public boolean isIndicate() {
        return this.statementResultService.isMakeNatural() || this.statementResultService.isMakeSynthetic();
    }

    public void indicate(EventBean newEvent, EventBean oldEvent) {
        try {
            if (this.statementResultService.isMakeNatural()) {
                NaturalEventBean natural = new NaturalEventBean(this.eventType, new Object[]{newEvent.getUnderlying()}, newEvent);
                NaturalEventBean naturalOld = new NaturalEventBean(this.eventType, new Object[]{oldEvent.getUnderlying()}, oldEvent);
                this.updateChildren(new NaturalEventBean[]{natural}, new NaturalEventBean[]{naturalOld});
            } else {
                this.updateChildren(new EventBean[]{newEvent}, new EventBean[]{oldEvent});
            }
        }
        catch (RuntimeException ex) {
            log.error("Unexpected error updating child view: " + ex.getMessage());
        }
    }

    public StatementResultService getStatementResultService() {
        return this.statementResultService;
    }
}

