/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.service.InternalEventRouterEntry;
import com.espertech.esper.core.service.InternalRoutePreprocessView;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.event.EventBeanCopyMethod;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalEventRouterPreprocessor {
    private static final Logger log = LoggerFactory.getLogger(InternalEventRouterPreprocessor.class);
    private static final Comparator<InternalEventRouterEntry> COMPARATOR = new Comparator<InternalEventRouterEntry>(){

        @Override
        public int compare(InternalEventRouterEntry o1, InternalEventRouterEntry o2) {
            if (o1.getPriority() > o2.getPriority()) {
                return 1;
            }
            if (o1.getPriority() < o2.getPriority()) {
                return -1;
            }
            if (o1.isDrop()) {
                return -1;
            }
            if (o2.isDrop()) {
                return -1;
            }
            return 0;
        }
    };
    private final EventBeanCopyMethod copyMethod;
    private final InternalEventRouterEntry[] entries;
    private final boolean empty;

    public InternalEventRouterPreprocessor(EventBeanCopyMethod copyMethod, List<InternalEventRouterEntry> entries) {
        this.copyMethod = copyMethod;
        Collections.sort(entries, COMPARATOR);
        this.entries = entries.toArray(new InternalEventRouterEntry[entries.size()]);
        this.empty = this.entries.length == 0;
    }

    public EventBean process(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        InternalRoutePreprocessView view;
        if (this.empty) {
            return theEvent;
        }
        EventBean oldEvent = theEvent;
        boolean haveCloned = false;
        EventBean[] eventsPerStream = new EventBean[]{theEvent};
        InternalEventRouterEntry lastEntry = null;
        for (int i = 0; i < this.entries.length; ++i) {
            Boolean result;
            InternalEventRouterEntry entry = this.entries[i];
            ExprEvaluator whereClause = entry.getOptionalWhereClause();
            if (whereClause != null && ((result = (Boolean)whereClause.evaluate(eventsPerStream, true, exprEvaluatorContext)) == null || !result.booleanValue())) continue;
            if (entry.isDrop()) {
                return null;
            }
            if (lastEntry != null) {
                InternalRoutePreprocessView view2 = lastEntry.getOutputView();
                if (view2.isIndicate()) {
                    EventBean copied = this.copyMethod.copy(theEvent);
                    view2.indicate(copied, oldEvent);
                    oldEvent = copied;
                } else if (this.entries[i].getOutputView().isIndicate()) {
                    oldEvent = this.copyMethod.copy(theEvent);
                }
            }
            if (!haveCloned) {
                EventBean copiedEvent = this.copyMethod.copy(theEvent);
                if (copiedEvent == null) {
                    log.warn("Event of type " + theEvent.getEventType().getName() + " could not be copied");
                    return null;
                }
                haveCloned = true;
                eventsPerStream[0] = copiedEvent;
                theEvent = copiedEvent;
            }
            this.apply(theEvent, eventsPerStream, entry, exprEvaluatorContext);
            lastEntry = entry;
        }
        if (lastEntry != null && (view = lastEntry.getOutputView()).isIndicate()) {
            view.indicate(theEvent, oldEvent);
        }
        return theEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(EventBean theEvent, EventBean[] eventsPerStream, InternalEventRouterEntry entry, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] values;
        if (entry.isHasSubselect()) {
            entry.getAgentInstanceLock().acquireWriteLock();
            try {
                values = this.obtainValues(eventsPerStream, entry, exprEvaluatorContext);
            }
            finally {
                entry.getAgentInstanceLock().releaseWriteLock();
            }
        } else {
            values = this.obtainValues(eventsPerStream, entry, exprEvaluatorContext);
        }
        entry.getWriter().write(values, theEvent);
    }

    private Object[] obtainValues(EventBean[] eventsPerStream, InternalEventRouterEntry entry, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] values = new Object[entry.getAssignments().length];
        for (int i = 0; i < entry.getAssignments().length; ++i) {
            Object value = entry.getAssignments()[i].evaluate(eventsPerStream, true, exprEvaluatorContext);
            if (value != null && entry.getWideners()[i] != null) {
                value = entry.getWideners()[i].widen(value);
            }
            values[i] = value;
        }
        return values;
    }
}

