/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.context.ContextPartitionCollection;
import com.espertech.esper.client.context.ContextPartitionDescriptor;
import com.espertech.esper.client.context.ContextPartitionSelector;
import com.espertech.esper.client.context.ContextPartitionSelectorById;
import com.espertech.esper.client.context.ContextPartitionState;
import com.espertech.esper.client.context.ContextPartitionStateListener;
import com.espertech.esper.client.context.ContextStateListener;
import com.espertech.esper.core.context.mgr.AgentInstanceSelector;
import com.espertech.esper.core.context.mgr.ContextControllerState;
import com.espertech.esper.core.context.mgr.ContextControllerStatementDesc;
import com.espertech.esper.core.context.mgr.ContextManager;
import com.espertech.esper.core.context.mgr.ContextStateCache;
import com.espertech.esper.core.context.mgr.ContextStatePathDescriptor;
import com.espertech.esper.core.context.mgr.ContextStatePathKey;
import com.espertech.esper.core.context.mgr.ContextStatePathValue;
import com.espertech.esper.core.context.util.ContextPartitionImportCallback;
import com.espertech.esper.core.service.EPContextPartitionAdminSPI;
import com.espertech.esper.core.service.EPContextPartitionExtract;
import com.espertech.esper.core.service.EPContextPartitionImportResult;
import com.espertech.esper.core.service.EPContextPartitionImportable;
import com.espertech.esper.core.service.EPServicesContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class EPContextPartitionAdminImpl
implements EPContextPartitionAdminSPI {
    private final EPServicesContext services;

    public EPContextPartitionAdminImpl(EPServicesContext services) {
        this.services = services;
    }

    @Override
    public boolean isSupportsExtract() {
        return this.services.getContextManagerFactoryService().isSupportsExtract();
    }

    @Override
    public String[] getContextStatementNames(String contextName) {
        ContextManager contextManager = this.services.getContextManagementService().getContextManager(contextName);
        if (contextManager == null) {
            return null;
        }
        String[] statements = new String[contextManager.getStatements().size()];
        int count = 0;
        for (Map.Entry<Integer, ContextControllerStatementDesc> entry : contextManager.getStatements().entrySet()) {
            statements[count++] = entry.getValue().getStatement().getStatementContext().getStatementName();
        }
        return statements;
    }

    @Override
    public int getContextNestingLevel(String contextName) {
        ContextManager contextManager = this.checkedGetContextManager(contextName);
        return contextManager.getNumNestingLevels();
    }

    @Override
    public Map<String, Object> getContextProperties(String contextName, int contextPartitionId) {
        ContextManager contextManager = this.checkedGetContextManager(contextName);
        return contextManager.getContextProperties(contextPartitionId);
    }

    @Override
    public ContextPartitionCollection destroyContextPartitions(String contextName, ContextPartitionSelector selector) {
        ContextManager contextManager = this.checkedGetContextManager(contextName);
        ContextStatePathDescriptor descriptor = contextManager.extractDestroyPaths(selector);
        return new ContextPartitionCollection(descriptor.getContextPartitionInformation());
    }

    @Override
    public ContextPartitionDescriptor destroyContextPartition(String contextName, int agentInstanceId) {
        ContextManager contextManager = this.checkedGetContextManager(contextName);
        ContextStatePathDescriptor descriptor = contextManager.extractDestroyPaths(new CPSelectorById(agentInstanceId));
        return descriptor.getContextPartitionInformation().get(agentInstanceId);
    }

    @Override
    public EPContextPartitionExtract extractDestroyPaths(String contextName, ContextPartitionSelector selector) {
        ContextManager contextManager = this.checkedGetContextManager(contextName);
        ContextStatePathDescriptor descriptor = contextManager.extractDestroyPaths(selector);
        return this.descriptorToExtract(contextManager.getNumNestingLevels(), descriptor);
    }

    @Override
    public ContextPartitionCollection stopContextPartitions(String contextName, ContextPartitionSelector selector) {
        ContextManager contextManager = this.checkedGetContextManager(contextName);
        ContextStatePathDescriptor descriptor = contextManager.extractStopPaths(selector);
        return new ContextPartitionCollection(descriptor.getContextPartitionInformation());
    }

    @Override
    public ContextPartitionCollection startContextPartitions(String contextName, ContextPartitionSelector selector) {
        ContextManager contextManager = this.checkedGetContextManager(contextName);
        return new ContextPartitionCollection(contextManager.startPaths(selector));
    }

    @Override
    public ContextPartitionCollection getContextPartitions(String contextName, ContextPartitionSelector selector) {
        ContextManager contextManager = this.checkedGetContextManager(contextName);
        return new ContextPartitionCollection(contextManager.extractPaths(selector).getContextPartitionInformation());
    }

    @Override
    public ContextPartitionDescriptor stopContextPartition(String contextName, int agentInstanceId) {
        ContextManager contextManager = this.checkedGetContextManager(contextName);
        ContextStatePathDescriptor descriptor = contextManager.extractStopPaths(new CPSelectorById(agentInstanceId));
        return descriptor.getContextPartitionInformation().get(agentInstanceId);
    }

    @Override
    public ContextPartitionDescriptor startContextPartition(String contextName, int agentInstanceId) {
        ContextManager contextManager = this.checkedGetContextManager(contextName);
        Map<Integer, ContextPartitionDescriptor> descriptorMap = contextManager.startPaths(new CPSelectorById(agentInstanceId));
        return descriptorMap.get(agentInstanceId);
    }

    @Override
    public ContextPartitionDescriptor getDescriptor(String contextName, int agentInstanceId) {
        ContextManager contextManager = this.checkedGetContextManager(contextName);
        ContextStatePathDescriptor descriptor = contextManager.extractPaths(new CPSelectorById(agentInstanceId));
        return descriptor.getContextPartitionInformation().get(agentInstanceId);
    }

    @Override
    public EPContextPartitionExtract extractStopPaths(String contextName, ContextPartitionSelector selector) {
        ContextManager contextManager = this.checkedGetContextManager(contextName);
        ContextStatePathDescriptor descriptor = contextManager.extractStopPaths(selector);
        return this.descriptorToExtract(contextManager.getNumNestingLevels(), descriptor);
    }

    @Override
    public EPContextPartitionExtract extractPaths(String contextName, ContextPartitionSelector selector) {
        ContextManager contextManager = this.checkedGetContextManager(contextName);
        ContextStatePathDescriptor contextPaths = contextManager.extractPaths(selector);
        return this.descriptorToExtract(contextManager.getNumNestingLevels(), contextPaths);
    }

    @Override
    public Set<Integer> getContextPartitionIds(String contextName, ContextPartitionSelector selector) {
        ContextManager contextManager = this.checkedGetContextManager(contextName);
        return new HashSet<Integer>(contextManager.getAgentInstanceIds(selector));
    }

    @Override
    public EPContextPartitionImportResult importStartPaths(String contextName, EPContextPartitionImportable importable, AgentInstanceSelector agentInstanceSelector) {
        ContextManager contextManager = this.checkedGetContextManager(contextName);
        CPImportCallback importCallback = new CPImportCallback();
        ContextControllerState state = new ContextControllerState(importable.getPaths(), true, importCallback);
        contextManager.importStartPaths(state, agentInstanceSelector);
        ContextStateCache contextStateCache = contextManager.getContextStateCache();
        for (Map.Entry<ContextStatePathKey, ContextStatePathValue> entry : importable.getPaths().entrySet()) {
            entry.getValue().setState(ContextPartitionState.STARTED);
            contextStateCache.updateContextPath(contextName, entry.getKey(), entry.getValue());
        }
        return new EPContextPartitionImportResult(importCallback.existingToImported, importCallback.allocatedToImported);
    }

    @Override
    public void addContextStateListener(ContextStateListener listener) {
        this.services.getContextManagementService().getListeners().add(listener);
    }

    @Override
    public void removeContextStateListener(ContextStateListener listener) {
        this.services.getContextManagementService().getListeners().remove(listener);
    }

    @Override
    public Iterator<ContextStateListener> getContextStateListeners() {
        return Collections.unmodifiableList(this.services.getContextManagementService().getListeners()).iterator();
    }

    @Override
    public void removeContextStateListeners() {
        this.services.getContextManagementService().getListeners().clear();
    }

    @Override
    public void addContextPartitionStateListener(String contextName, ContextPartitionStateListener listener) {
        this.checkedGetContextManager(contextName).addListener(listener);
    }

    @Override
    public void removeContextPartitionStateListener(String contextName, ContextPartitionStateListener listener) {
        this.checkedGetContextManager(contextName).removeListener(listener);
    }

    @Override
    public Iterator<ContextPartitionStateListener> getContextPartitionStateListeners(String contextName) {
        return this.checkedGetContextManager(contextName).getListeners();
    }

    @Override
    public void removeContextPartitionStateListeners(String contextName) {
        this.checkedGetContextManager(contextName).removeListeners();
    }

    private ContextManager checkedGetContextManager(String contextName) {
        ContextManager contextManager = this.services.getContextManagementService().getContextManager(contextName);
        if (contextManager == null) {
            throw new IllegalArgumentException("Context by name '" + contextName + "' could not be found");
        }
        return contextManager;
    }

    private EPContextPartitionExtract descriptorToExtract(int numNestingLevels, ContextStatePathDescriptor contextPaths) {
        EPContextPartitionImportable importable = new EPContextPartitionImportable(contextPaths.getPaths());
        return new EPContextPartitionExtract(new ContextPartitionCollection(contextPaths.getContextPartitionInformation()), importable, numNestingLevels);
    }

    public static class CPSelectorById
    implements ContextPartitionSelectorById {
        private final int agentInstanceId;

        public CPSelectorById(int agentInstanceId) {
            this.agentInstanceId = agentInstanceId;
        }

        @Override
        public Set<Integer> getContextPartitionIds() {
            return Collections.singleton(this.agentInstanceId);
        }
    }

    public static class CPImportCallback
    implements ContextPartitionImportCallback {
        private final Map<Integer, Integer> existingToImported = new HashMap<Integer, Integer>();
        private final Map<Integer, Integer> allocatedToImported = new HashMap<Integer, Integer>();

        @Override
        public void existing(int agentInstanceId, int exportedAgentInstanceId) {
            this.existingToImported.put(agentInstanceId, exportedAgentInstanceId);
        }

        @Override
        public void allocated(int agentInstanceId, int exportedAgentInstanceId) {
            this.allocatedToImported.put(agentInstanceId, exportedAgentInstanceId);
        }
    }
}

