/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.util;

import com.espertech.esper.epl.spec.ContextDetail;
import com.espertech.esper.epl.spec.ContextDetailCategory;
import com.espertech.esper.epl.spec.ContextDetailCondition;
import com.espertech.esper.epl.spec.ContextDetailConditionFilter;
import com.espertech.esper.epl.spec.ContextDetailConditionPattern;
import com.espertech.esper.epl.spec.ContextDetailHash;
import com.espertech.esper.epl.spec.ContextDetailHashItem;
import com.espertech.esper.epl.spec.ContextDetailInitiatedTerminated;
import com.espertech.esper.epl.spec.ContextDetailNested;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.epl.spec.ContextDetailPartitioned;
import com.espertech.esper.epl.spec.CreateContextDesc;
import com.espertech.esper.filterspec.FilterSpecCompiled;
import com.espertech.esper.pattern.EvalFilterFactoryNode;
import com.espertech.esper.pattern.EvalNodeAnalysisResult;
import com.espertech.esper.pattern.EvalNodeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ContextDetailUtil {
    public static List<FilterSpecCompiled> getFilterSpecs(ContextDetail detail) {
        if (detail instanceof ContextDetailInitiatedTerminated) {
            ContextDetailInitiatedTerminated initTerm = (ContextDetailInitiatedTerminated)detail;
            List<FilterSpecCompiled> startFS = ContextDetailUtil.getFilterSpecIfAny(initTerm.getStart());
            List<FilterSpecCompiled> endFS = ContextDetailUtil.getFilterSpecIfAny(initTerm.getEnd());
            if (startFS == null && endFS == null) {
                return Collections.emptyList();
            }
            ArrayList<FilterSpecCompiled> filters = new ArrayList<FilterSpecCompiled>(2);
            if (startFS != null) {
                filters.addAll(startFS);
            }
            if (endFS != null) {
                filters.addAll(endFS);
            }
            return filters;
        }
        if (detail instanceof ContextDetailCategory) {
            ArrayList<FilterSpecCompiled> filters = new ArrayList<FilterSpecCompiled>(1);
            filters.add(((ContextDetailCategory)detail).getFilterSpecCompiled());
            return filters;
        }
        if (detail instanceof ContextDetailHash) {
            ContextDetailHash hash = (ContextDetailHash)detail;
            ArrayList<FilterSpecCompiled> filters = new ArrayList<FilterSpecCompiled>(hash.getItems().size());
            for (ContextDetailHashItem item : hash.getItems()) {
                filters.add(item.getFilterSpecCompiled());
            }
            return filters;
        }
        if (detail instanceof ContextDetailNested) {
            ContextDetailNested nested = (ContextDetailNested)detail;
            ArrayList<FilterSpecCompiled> filterSpecs = new ArrayList<FilterSpecCompiled>(2);
            for (CreateContextDesc desc : nested.getContexts()) {
                filterSpecs.addAll(ContextDetailUtil.getFilterSpecs(desc.getContextDetail()));
            }
            return filterSpecs;
        }
        if (detail instanceof ContextDetailPartitioned) {
            List<FilterSpecCompiled> specs;
            ContextDetailPartitioned partitioned = (ContextDetailPartitioned)detail;
            ArrayList<FilterSpecCompiled> filters = new ArrayList<FilterSpecCompiled>(partitioned.getItems().size());
            for (ContextDetailPartitionItem item : partitioned.getItems()) {
                filters.add(item.getFilterSpecCompiled());
            }
            if (partitioned.getOptionalInit() != null) {
                for (ContextDetailConditionFilter filter : partitioned.getOptionalInit()) {
                    filters.add(filter.getFilterSpecCompiled());
                }
            }
            if (partitioned.getOptionalTermination() != null && (specs = ContextDetailUtil.getFilterSpecIfAny(partitioned.getOptionalTermination())) != null) {
                filters.addAll(specs);
            }
            return filters;
        }
        throw new IllegalStateException("Unrecognized context detail " + detail);
    }

    public static List<FilterSpecCompiled> getFilterSpecIfAny(ContextDetailCondition detail) {
        if (detail instanceof ContextDetailConditionFilter) {
            ContextDetailConditionFilter filter = (ContextDetailConditionFilter)detail;
            return Collections.singletonList(filter.getFilterSpecCompiled());
        }
        if (detail instanceof ContextDetailConditionPattern) {
            ContextDetailConditionPattern pattern = (ContextDetailConditionPattern)detail;
            EvalNodeAnalysisResult result = EvalNodeUtil.recursiveAnalyzeChildNodes(pattern.getPatternCompiled().getEvalFactoryNode());
            if (result.getFilterNodes().isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList filters = new ArrayList();
            List<EvalFilterFactoryNode> filterNodes = result.getFilterNodes();
            for (EvalFilterFactoryNode filterNode : filterNodes) {
                filters.add(filterNode.getFilterSpec());
            }
            return filters.isEmpty() ? Collections.emptyList() : filters;
        }
        return Collections.emptyList();
    }
}

