/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.util;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.SafeIterator;
import com.espertech.esper.client.context.ContextPartitionSelector;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistryFactory;
import com.espertech.esper.core.context.util.ContextIteratorHandler;
import com.espertech.esper.core.context.util.ContextPropertyRegistry;
import com.espertech.esper.epl.spec.ContextDetail;
import java.util.Iterator;

public class ContextDescriptor {
    private final String contextName;
    private final boolean singleInstanceContext;
    private final ContextPropertyRegistry contextPropertyRegistry;
    private final StatementAIResourceRegistryFactory aiResourceRegistryFactory;
    private final ContextIteratorHandler iteratorHandler;
    private final ContextDetail contextDetail;

    public ContextDescriptor(String contextName, boolean singleInstanceContext, ContextPropertyRegistry contextPropertyRegistry, StatementAIResourceRegistryFactory aiResourceRegistryFactory, ContextIteratorHandler iteratorHandler, ContextDetail contextDetail) {
        this.contextName = contextName;
        this.singleInstanceContext = singleInstanceContext;
        this.contextPropertyRegistry = contextPropertyRegistry;
        this.aiResourceRegistryFactory = aiResourceRegistryFactory;
        this.iteratorHandler = iteratorHandler;
        this.contextDetail = contextDetail;
    }

    public String getContextName() {
        return this.contextName;
    }

    public boolean isSingleInstanceContext() {
        return this.singleInstanceContext;
    }

    public ContextPropertyRegistry getContextPropertyRegistry() {
        return this.contextPropertyRegistry;
    }

    public StatementAIResourceRegistryFactory getAiResourceRegistryFactory() {
        return this.aiResourceRegistryFactory;
    }

    public Iterator<EventBean> iterator(int statementId) {
        return this.iteratorHandler.iterator(statementId);
    }

    public SafeIterator<EventBean> safeIterator(int statementId) {
        return this.iteratorHandler.safeIterator(statementId);
    }

    public Iterator<EventBean> iterator(int statementId, ContextPartitionSelector selector) {
        return this.iteratorHandler.iterator(statementId, selector);
    }

    public SafeIterator<EventBean> safeIterator(int statementId, ContextPartitionSelector selector) {
        return this.iteratorHandler.safeIterator(statementId, selector);
    }

    public ContextDetail getContextDetail() {
        return this.contextDetail;
    }
}

