/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.subselect;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.factory.StatementAgentInstancePostLoad;
import com.espertech.esper.core.context.factory.StatementAgentInstancePostLoadIndexVisitor;
import com.espertech.esper.core.context.subselect.SubSelectActivationHolder;
import com.espertech.esper.core.context.subselect.SubSelectStrategyFactory;
import com.espertech.esper.core.context.subselect.SubSelectStrategyRealization;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.start.EPStatementStartMethodHelperPrevious;
import com.espertech.esper.core.start.EPStatementStartMethodHelperPrior;
import com.espertech.esper.epl.agg.service.common.AggregationService;
import com.espertech.esper.epl.agg.service.common.AggregationServiceFactoryDesc;
import com.espertech.esper.epl.core.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.epl.core.viewres.ViewResourceDelegateVerified;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.prev.ExprPreviousEvalStrategy;
import com.espertech.esper.epl.expression.prev.ExprPreviousNode;
import com.espertech.esper.epl.expression.prior.ExprPriorEvalStrategy;
import com.espertech.esper.epl.expression.prior.ExprPriorNode;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableFactory;
import com.espertech.esper.epl.join.table.EventTableFactoryTableIdentAgentInstanceSubq;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategyFactory;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategyNullRow;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.named.NamedWindowTailViewInstance;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.subquery.SubqueryStopCallback;
import com.espertech.esper.epl.subquery.SubselectAggregationPreprocessorBase;
import com.espertech.esper.epl.subquery.SubselectAggregationPreprocessorFilteredGrouped;
import com.espertech.esper.epl.subquery.SubselectAggregationPreprocessorFilteredUngrouped;
import com.espertech.esper.epl.subquery.SubselectAggregationPreprocessorUnfilteredGrouped;
import com.espertech.esper.epl.subquery.SubselectAggregationPreprocessorUnfilteredUngrouped;
import com.espertech.esper.epl.subquery.SubselectAggregatorViewBase;
import com.espertech.esper.epl.subquery.SubselectAggregatorViewFilteredGrouped;
import com.espertech.esper.epl.subquery.SubselectAggregatorViewFilteredUngrouped;
import com.espertech.esper.epl.subquery.SubselectAggregatorViewUnfilteredGrouped;
import com.espertech.esper.epl.subquery.SubselectAggregatorViewUnfilteredUngrouped;
import com.espertech.esper.epl.subquery.SubselectBufferObserver;
import com.espertech.esper.epl.util.EPLValidationUtil;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewServiceCreateResult;
import com.espertech.esper.view.Viewable;
import com.espertech.esper.view.internal.BufferView;
import com.espertech.esper.view.internal.PriorEventViewFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubSelectStrategyFactoryLocalViewPreloaded
implements SubSelectStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(SubSelectStrategyFactoryLocalViewPreloaded.class);
    private static final SubordTableLookupStrategyNullRow NULL_ROW_STRATEGY = new SubordTableLookupStrategyNullRow();
    private final int subqueryNumber;
    private final SubSelectActivationHolder subSelectHolder;
    private final Pair<EventTableFactory, SubordTableLookupStrategyFactory> pair;
    private final ExprNode filterExprNode;
    private final ExprEvaluator filterExprEval;
    private final boolean correlatedSubquery;
    private final AggregationServiceFactoryDesc aggregationServiceFactory;
    private final ViewResourceDelegateVerified viewResourceDelegate;
    private final ExprEvaluator[] groupKeys;

    public SubSelectStrategyFactoryLocalViewPreloaded(int subqueryNumber, SubSelectActivationHolder subSelectHolder, Pair<EventTableFactory, SubordTableLookupStrategyFactory> pair, ExprNode filterExprNode, ExprEvaluator filterExprEval, boolean correlatedSubquery, AggregationServiceFactoryDesc aggregationServiceFactory, ViewResourceDelegateVerified viewResourceDelegate, ExprEvaluator[] groupKeys) {
        this.subqueryNumber = subqueryNumber;
        this.subSelectHolder = subSelectHolder;
        this.pair = pair;
        this.filterExprNode = filterExprNode;
        this.filterExprEval = filterExprEval;
        this.correlatedSubquery = correlatedSubquery;
        this.aggregationServiceFactory = aggregationServiceFactory;
        this.viewResourceDelegate = viewResourceDelegate;
        this.groupKeys = groupKeys;
    }

    @Override
    public SubSelectStrategyRealization instantiate(final EPServicesContext services, Viewable viewableRoot, final AgentInstanceContext agentInstanceContext, List<StopCallback> stopCallbackList, int subqueryNumber, boolean isRecoveringResilient) {
        StatementAgentInstancePostLoad postLoad;
        boolean hasPrior;
        List<ViewFactory> viewFactoryChain = this.subSelectHolder.getViewFactoryChain().getViewFactoryChain();
        boolean bl = hasPrior = this.viewResourceDelegate.getPerStream()[0].getPriorRequests() != null && !this.viewResourceDelegate.getPerStream()[0].getPriorRequests().isEmpty();
        if (hasPrior) {
            PriorEventViewFactory priorEventViewFactory = EPStatementStartMethodHelperPrior.getPriorEventViewFactory(agentInstanceContext.getStatementContext(), 1024 + this.subqueryNumber, viewFactoryChain.isEmpty(), true, subqueryNumber);
            viewFactoryChain = new ArrayList<ViewFactory>(viewFactoryChain);
            viewFactoryChain.add(priorEventViewFactory);
        }
        AgentInstanceViewFactoryChainContext viewFactoryChainContext = AgentInstanceViewFactoryChainContext.create(viewFactoryChain, agentInstanceContext, this.viewResourceDelegate.getPerStream()[0]);
        ViewServiceCreateResult createResult = services.getViewService().createViews(viewableRoot, viewFactoryChain, viewFactoryChainContext, false);
        final Viewable subselectView = createResult.getFinalViewable();
        AggregationService aggregationService = null;
        if (this.aggregationServiceFactory != null) {
            aggregationService = this.aggregationServiceFactory.getAggregationServiceFactory().makeService(agentInstanceContext, agentInstanceContext.getEngineImportService(), true, subqueryNumber);
        }
        Map<ExprPriorNode, ExprPriorEvalStrategy> priorNodeStrategies = EPStatementStartMethodHelperPrior.compilePriorNodeStrategies(this.viewResourceDelegate, new AgentInstanceViewFactoryChainContext[]{viewFactoryChainContext});
        Map<ExprPreviousNode, ExprPreviousEvalStrategy> previousNodeStrategies = EPStatementStartMethodHelperPrevious.compilePreviousNodeStrategies(this.viewResourceDelegate, new AgentInstanceViewFactoryChainContext[]{viewFactoryChainContext});
        if (this.aggregationServiceFactory != null && !this.correlatedSubquery) {
            SubselectAggregatorViewBase aggregatorView = this.groupKeys == null ? (this.filterExprEval == null ? new SubselectAggregatorViewUnfilteredUngrouped(aggregationService, this.filterExprEval, agentInstanceContext, null) : new SubselectAggregatorViewFilteredUngrouped(aggregationService, this.filterExprEval, agentInstanceContext, null, this.filterExprNode)) : (this.filterExprEval == null ? new SubselectAggregatorViewUnfilteredGrouped(aggregationService, this.filterExprEval, agentInstanceContext, this.groupKeys) : new SubselectAggregatorViewFilteredGrouped(aggregationService, this.filterExprEval, agentInstanceContext, this.groupKeys, this.filterExprNode));
            subselectView.addView(aggregatorView);
            if (services.getEventTableIndexService().allowInitIndex(isRecoveringResilient)) {
                this.preload(services, null, aggregatorView, agentInstanceContext);
            }
            return new SubSelectStrategyRealization(NULL_ROW_STRATEGY, null, aggregationService, priorNodeStrategies, previousNodeStrategies, subselectView, null);
        }
        final EventTable[] index = this.pair.getFirst().makeEventTables(new EventTableFactoryTableIdentAgentInstanceSubq(agentInstanceContext, this.subqueryNumber), agentInstanceContext);
        stopCallbackList.add(new SubqueryStopCallback(index));
        SubordTableLookupStrategy strategy = this.pair.getSecond().makeStrategy(index, null);
        SubselectAggregationPreprocessorBase subselectAggregationPreprocessor = null;
        if (this.aggregationServiceFactory != null) {
            subselectAggregationPreprocessor = this.groupKeys == null ? (this.filterExprEval == null ? new SubselectAggregationPreprocessorUnfilteredUngrouped(aggregationService, this.filterExprEval, null) : new SubselectAggregationPreprocessorFilteredUngrouped(aggregationService, this.filterExprEval, null)) : (this.filterExprEval == null ? new SubselectAggregationPreprocessorUnfilteredGrouped(aggregationService, this.filterExprEval, this.groupKeys) : new SubselectAggregationPreprocessorFilteredGrouped(aggregationService, this.filterExprEval, this.groupKeys));
        }
        if (services.getEventTableIndexService().allowInitIndex(isRecoveringResilient)) {
            this.preload(services, index, subselectView, agentInstanceContext);
            postLoad = new StatementAgentInstancePostLoad(){

                @Override
                public void executePostLoad() {
                    SubSelectStrategyFactoryLocalViewPreloaded.this.preload(services, index, subselectView, agentInstanceContext);
                }

                @Override
                public void acceptIndexVisitor(StatementAgentInstancePostLoadIndexVisitor visitor) {
                    for (EventTable table : index) {
                        visitor.visit(table);
                    }
                }
            };
        } else {
            postLoad = new StatementAgentInstancePostLoad(){

                @Override
                public void executePostLoad() {
                }

                @Override
                public void acceptIndexVisitor(StatementAgentInstancePostLoadIndexVisitor visitor) {
                    for (EventTable table : index) {
                        visitor.visit(table);
                    }
                }
            };
        }
        BufferView bufferView = new BufferView(this.subSelectHolder.getStreamNumber());
        bufferView.setObserver(new SubselectBufferObserver(index, agentInstanceContext));
        subselectView.addView(bufferView);
        return new SubSelectStrategyRealization(strategy, subselectAggregationPreprocessor, aggregationService, priorNodeStrategies, previousNodeStrategies, subselectView, postLoad);
    }

    private void preload(EPServicesContext services, EventTable[] eventIndex, Viewable subselectView, AgentInstanceContext agentInstanceContext) {
        block12: {
            block11: {
                ArrayList<EventBean> eventsInWindow;
                if (!(this.subSelectHolder.getStreamSpecCompiled() instanceof NamedWindowConsumerStreamSpec)) break block11;
                NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)this.subSelectHolder.getStreamSpecCompiled();
                NamedWindowProcessor processor = services.getNamedWindowMgmtService().getProcessor(namedSpec.getWindowName());
                if (processor == null) {
                    throw new RuntimeException("Failed to find named window by name '" + namedSpec.getWindowName() + "'");
                }
                NamedWindowProcessorInstance processorInstance = processor.getProcessorInstance(agentInstanceContext);
                if (processorInstance == null) {
                    throw new EPException("Named window '" + namedSpec.getWindowName() + "' is associated to context '" + processor.getContextName() + "' that is not available for querying");
                }
                NamedWindowTailViewInstance consumerView = processorInstance.getTailViewInstance();
                if (namedSpec.getFilterExpressions() != null && !namedSpec.getFilterExpressions().isEmpty()) {
                    StreamTypeServiceImpl types = new StreamTypeServiceImpl(consumerView.getEventType(), consumerView.getEventType().getName(), false, services.getEngineURI());
                    QueryGraph queryGraph = EPLValidationUtil.validateFilterGetQueryGraphSafe(ExprNodeUtilityRich.connectExpressionsByLogicalAndWhenNeeded(namedSpec.getFilterExpressions()), agentInstanceContext.getStatementContext(), types);
                    Collection<EventBean> snapshot = consumerView.snapshotNoLock(queryGraph, agentInstanceContext.getAnnotations());
                    eventsInWindow = new ArrayList(snapshot.size());
                    ExprNodeUtilityCore.applyFilterExpressionsIterable(snapshot, namedSpec.getFilterExpressions(), agentInstanceContext, eventsInWindow);
                } else {
                    eventsInWindow = new ArrayList<EventBean>();
                    Iterator<EventBean> it = consumerView.iterator();
                    while (it.hasNext()) {
                        eventsInWindow.add(it.next());
                    }
                }
                EventBean[] newEvents = eventsInWindow.toArray(new EventBean[eventsInWindow.size()]);
                if (subselectView != null) {
                    ((View)subselectView).update(newEvents, null);
                }
                if (eventIndex == null) break block12;
                for (EventTable table : eventIndex) {
                    table.add(newEvents, (ExprEvaluatorContext)agentInstanceContext);
                }
                break block12;
            }
            Iterator<EventBean> it = subselectView.iterator();
            if (it != null && it.hasNext()) {
                ArrayList<EventBean> preloadEvents = new ArrayList<EventBean>();
                while (it.hasNext()) {
                    preloadEvents.add(it.next());
                }
                if (eventIndex != null) {
                    for (EventTable table : eventIndex) {
                        table.add(preloadEvents.toArray(new EventBean[preloadEvents.size()]), (ExprEvaluatorContext)agentInstanceContext);
                    }
                }
            }
        }
    }
}

