/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.context.ContextPartitionDescriptor;
import com.espertech.esper.client.context.ContextPartitionIdentifier;
import com.espertech.esper.client.context.ContextPartitionIdentifierNested;
import com.espertech.esper.client.context.ContextPartitionState;
import com.espertech.esper.core.context.mgr.ContextController;
import com.espertech.esper.core.context.mgr.ContextControllerFactory;
import com.espertech.esper.core.context.mgr.ContextControllerInstanceHandle;
import com.espertech.esper.core.context.mgr.ContextControllerTreeEntry;
import com.espertech.esper.core.context.mgr.ContextManagerNested;
import com.espertech.esper.core.context.mgr.ContextPartitionVisitorWithPath;
import com.espertech.esper.core.context.mgr.ContextStatePathKey;
import com.espertech.esper.core.context.mgr.ContextStatePathValue;
import com.espertech.esper.core.context.mgr.ContextStatePathValueBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ContextPartitionVisitorStateWithPath
implements ContextPartitionVisitorWithPath {
    private final ContextControllerFactory[] nestedFactories;
    private final Map<ContextController, ContextControllerTreeEntry> subcontexts;
    private final TreeMap<ContextStatePathKey, ContextStatePathValue> states = new TreeMap();
    private final ArrayList<Integer> subpaths = new ArrayList();
    private final Map<ContextController, List<LeafDesc>> controllerAgentInstances = new HashMap<ContextController, List<LeafDesc>>();
    private final Map<Integer, ContextPartitionDescriptor> agentInstanceInfo = new HashMap<Integer, ContextPartitionDescriptor>();

    public ContextPartitionVisitorStateWithPath(ContextControllerFactory[] nestedFactories, Map<ContextController, ContextControllerTreeEntry> subcontexts) {
        this.nestedFactories = nestedFactories;
        this.subcontexts = subcontexts;
    }

    @Override
    public void visit(int nestingLevel, int pathId, ContextStatePathValueBinding binding, Object payload, ContextController contextController, ContextControllerInstanceHandle instanceHandle) {
        ContextStatePathKey key = new ContextStatePathKey(nestingLevel, pathId, instanceHandle.getSubPathId());
        int maxNestingLevel = this.nestedFactories.length;
        int contextPartitionOrSubPath = instanceHandle.getContextPartitionOrPathId();
        if (contextController.getFactory().getFactoryContext().getNestingLevel() == maxNestingLevel) {
            List<LeafDesc> agentInstances = this.controllerAgentInstances.get(contextController);
            if (agentInstances == null) {
                agentInstances = new ArrayList<LeafDesc>();
                this.controllerAgentInstances.put(contextController, agentInstances);
            }
            ContextStatePathValue value = new ContextStatePathValue(contextPartitionOrSubPath, binding.toByteArray(payload), instanceHandle.getInstances().getState());
            agentInstances.add(new LeafDesc(key, value));
            ContextControllerTreeEntry entry = this.subcontexts.get(contextController);
            ContextPartitionIdentifier[] keys = ContextManagerNested.getTreeCompositeKey(this.nestedFactories, payload, entry, this.subcontexts);
            ContextPartitionDescriptor descriptor = new ContextPartitionDescriptor(contextPartitionOrSubPath, new ContextPartitionIdentifierNested(keys), value.getState());
            this.agentInstanceInfo.put(contextPartitionOrSubPath, descriptor);
            this.states.put(key, value);
        } else {
            this.subpaths.add(contextPartitionOrSubPath);
            this.states.put(key, new ContextStatePathValue(contextPartitionOrSubPath, binding.toByteArray(payload), ContextPartitionState.STARTED));
        }
    }

    public TreeMap<ContextStatePathKey, ContextStatePathValue> getStates() {
        return this.states;
    }

    @Override
    public void resetSubPaths() {
        this.subpaths.clear();
    }

    @Override
    public Collection<Integer> getSubpaths() {
        return this.subpaths;
    }

    public Map<ContextController, List<LeafDesc>> getControllerAgentInstances() {
        return this.controllerAgentInstances;
    }

    public Map<Integer, ContextPartitionDescriptor> getAgentInstanceInfo() {
        return this.agentInstanceInfo;
    }

    public static class LeafDesc {
        private final ContextStatePathKey key;
        private final ContextStatePathValue value;

        public LeafDesc(ContextStatePathKey key, ContextStatePathValue value) {
            this.key = key;
            this.value = value;
        }

        public ContextStatePathKey getKey() {
            return this.key;
        }

        public ContextStatePathValue getValue() {
            return this.value;
        }
    }
}

