/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.context.ContextPartitionStateListener;
import com.espertech.esper.core.service.EPServicesContext;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class ContextManagerBase {
    protected final String contextName;
    protected final EPServicesContext servicesContext;
    protected CopyOnWriteArrayList<ContextPartitionStateListener> listenersLazy;

    public ContextManagerBase(String contextName, EPServicesContext servicesContext) {
        this.contextName = contextName;
        this.servicesContext = servicesContext;
    }

    public synchronized void addListener(ContextPartitionStateListener listener) {
        if (this.listenersLazy == null) {
            this.listenersLazy = new CopyOnWriteArrayList();
        }
        this.listenersLazy.add(listener);
    }

    public void removeListener(ContextPartitionStateListener listener) {
        if (this.listenersLazy == null) {
            return;
        }
        this.listenersLazy.remove(listener);
    }

    public Iterator<ContextPartitionStateListener> getListeners() {
        return this.listenersLazy == null ? Collections.emptyIterator() : Collections.unmodifiableCollection(this.listenersLazy).iterator();
    }

    public void removeListeners() {
        if (this.listenersLazy == null) {
            return;
        }
        this.listenersLazy.clear();
    }
}

