/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.core.context.mgr.ContextControllerStatementBase;
import com.espertech.esper.core.service.speccompiled.StatementSpecCompiled;
import com.espertech.esper.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.named.NamedWindowMgmtService;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.epl.spec.ContextDetailPartitioned;
import com.espertech.esper.epl.util.StatementSpecCompiledAnalyzerResult;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.filterspec.FilterAddendumUtil;
import com.espertech.esper.filterspec.FilterOperator;
import com.espertech.esper.filterspec.FilterSpecCompiled;
import com.espertech.esper.filterspec.FilterValueSetParam;
import com.espertech.esper.filterspec.FilterValueSetParamImpl;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;

public class ContextControllerPartitionedUtil {
    protected static Class[] validateContextDesc(String contextName, ContextDetailPartitioned segmentedSpec) throws ExprValidationException {
        if (segmentedSpec.getItems().isEmpty()) {
            throw new ExprValidationException("Empty list of partition items");
        }
        for (ContextDetailPartitionItem item : segmentedSpec.getItems()) {
            EventType type = item.getFilterSpecCompiled().getFilterForEventType();
            for (String property : item.getPropertyNames()) {
                EventPropertyGetter getter = type.getGetter(property);
                if (getter != null) continue;
                throw new ExprValidationException("For context '" + contextName + "' property name '" + property + "' not found on type " + type.getName());
            }
        }
        ContextDetailPartitionItem firstItem = segmentedSpec.getItems().get(0);
        if (segmentedSpec.getItems().size() > 1) {
            for (int i = 0; i < segmentedSpec.getItems().size(); ++i) {
                EventType compareTo = segmentedSpec.getItems().get(i).getFilterSpecCompiled().getFilterForEventType();
                for (int j = 0; j < segmentedSpec.getItems().size(); ++j) {
                    if (i == j) continue;
                    EventType compareFrom = segmentedSpec.getItems().get(j).getFilterSpecCompiled().getFilterForEventType();
                    if (compareFrom == compareTo) {
                        throw new ExprValidationException("For context '" + contextName + "' the event type '" + compareFrom.getName() + "' is listed twice");
                    }
                    if (!EventTypeUtility.isTypeOrSubTypeOf(compareFrom, compareTo) && !EventTypeUtility.isTypeOrSubTypeOf(compareTo, compareFrom)) continue;
                    throw new ExprValidationException("For context '" + contextName + "' the event type '" + compareFrom.getName() + "' is listed twice: Event type '" + compareFrom.getName() + "' is a subtype or supertype of event type '" + compareTo.getName() + "'");
                }
            }
            String[] names = new String[firstItem.getPropertyNames().size()];
            Class[] types = new Class[firstItem.getPropertyNames().size()];
            Class[] typesBoxed = new Class[firstItem.getPropertyNames().size()];
            for (int i = 0; i < firstItem.getPropertyNames().size(); ++i) {
                String property;
                names[i] = property = firstItem.getPropertyNames().get(i);
                types[i] = firstItem.getFilterSpecCompiled().getFilterForEventType().getPropertyType(property);
                typesBoxed[i] = JavaClassHelper.getBoxedType(types[i]);
            }
            for (int item = 1; item < segmentedSpec.getItems().size(); ++item) {
                ContextDetailPartitionItem nextItem = segmentedSpec.getItems().get(item);
                if (nextItem.getPropertyNames().size() != types.length) {
                    throw new ExprValidationException("For context '" + contextName + "' expected the same number of property names for each event type, found " + types.length + " properties for event type '" + firstItem.getFilterSpecCompiled().getFilterForEventType().getName() + "' and " + nextItem.getPropertyNames().size() + " properties for event type '" + nextItem.getFilterSpecCompiled().getFilterForEventType().getName() + "'");
                }
                for (int i = 0; i < nextItem.getPropertyNames().size(); ++i) {
                    String property = nextItem.getPropertyNames().get(i);
                    Class type = JavaClassHelper.getBoxedType(nextItem.getFilterSpecCompiled().getFilterForEventType().getPropertyType(property));
                    Class typeBoxed = JavaClassHelper.getBoxedType(type);
                    boolean left = JavaClassHelper.isSubclassOrImplementsInterface(typeBoxed, typesBoxed[i]);
                    boolean right = JavaClassHelper.isSubclassOrImplementsInterface(typesBoxed[i], typeBoxed);
                    if (typeBoxed == typesBoxed[i] || left || right) continue;
                    throw new ExprValidationException("For context '" + contextName + "' for context '" + contextName + "' found mismatch of property types, property '" + names[i] + "' of type '" + JavaClassHelper.getClassNameFullyQualPretty(types[i]) + "' compared to property '" + property + "' of type '" + JavaClassHelper.getClassNameFullyQualPretty(typeBoxed) + "'");
                }
            }
        }
        Class[] propertyTypes = new Class[firstItem.getPropertyNames().size()];
        for (int i = 0; i < firstItem.getPropertyNames().size(); ++i) {
            String property = firstItem.getPropertyNames().get(i);
            propertyTypes[i] = firstItem.getFilterSpecCompiled().getFilterForEventType().getPropertyType(property);
        }
        return propertyTypes;
    }

    protected static void validateStatementForContext(String contextName, ContextControllerStatementBase statement, StatementSpecCompiledAnalyzerResult streamAnalysis, Collection<EventType> itemEventTypes, NamedWindowMgmtService namedWindowMgmtService) throws ExprValidationException {
        boolean isCreateWindow;
        List<FilterSpecCompiled> filters = streamAnalysis.getFilters();
        boolean bl = isCreateWindow = statement.getStatementSpec().getCreateWindowDesc() != null;
        if (!isCreateWindow) {
            for (FilterSpecCompiled filter : filters) {
                for (EventType itemEventType : itemEventTypes) {
                    EventType stmtFilterType = filter.getFilterForEventType();
                    if (stmtFilterType == itemEventType) {
                        return;
                    }
                    if (EventTypeUtility.isTypeOrSubTypeOf(stmtFilterType, itemEventType)) {
                        return;
                    }
                    NamedWindowProcessor processor = namedWindowMgmtService.getProcessor(stmtFilterType.getName());
                    if (processor == null || processor.getContextName() == null || !processor.getContextName().equals(contextName)) continue;
                    return;
                }
            }
            if (!filters.isEmpty()) {
                throw new ExprValidationException(ContextControllerPartitionedUtil.getTypeValidationMessage(contextName, filters.get(0).getFilterForEventType().getName()));
            }
            return;
        }
        if (statement.getStatementSpec().getCreateWindowDesc().getColumns() != null && statement.getStatementSpec().getCreateWindowDesc().getColumns().size() > 0) {
            throw new ExprValidationException("Segmented context '" + contextName + "' requires that named windows are associated to an existing event type and that the event type is listed among the partitions defined by the create-context statement");
        }
        String declaredAsName = statement.getStatementSpec().getCreateWindowDesc().getAsEventTypeName();
        if (declaredAsName != null) {
            for (EventType itemEventType : itemEventTypes) {
                if (!itemEventType.getName().equals(declaredAsName)) continue;
                return;
            }
            throw new ExprValidationException(ContextControllerPartitionedUtil.getTypeValidationMessage(contextName, declaredAsName));
        }
    }

    public static void populateAddendumFilters(Object keyValue, List<FilterSpecCompiled> filtersSpecs, ContextDetailPartitioned segmentedSpec, StatementSpecCompiled optionalStatementSpecCompiled, IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[][]> addendums) {
        for (FilterSpecCompiled filtersSpec : filtersSpecs) {
            FilterValueSetParam[][] addendum = ContextControllerPartitionedUtil.getAddendumFilters(keyValue, filtersSpec, segmentedSpec, true, optionalStatementSpecCompiled);
            if (addendum == null) continue;
            FilterValueSetParam[][] existing = addendums.get(filtersSpec);
            if (existing != null) {
                addendum = FilterAddendumUtil.multiplyAddendum(existing, addendum);
            }
            addendums.put(filtersSpec, addendum);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static FilterValueSetParam[][] getAddendumFilters(Object keyValue, FilterSpecCompiled filtersSpec, ContextDetailPartitioned segmentedSpec, boolean includePartition, StatementSpecCompiled optionalStatementSpecCompiled) {
        void var8_16;
        boolean isCreateWindow = optionalStatementSpecCompiled != null && optionalStatementSpecCompiled.getCreateWindowDesc() != null;
        ContextDetailPartitionItem foundPartition = null;
        if (!isCreateWindow) {
            for (ContextDetailPartitionItem contextDetailPartitionItem : segmentedSpec.getItems()) {
                boolean typeOrSubtype = EventTypeUtility.isTypeOrSubTypeOf(filtersSpec.getFilterForEventType(), contextDetailPartitionItem.getFilterSpecCompiled().getFilterForEventType());
                if (!typeOrSubtype) continue;
                foundPartition = contextDetailPartitionItem;
                break;
            }
        } else {
            String declaredAsName = optionalStatementSpecCompiled.getCreateWindowDesc().getAsEventTypeName();
            if (declaredAsName == null) {
                return null;
            }
            for (ContextDetailPartitionItem partitionItem : segmentedSpec.getItems()) {
                if (!partitionItem.getFilterSpecCompiled().getFilterForEventType().getName().equals(declaredAsName)) continue;
                foundPartition = partitionItem;
                break;
            }
        }
        if (foundPartition == null) {
            return null;
        }
        ArrayList<FilterValueSetParam> addendumFilters = new ArrayList<FilterValueSetParam>(foundPartition.getPropertyNames().size());
        if (foundPartition.getPropertyNames().size() == 1) {
            String string = foundPartition.getPropertyNames().get(0);
            EventPropertyGetter getter = foundPartition.getFilterSpecCompiled().getFilterForEventType().getGetter(string);
            Class resultType = foundPartition.getFilterSpecCompiled().getFilterForEventType().getPropertyType(string);
            ExprFilterSpecLookupable lookupable = new ExprFilterSpecLookupable(string, getter, resultType, false);
            FilterValueSetParam filter = ContextControllerPartitionedUtil.getFilterMayEqualOrNull(lookupable, keyValue);
            addendumFilters.add(filter);
        } else {
            Object[] objectArray = keyValue instanceof MultiKeyUntyped ? ((MultiKeyUntyped)keyValue).getKeys() : (Object[])keyValue;
            for (int i = 0; i < foundPartition.getPropertyNames().size(); ++i) {
                String partitionPropertyName = foundPartition.getPropertyNames().get(i);
                EventPropertyGetter getter = foundPartition.getFilterSpecCompiled().getFilterForEventType().getGetter(partitionPropertyName);
                Class resultType = foundPartition.getFilterSpecCompiled().getFilterForEventType().getPropertyType(partitionPropertyName);
                ExprFilterSpecLookupable lookupable = new ExprFilterSpecLookupable(partitionPropertyName, getter, resultType, false);
                FilterValueSetParam filter = ContextControllerPartitionedUtil.getFilterMayEqualOrNull(lookupable, objectArray[i]);
                addendumFilters.add(filter);
            }
        }
        FilterValueSetParam[][] filterValueSetParamArrayArray = new FilterValueSetParam[][]{addendumFilters.toArray(new FilterValueSetParam[addendumFilters.size()])};
        FilterValueSetParam[][] partitionFilters = foundPartition.getParametersCompiled();
        if (partitionFilters != null && includePartition) {
            FilterValueSetParam[][] filterValueSetParamArray = FilterAddendumUtil.addAddendum(partitionFilters, filterValueSetParamArrayArray[0]);
        }
        return var8_16;
    }

    private static FilterValueSetParam getFilterMayEqualOrNull(ExprFilterSpecLookupable lookupable, Object keyValue) {
        return new FilterValueSetParamImpl(lookupable, FilterOperator.IS, keyValue);
    }

    private static String getTypeValidationMessage(String contextName, String typeNameEx) {
        return "Segmented context '" + contextName + "' requires that any of the event types that are listed in the segmented context also appear in any of the filter expressions of the statement, type '" + typeNameEx + "' is not one of the types listed";
    }
}

