/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventType;
import com.espertech.esper.client.context.ContextPartitionIdentifier;
import com.espertech.esper.client.context.ContextPartitionIdentifierPartitioned;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.core.context.mgr.ContextControllerFactory;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryBase;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryContext;
import com.espertech.esper.core.context.mgr.ContextControllerPartitionedState;
import com.espertech.esper.core.context.mgr.ContextControllerPartitionedUtil;
import com.espertech.esper.core.context.mgr.ContextControllerStatementBase;
import com.espertech.esper.core.context.mgr.ContextControllerStatementCtxCache;
import com.espertech.esper.core.context.mgr.ContextControllerStatementCtxCacheFilters;
import com.espertech.esper.core.context.mgr.ContextControllerStatementDesc;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.mgr.ContextPropertyEventType;
import com.espertech.esper.core.context.stmt.AIRegistryAggregationMultiPerm;
import com.espertech.esper.core.context.stmt.AIRegistryExprMultiPerm;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistry;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistryFactory;
import com.espertech.esper.core.context.util.ContextDetailUtil;
import com.espertech.esper.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.ContextDetail;
import com.espertech.esper.epl.spec.ContextDetailConditionFilter;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.epl.spec.ContextDetailPartitioned;
import com.espertech.esper.epl.util.StatementSpecCompiledAnalyzer;
import com.espertech.esper.epl.util.StatementSpecCompiledAnalyzerResult;
import com.espertech.esper.filterspec.FilterAddendumUtil;
import com.espertech.esper.filterspec.FilterSpecCompiled;
import com.espertech.esper.filterspec.FilterValueSetParam;
import com.espertech.esper.filterspec.MatchedEventMapMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public abstract class ContextControllerPartitionedFactoryBase
extends ContextControllerFactoryBase
implements ContextControllerFactory {
    protected final ContextDetailPartitioned segmentedSpec;
    private final List<FilterSpecCompiled> filtersSpecsNestedContexts;
    private final List<FilterSpecCompiled> filtersTerminationMayNull;
    private Map<String, Object> contextBuiltinProps;
    private MatchedEventMapMeta termConditionMatchEventMap;

    public ContextControllerPartitionedFactoryBase(ContextControllerFactoryContext factoryContext, ContextDetailPartitioned segmentedSpec, List<FilterSpecCompiled> filtersSpecsNestedContexts) {
        super(factoryContext);
        this.segmentedSpec = segmentedSpec;
        this.filtersSpecsNestedContexts = filtersSpecsNestedContexts;
        this.filtersTerminationMayNull = segmentedSpec.getOptionalTermination() == null ? null : ContextDetailUtil.getFilterSpecIfAny(segmentedSpec.getOptionalTermination());
    }

    public boolean hasFiltersSpecsNestedContexts() {
        return this.filtersSpecsNestedContexts != null && !this.filtersSpecsNestedContexts.isEmpty();
    }

    @Override
    public void validateFactory() throws ExprValidationException {
        Class[] propertyTypes = ContextControllerPartitionedUtil.validateContextDesc(this.factoryContext.getContextName(), this.segmentedSpec);
        this.contextBuiltinProps = ContextPropertyEventType.getPartitionType(this.segmentedSpec, propertyTypes);
        LinkedHashSet<String> allTags = new LinkedHashSet<String>();
        for (ContextDetailPartitionItem item : this.segmentedSpec.getItems()) {
            if (item.getAliasName() == null) continue;
            allTags.add(item.getAliasName());
        }
        if (this.segmentedSpec.getOptionalInit() != null) {
            for (ContextDetailConditionFilter filter : this.segmentedSpec.getOptionalInit()) {
                ContextPropertyEventType.addEndpointTypes(this.factoryContext.getContextName(), filter, this.contextBuiltinProps, allTags);
            }
        }
        this.termConditionMatchEventMap = new MatchedEventMapMeta(allTags, false);
    }

    @Override
    public ContextControllerStatementCtxCache validateStatement(ContextControllerStatementBase statement) throws ExprValidationException {
        StatementSpecCompiledAnalyzerResult streamAnalysis = StatementSpecCompiledAnalyzer.analyzeFilters(statement.getStatementSpec());
        ContextControllerPartitionedUtil.validateStatementForContext(this.factoryContext.getContextName(), statement, streamAnalysis, this.getItemEventTypes(this.segmentedSpec), this.factoryContext.getServicesContext().getNamedWindowMgmtService());
        return new ContextControllerStatementCtxCacheFilters(streamAnalysis.getFilters());
    }

    @Override
    public void populateFilterAddendums(IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[][]> filterAddendum, ContextControllerStatementDesc statement, Object key, int contextId) {
        ContextControllerStatementCtxCacheFilters statementInfo = (ContextControllerStatementCtxCacheFilters)statement.getCaches()[this.factoryContext.getNestingLevel() - 1];
        ContextControllerPartitionedUtil.populateAddendumFilters(key, statementInfo.getFilterSpecs(), this.segmentedSpec, statement.getStatement().getStatementSpec(), filterAddendum);
    }

    public void populateContextInternalFilterAddendums(ContextInternalFilterAddendum filterAddendum, Object key) {
        if (this.filtersSpecsNestedContexts == null) {
            return;
        }
        ContextControllerPartitionedUtil.populateAddendumFilters(key, this.filtersSpecsNestedContexts, this.segmentedSpec, null, filterAddendum.getFilterAddendum());
    }

    public void populateContextInternalFilterAddendumsTermination(ContextInternalFilterAddendum filterAddendum, Object key) {
        if (this.filtersTerminationMayNull == null) {
            return;
        }
        for (FilterSpecCompiled filtersSpec : this.filtersTerminationMayNull) {
            FilterValueSetParam[][] addendum = ContextControllerPartitionedUtil.getAddendumFilters(key, filtersSpec, this.segmentedSpec, false, null);
            if (addendum == null) continue;
            FilterValueSetParam[][] existing = filterAddendum.getFilterAddendum().get(filtersSpec);
            if (existing != null) {
                addendum = FilterAddendumUtil.multiplyAddendum(existing, addendum);
            }
            filterAddendum.getFilterAddendum().put(filtersSpec, addendum);
        }
    }

    @Override
    public ExprFilterSpecLookupable getFilterLookupable(EventType eventType) {
        return null;
    }

    @Override
    public boolean isSingleInstanceContext() {
        return false;
    }

    @Override
    public StatementAIResourceRegistryFactory getStatementAIResourceRegistryFactory() {
        return new StatementAIResourceRegistryFactory(){

            @Override
            public StatementAIResourceRegistry make() {
                return new StatementAIResourceRegistry(new AIRegistryAggregationMultiPerm(), new AIRegistryExprMultiPerm());
            }
        };
    }

    @Override
    public List<ContextDetailPartitionItem> getContextDetailPartitionItems() {
        return this.segmentedSpec.getItems();
    }

    @Override
    public ContextDetail getContextDetail() {
        return this.segmentedSpec;
    }

    public ContextDetailPartitioned getSegmentedSpec() {
        return this.segmentedSpec;
    }

    public MatchedEventMapMeta getTermConditionMatchEventMap() {
        return this.termConditionMatchEventMap;
    }

    @Override
    public Map<String, Object> getContextBuiltinProps() {
        return this.contextBuiltinProps;
    }

    @Override
    public ContextPartitionIdentifier keyPayloadToIdentifier(Object payload) {
        if (payload instanceof Object[]) {
            return new ContextPartitionIdentifierPartitioned((Object[])payload);
        }
        if (payload instanceof MultiKeyUntyped) {
            return new ContextPartitionIdentifierPartitioned(((MultiKeyUntyped)payload).getKeys());
        }
        if (payload instanceof ContextControllerPartitionedState) {
            return new ContextPartitionIdentifierPartitioned(((ContextControllerPartitionedState)payload).getPartitionKey());
        }
        return new ContextPartitionIdentifierPartitioned(new Object[]{payload});
    }

    private Collection<EventType> getItemEventTypes(ContextDetailPartitioned segmentedSpec) {
        ArrayList<EventType> itemEventTypes = new ArrayList<EventType>();
        for (ContextDetailPartitionItem item : segmentedSpec.getItems()) {
            itemEventTypes.add(item.getFilterSpecCompiled().getFilterForEventType());
        }
        return itemEventTypes;
    }
}

