/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.core.engineimport.EngineImportSingleRowDesc;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilMethodDesc;
import com.espertech.esper.epl.expression.core.ExprNodeUtilResolveExceptionHandlerDefault;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextControllerHashedGetterSingleRow
implements EventPropertyGetter {
    private static final Logger log = LoggerFactory.getLogger(ContextControllerHashedGetterSingleRow.class);
    private final String statementName;
    private final FastMethod fastMethod;
    private final ExprEvaluator[] evaluators;
    private final int granularity;

    public ContextControllerHashedGetterSingleRow(String statementName, String functionName, Pair<Class, EngineImportSingleRowDesc> func, List<ExprNode> parameters, int granularity, EngineImportService engineImportService, EventType eventType, EventAdapterService eventAdapterService, int statementId, TableService tableService, String engineURI) throws ExprValidationException {
        ExprNodeUtilMethodDesc staticMethodDesc = ExprNodeUtilityRich.resolveMethodAllowWildcardAndStream(func.getFirst().getName(), null, func.getSecond().getMethodName(), parameters, engineImportService, eventAdapterService, statementId, true, eventType, new ExprNodeUtilResolveExceptionHandlerDefault(func.getSecond().getMethodName(), true), func.getSecond().getMethodName(), tableService, engineURI);
        this.statementName = statementName;
        this.evaluators = ExprNodeUtilityCore.getEvaluatorsNoCompile(staticMethodDesc.getChildForges());
        this.granularity = granularity;
        this.fastMethod = staticMethodDesc.getFastMethod();
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        EventBean[] events = new EventBean[]{eventBean};
        Object[] parameters = new Object[this.evaluators.length];
        for (int i = 0; i < this.evaluators.length; ++i) {
            parameters[i] = this.evaluators[i].evaluate(events, true, null);
        }
        try {
            Object result = this.fastMethod.invoke(null, parameters);
            if (result == null) {
                return 0;
            }
            int value = ((Number)result).intValue();
            if (value >= 0) {
                return value % this.granularity;
            }
            return -value % this.granularity;
        }
        catch (InvocationTargetException e) {
            String message = JavaClassHelper.getMessageInvocationTarget(this.statementName, this.fastMethod.getJavaMethod(), this.fastMethod.getDeclaringClass().getName(), parameters, e.getTargetException());
            log.error(message, e.getTargetException());
            return 0;
        }
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return false;
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        return null;
    }
}

