/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.factory;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.activator.ViewableActivationResult;
import com.espertech.esper.core.context.activator.ViewableActivator;
import com.espertech.esper.core.context.activator.ViewableActivatorStreamReuseView;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryBase;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryResult;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactorySelectResult;
import com.espertech.esper.core.context.factory.StatementAgentInstancePostLoad;
import com.espertech.esper.core.context.factory.StatementAgentInstancePostLoadIndexVisiting;
import com.espertech.esper.core.context.factory.StatementAgentInstancePostLoadSelect;
import com.espertech.esper.core.context.factory.StatementAgentInstancePreload;
import com.espertech.esper.core.context.subselect.SubSelectStrategyCollection;
import com.espertech.esper.core.context.subselect.SubSelectStrategyHolder;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementDispatch;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StreamJoinAnalysisResult;
import com.espertech.esper.core.service.speccompiled.StatementSpecCompiled;
import com.espertech.esper.core.start.EPStatementStartMethodHelperAssignExpr;
import com.espertech.esper.core.start.EPStatementStartMethodHelperPrevious;
import com.espertech.esper.core.start.EPStatementStartMethodHelperPrior;
import com.espertech.esper.core.start.EPStatementStartMethodHelperSubselect;
import com.espertech.esper.core.start.EPStatementStartMethodHelperTableAccess;
import com.espertech.esper.core.start.EPStatementStartMethodHelperUtil;
import com.espertech.esper.epl.agg.service.common.AggregationService;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessor;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.core.streamtype.StreamTypeService;
import com.espertech.esper.epl.core.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.epl.core.viewres.ViewResourceDelegateVerified;
import com.espertech.esper.epl.core.viewres.ViewResourceDelegateVerifiedStream;
import com.espertech.esper.epl.expression.codegen.ExprNodeCompiler;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.prev.ExprPreviousEvalStrategy;
import com.espertech.esper.epl.expression.prev.ExprPreviousMatchRecognizeNode;
import com.espertech.esper.epl.expression.prev.ExprPreviousNode;
import com.espertech.esper.epl.expression.prior.ExprPriorEvalStrategy;
import com.espertech.esper.epl.expression.prior.ExprPriorNode;
import com.espertech.esper.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.epl.expression.table.ExprTableAccessEvalStrategy;
import com.espertech.esper.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.epl.join.base.JoinExecStrategyDispatchable;
import com.espertech.esper.epl.join.base.JoinExecutionStrategyImpl;
import com.espertech.esper.epl.join.base.JoinPreloadMethod;
import com.espertech.esper.epl.join.base.JoinPreloadMethodImpl;
import com.espertech.esper.epl.join.base.JoinPreloadMethodNull;
import com.espertech.esper.epl.join.base.JoinSetComposerDesc;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototype;
import com.espertech.esper.epl.join.base.JoinSetFilter;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.named.NamedWindowTailViewInstance;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.util.EPLValidationUtil;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.epl.view.FilterExprView;
import com.espertech.esper.epl.view.OutputProcessViewBase;
import com.espertech.esper.epl.view.OutputProcessViewFactory;
import com.espertech.esper.pattern.EvalRootMatchRemover;
import com.espertech.esper.pattern.EvalRootState;
import com.espertech.esper.rowregex.EventRowRegexHelper;
import com.espertech.esper.rowregex.EventRowRegexNFAViewService;
import com.espertech.esper.rowregex.RegexExprPreviousEvalStrategy;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryChain;
import com.espertech.esper.view.ViewServiceCreateResult;
import com.espertech.esper.view.ViewServiceHelper;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.Viewable;
import com.espertech.esper.view.internal.BufferView;
import com.espertech.esper.view.internal.PatternRemoveDispatchView;
import com.espertech.esper.view.internal.PriorEventViewFactory;
import com.espertech.esper.view.internal.SingleStreamDispatchView;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementAgentInstanceFactorySelect
extends StatementAgentInstanceFactoryBase {
    private static final Logger log = LoggerFactory.getLogger(StatementAgentInstanceFactorySelect.class);
    protected final int numStreams;
    protected final ViewableActivator[] eventStreamParentViewableActivators;
    protected final StatementContext statementContext;
    protected final StatementSpecCompiled statementSpec;
    protected final EPServicesContext services;
    protected final StreamTypeService typeService;
    protected final ViewFactoryChain[] unmaterializedViewChain;
    protected final ResultSetProcessorFactoryDesc resultSetProcessorFactoryDesc;
    protected final StreamJoinAnalysisResult joinAnalysisResult;
    protected final JoinSetComposerPrototype joinSetComposerPrototype;
    protected final SubSelectStrategyCollection subSelectStrategyCollection;
    protected final ViewResourceDelegateVerified viewResourceDelegate;
    protected final OutputProcessViewFactory outputProcessViewFactory;
    protected final ExprEvaluator filterRootNodeEvaluator;

    public StatementAgentInstanceFactorySelect(int numStreams, ViewableActivator[] eventStreamParentViewableActivators, StatementContext statementContext, StatementSpecCompiled statementSpec, EPServicesContext services, StreamTypeService typeService, ViewFactoryChain[] unmaterializedViewChain, ResultSetProcessorFactoryDesc resultSetProcessorFactoryDesc, StreamJoinAnalysisResult joinAnalysisResult, boolean recoveringResilient, JoinSetComposerPrototype joinSetComposerPrototype, SubSelectStrategyCollection subSelectStrategyCollection, ViewResourceDelegateVerified viewResourceDelegate, OutputProcessViewFactory outputProcessViewFactory) {
        super(statementSpec.getAnnotations());
        this.numStreams = numStreams;
        this.eventStreamParentViewableActivators = eventStreamParentViewableActivators;
        this.statementContext = statementContext;
        this.statementSpec = statementSpec;
        this.services = services;
        this.typeService = typeService;
        this.unmaterializedViewChain = unmaterializedViewChain;
        this.resultSetProcessorFactoryDesc = resultSetProcessorFactoryDesc;
        this.joinAnalysisResult = joinAnalysisResult;
        this.joinSetComposerPrototype = joinSetComposerPrototype;
        this.subSelectStrategyCollection = subSelectStrategyCollection;
        this.viewResourceDelegate = viewResourceDelegate;
        this.outputProcessViewFactory = outputProcessViewFactory;
        this.filterRootNodeEvaluator = statementSpec.getFilterRootNode() != null ? ExprNodeCompiler.allocateEvaluator(statementSpec.getFilterRootNode().getForge(), statementContext.getEngineImportService(), StatementAgentInstanceFactorySelect.class, false, statementContext.getStatementName()) : null;
    }

    public ViewResourceDelegateVerified getViewResourceDelegate() {
        return this.viewResourceDelegate;
    }

    @Override
    public StatementAgentInstanceFactorySelectResult newContextInternal(final AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        Viewable finalView;
        AggregationService aggregationService;
        Map<ExprTableAccessNode, ExprTableAccessEvalStrategy> tableAccessStrategies;
        Map<ExprSubselectNode, SubSelectStrategyHolder> subselectStrategies;
        Viewable[] topViews;
        Map<ExprPreviousNode, ExprPreviousEvalStrategy> previousNodeStrategies;
        Map<ExprPriorNode, ExprPriorEvalStrategy> priorNodeStrategies;
        EvalRootState[] patternRoots;
        Viewable[] eventStreamParentViewable;
        ArrayList<StopCallback> stopCallbacks = new ArrayList<StopCallback>(2);
        ViewableActivationResult[] viewableActivationResult = new ViewableActivationResult[this.eventStreamParentViewableActivators.length];
        RegexExprPreviousEvalStrategy regexExprPreviousEvalStrategy = null;
        ArrayList<StatementAgentInstancePreload> preloadList = new ArrayList<StatementAgentInstancePreload>();
        StatementAgentInstancePostLoad postLoadJoin = null;
        boolean suppressSameEventMatches = false;
        boolean discardPartialsOnMatch = false;
        EvalRootMatchRemover evalRootMatchRemover = null;
        try {
            JoinPreloadMethod joinPreloadMethod;
            int i;
            eventStreamParentViewable = new Viewable[this.numStreams];
            patternRoots = new EvalRootState[this.numStreams];
            for (int stream = 0; stream < this.eventStreamParentViewableActivators.length; ++stream) {
                ViewableActivationResult activationResult;
                viewableActivationResult[stream] = activationResult = this.eventStreamParentViewableActivators[stream].activate(agentInstanceContext, false, isRecoveringResilient);
                stopCallbacks.add(activationResult.getStopCallback());
                suppressSameEventMatches = activationResult.isSuppressSameEventMatches();
                discardPartialsOnMatch = activationResult.isDiscardPartialsOnMatch();
                if (activationResult.getViewable() instanceof StopCallback) {
                    stopCallbacks.add((StopCallback)((Object)activationResult.getViewable()));
                }
                eventStreamParentViewable[stream] = activationResult.getViewable();
                patternRoots[stream] = activationResult.getOptionalPatternRoot();
                if (stream == 0) {
                    evalRootMatchRemover = activationResult.getOptEvalRootMatchRemover();
                }
                if (activationResult.getOptionalLock() == null) continue;
                agentInstanceContext.getEpStatementAgentInstanceHandle().setStatementAgentInstanceLock(activationResult.getOptionalLock());
                this.statementContext.setDefaultAgentInstanceLock(activationResult.getOptionalLock());
            }
            List[] viewFactoryChains = new List[this.numStreams];
            for (int i2 = 0; i2 < this.numStreams; ++i2) {
                boolean hasPrior;
                List<ViewFactory> viewFactoryChain = this.unmaterializedViewChain[i2].getViewFactoryChain();
                boolean bl = hasPrior = this.viewResourceDelegate.getPerStream()[i2].getPriorRequests() != null && !this.viewResourceDelegate.getPerStream()[i2].getPriorRequests().isEmpty();
                if (hasPrior) {
                    PriorEventViewFactory priorEventViewFactory = EPStatementStartMethodHelperPrior.getPriorEventViewFactory(agentInstanceContext.getStatementContext(), i2, viewFactoryChain.isEmpty(), false, -1);
                    viewFactoryChain = new ArrayList<ViewFactory>(viewFactoryChain);
                    viewFactoryChain.add(priorEventViewFactory);
                }
                viewFactoryChains[i2] = viewFactoryChain;
            }
            AgentInstanceViewFactoryChainContext[] viewFactoryChainContexts = new AgentInstanceViewFactoryChainContext[this.numStreams];
            for (i = 0; i < this.numStreams; ++i) {
                viewFactoryChainContexts[i] = AgentInstanceViewFactoryChainContext.create(viewFactoryChains[i], agentInstanceContext, this.viewResourceDelegate.getPerStream()[i]);
            }
            priorNodeStrategies = EPStatementStartMethodHelperPrior.compilePriorNodeStrategies(this.viewResourceDelegate, viewFactoryChainContexts);
            previousNodeStrategies = EPStatementStartMethodHelperPrevious.compilePreviousNodeStrategies(this.viewResourceDelegate, viewFactoryChainContexts);
            Viewable[] streamViews = new Viewable[this.numStreams];
            topViews = new Viewable[this.numStreams];
            for (i = 0; i < this.numStreams; ++i) {
                boolean hasPreviousNode = this.viewResourceDelegate.getPerStream()[i].getPreviousRequests() != null && !this.viewResourceDelegate.getPerStream()[i].getPreviousRequests().isEmpty();
                ViewServiceCreateResult createResult = this.services.getViewService().createViews(eventStreamParentViewable[i], viewFactoryChains[i], viewFactoryChainContexts[i], hasPreviousNode);
                topViews[i] = createResult.getTopViewable();
                streamViews[i] = createResult.getFinalViewable();
                boolean isReuseableView = this.eventStreamParentViewableActivators[i] instanceof ViewableActivatorStreamReuseView;
                if (isReuseableView) {
                    final List<View> viewsCreated = createResult.getNewViews();
                    StopCallback stopCallback = new StopCallback(){

                        @Override
                        public void stop() {
                            ViewServiceHelper.removeFirstUnsharedView(viewsCreated);
                        }
                    };
                    stopCallbacks.add(stopCallback);
                }
                StatementAgentInstanceFactorySelect.addViewStopCallback(stopCallbacks, createResult.getNewViews());
            }
            EventRowRegexNFAViewService matchRecognize = EventRowRegexHelper.recursiveFindRegexService(topViews[0]);
            if (matchRecognize != null) {
                regexExprPreviousEvalStrategy = matchRecognize.getPreviousEvaluationStrategy();
                stopCallbacks.add(matchRecognize);
            }
            subselectStrategies = EPStatementStartMethodHelperSubselect.startSubselects(this.services, this.subSelectStrategyCollection, agentInstanceContext, stopCallbacks, isRecoveringResilient);
            tableAccessStrategies = EPStatementStartMethodHelperTableAccess.attachTableAccess(this.services, agentInstanceContext, this.statementSpec.getTableNodes(), false);
            Pair<ResultSetProcessor, AggregationService> processorPair = EPStatementStartMethodHelperUtil.startResultSetAndAggregation(this.resultSetProcessorFactoryDesc, agentInstanceContext, false, null);
            final ResultSetProcessor resultSetProcessor = processorPair.getFirst();
            aggregationService = processorPair.getSecond();
            stopCallbacks.add(aggregationService);
            stopCallbacks.add(resultSetProcessor);
            JoinSetComposerDesc joinSetComposer = null;
            if (streamViews.length == 1) {
                finalView = this.handleSimpleSelect(streamViews[0], resultSetProcessor, agentInstanceContext, evalRootMatchRemover, suppressSameEventMatches, discardPartialsOnMatch);
                joinPreloadMethod = null;
            } else {
                JoinPlanResult joinPlanResult = this.handleJoin(this.typeService.getStreamNames(), streamViews, resultSetProcessor, agentInstanceContext, stopCallbacks, this.joinAnalysisResult, isRecoveringResilient);
                finalView = joinPlanResult.getViewable();
                joinPreloadMethod = joinPlanResult.getPreloadMethod();
                joinSetComposer = joinPlanResult.getJoinSetComposerDesc();
            }
            if (finalView instanceof StopCallback) {
                stopCallbacks.add((StopCallback)((Object)finalView));
            }
            if (this.services.getEventTableIndexService().allowInitIndex(isRecoveringResilient)) {
                boolean hasNamedWindow = false;
                QueryGraph[] namedWindowPostloadFilters = new QueryGraph[this.statementSpec.getStreamSpecs().length];
                NamedWindowTailViewInstance[] namedWindowTailViews = new NamedWindowTailViewInstance[this.statementSpec.getStreamSpecs().length];
                List[] namedWindowFilters = new List[this.statementSpec.getStreamSpecs().length];
                for (int i3 = 0; i3 < this.statementSpec.getStreamSpecs().length; ++i3) {
                    final int streamNum = i3;
                    StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs()[i3];
                    if (!(streamSpec instanceof NamedWindowConsumerStreamSpec)) continue;
                    hasNamedWindow = true;
                    final NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
                    NamedWindowProcessor processor = this.services.getNamedWindowMgmtService().getProcessor(namedSpec.getWindowName());
                    NamedWindowProcessorInstance processorInstance = processor.getProcessorInstance(agentInstanceContext);
                    if (processorInstance != null) {
                        boolean preload;
                        NamedWindowTailViewInstance consumerView;
                        namedWindowTailViews[i3] = consumerView = processorInstance.getTailViewInstance();
                        final NamedWindowConsumerView view = (NamedWindowConsumerView)viewableActivationResult[i3].getViewable();
                        if (!namedSpec.getFilterExpressions().isEmpty()) {
                            namedWindowFilters[streamNum] = namedSpec.getFilterExpressions();
                            String streamName = streamSpec.getOptionalStreamName() != null ? streamSpec.getOptionalStreamName() : consumerView.getEventType().getName();
                            StreamTypeServiceImpl types = new StreamTypeServiceImpl(consumerView.getEventType(), streamName, false, this.services.getEngineURI());
                            namedWindowPostloadFilters[i3] = EPLValidationUtil.validateFilterGetQueryGraphSafe(ExprNodeUtilityRich.connectExpressionsByLogicalAndWhenNeeded(namedSpec.getFilterExpressions()), this.statementContext, types);
                        }
                        Iterator<EventBean> consumerViewIterator = consumerView.iterator();
                        boolean bl = preload = !consumerView.getTailView().isParentBatchWindow() && consumerViewIterator.hasNext();
                        if (preload && isRecoveringResilient && this.numStreams < 2) {
                            preload = false;
                        }
                        if (preload) {
                            final boolean yesRecoveringResilient = isRecoveringResilient;
                            final QueryGraph preloadFilterSpec = namedWindowPostloadFilters[i3];
                            preloadList.add(new StatementAgentInstancePreload(){

                                @Override
                                public void executePreload(ExprEvaluatorContext exprEvaluatorContext) {
                                    Collection<EventBean> snapshot = consumerView.snapshot(preloadFilterSpec, StatementAgentInstanceFactorySelect.this.statementContext.getAnnotations());
                                    ArrayList<EventBean> eventsInWindow = new ArrayList<EventBean>(snapshot.size());
                                    ExprNodeUtilityCore.applyFilterExpressionsIterable(snapshot, namedSpec.getFilterExpressions(), agentInstanceContext, eventsInWindow);
                                    EventBean[] newEvents = eventsInWindow.toArray(new EventBean[eventsInWindow.size()]);
                                    view.update(newEvents, null);
                                    if (!yesRecoveringResilient && joinPreloadMethod != null && !joinPreloadMethod.isPreloading() && agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable() != null) {
                                        agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable().execute();
                                    }
                                }
                            });
                        }
                    } else {
                        log.info("Named window access is out-of-context, the named window '" + namedSpec.getWindowName() + "' has been declared for a different context then the current statement, the aggregation and join state will not be initialized for statement expression [" + this.statementContext.getExpression() + "]");
                    }
                    preloadList.add(new StatementAgentInstancePreload(){

                        @Override
                        public void executePreload(ExprEvaluatorContext exprEvaluatorContext) {
                            if (joinPreloadMethod != null) {
                                joinPreloadMethod.preloadFromBuffer(streamNum, exprEvaluatorContext);
                            } else if (agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable() != null) {
                                agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable().execute();
                            }
                        }
                    });
                }
                if (hasNamedWindow && joinPreloadMethod != null && !isRecoveringResilient && this.resultSetProcessorFactoryDesc.getResultSetProcessorType().isAggregated()) {
                    preloadList.add(new StatementAgentInstancePreload(){

                        @Override
                        public void executePreload(ExprEvaluatorContext exprEvaluatorContext) {
                            joinPreloadMethod.preloadAggregation(resultSetProcessor);
                        }
                    });
                }
                if (isRecoveringResilient) {
                    postLoadJoin = new StatementAgentInstancePostLoadSelect(streamViews, joinSetComposer, namedWindowTailViews, namedWindowPostloadFilters, namedWindowFilters, this.statementContext.getAnnotations(), agentInstanceContext);
                } else if (joinSetComposer != null) {
                    postLoadJoin = new StatementAgentInstancePostLoadIndexVisiting(joinSetComposer.getJoinSetComposer());
                }
            }
        }
        catch (RuntimeException ex) {
            StopCallback stopCallback = StatementAgentInstanceUtil.getStopCallback(stopCallbacks, agentInstanceContext);
            StatementAgentInstanceUtil.stopSafe(stopCallback, this.statementContext);
            throw ex;
        }
        StatementAgentInstanceFactorySelectResult selectResult = new StatementAgentInstanceFactorySelectResult(finalView, null, agentInstanceContext, aggregationService, subselectStrategies, priorNodeStrategies, previousNodeStrategies, regexExprPreviousEvalStrategy, tableAccessStrategies, preloadList, patternRoots, postLoadJoin, topViews, eventStreamParentViewable, viewableActivationResult);
        if (this.statementContext.getStatementExtensionServicesContext() != null) {
            this.statementContext.getStatementExtensionServicesContext().contributeStopCallback(selectResult, stopCallbacks);
        }
        StopCallback stopCallback = StatementAgentInstanceUtil.getStopCallback(stopCallbacks, agentInstanceContext);
        selectResult.setStopCallback(stopCallback);
        return selectResult;
    }

    protected static void addViewStopCallback(List<StopCallback> stopCallbacks, List<View> topViews) {
        for (View view : topViews) {
            if (!(view instanceof StoppableView)) continue;
            stopCallbacks.add((StoppableView)((Object)view));
        }
    }

    @Override
    public void assignExpressions(StatementAgentInstanceFactoryResult result) {
        StatementAgentInstanceFactorySelectResult selectResult = (StatementAgentInstanceFactorySelectResult)result;
        EPStatementStartMethodHelperAssignExpr.assignAggregations(selectResult.getOptionalAggegationService(), this.resultSetProcessorFactoryDesc.getAggregationServiceFactoryDesc().getExpressions());
        EPStatementStartMethodHelperAssignExpr.assignSubqueryStrategies(this.subSelectStrategyCollection, result.getSubselectStrategies());
        EPStatementStartMethodHelperAssignExpr.assignPriorStrategies(result.getPriorNodeStrategies());
        EPStatementStartMethodHelperAssignExpr.assignPreviousStrategies(result.getPreviousNodeStrategies());
        Set<ExprPreviousMatchRecognizeNode> matchRecognizeNodes = this.viewResourceDelegate.getPerStream()[0].getMatchRecognizePreviousRequests();
        EPStatementStartMethodHelperAssignExpr.assignMatchRecognizePreviousStrategies(matchRecognizeNodes, result.getRegexExprPreviousEvalStrategy());
    }

    @Override
    public void unassignExpressions() {
        EPStatementStartMethodHelperAssignExpr.unassignAggregations(this.resultSetProcessorFactoryDesc.getAggregationServiceFactoryDesc().getExpressions());
        EPStatementStartMethodHelperAssignExpr.unassignSubqueryStrategies(this.subSelectStrategyCollection.getSubqueries().keySet());
        for (int streamNum = 0; streamNum < this.viewResourceDelegate.getPerStream().length; ++streamNum) {
            ViewResourceDelegateVerifiedStream viewResourceStream = this.viewResourceDelegate.getPerStream()[streamNum];
            SortedMap<Integer, List<ExprPriorNode>> callbacksPerIndex = viewResourceStream.getPriorRequests();
            for (Map.Entry<Integer, List<ExprPriorNode>> priorItem : callbacksPerIndex.entrySet()) {
                EPStatementStartMethodHelperAssignExpr.unassignPriorStrategies((Collection<ExprPriorNode>)priorItem.getValue());
            }
            EPStatementStartMethodHelperAssignExpr.unassignPreviousStrategies(viewResourceStream.getPreviousRequests());
        }
        Set<ExprPreviousMatchRecognizeNode> matchRecognizeNodes = this.viewResourceDelegate.getPerStream()[0].getMatchRecognizePreviousRequests();
        EPStatementStartMethodHelperAssignExpr.unassignMatchRecognizePreviousStrategies(matchRecognizeNodes);
    }

    public ViewableActivator[] getEventStreamParentViewableActivators() {
        return this.eventStreamParentViewableActivators;
    }

    public ViewFactoryChain[] getUnmaterializedViewChain() {
        return this.unmaterializedViewChain;
    }

    public int getNumStreams() {
        return this.numStreams;
    }

    public StatementContext getStatementContext() {
        return this.statementContext;
    }

    public StatementSpecCompiled getStatementSpec() {
        return this.statementSpec;
    }

    public EPServicesContext getServices() {
        return this.services;
    }

    public StreamTypeService getTypeService() {
        return this.typeService;
    }

    public ResultSetProcessorFactoryDesc getResultSetProcessorFactoryDesc() {
        return this.resultSetProcessorFactoryDesc;
    }

    public StreamJoinAnalysisResult getJoinAnalysisResult() {
        return this.joinAnalysisResult;
    }

    public JoinSetComposerPrototype getJoinSetComposerPrototype() {
        return this.joinSetComposerPrototype;
    }

    public SubSelectStrategyCollection getSubSelectStrategyCollection() {
        return this.subSelectStrategyCollection;
    }

    public OutputProcessViewFactory getOutputProcessViewFactory() {
        return this.outputProcessViewFactory;
    }

    private Viewable handleSimpleSelect(Viewable view, ResultSetProcessor resultSetProcessor, AgentInstanceContext agentInstanceContext, EvalRootMatchRemover evalRootMatchRemover, boolean suppressSameEventMatches, boolean discardPartialsOnMatch) {
        Viewable finalView = view;
        if (this.filterRootNodeEvaluator != null) {
            FilterExprView filterView = new FilterExprView(this.statementSpec.getFilterRootNode(), this.filterRootNodeEvaluator, agentInstanceContext);
            finalView.addView(filterView);
            finalView = filterView;
        }
        ArrayDeque<ViewSupport> dispatches = null;
        if (evalRootMatchRemover != null && (suppressSameEventMatches || discardPartialsOnMatch)) {
            PatternRemoveDispatchView v = new PatternRemoveDispatchView(evalRootMatchRemover, suppressSameEventMatches, discardPartialsOnMatch);
            dispatches = new ArrayDeque<ViewSupport>(2);
            dispatches.add(v);
            finalView.addView(v);
            finalView = v;
        }
        if (this.statementSpec.getOrderByList().length > 0 && this.statementSpec.getOutputLimitSpec() == null) {
            SingleStreamDispatchView bf = new SingleStreamDispatchView();
            if (dispatches == null) {
                dispatches = new ArrayDeque(1);
            }
            dispatches.add(bf);
            finalView.addView(bf);
            finalView = bf;
        }
        if (dispatches != null) {
            EPStatementAgentInstanceHandle handle = agentInstanceContext.getEpStatementAgentInstanceHandle();
            if (dispatches.size() == 1) {
                handle.setOptionalDispatchable((EPStatementDispatch)dispatches.getFirst());
            } else {
                final EPStatementDispatch[] dispatchArray = dispatches.toArray(new EPStatementDispatch[dispatches.size()]);
                handle.setOptionalDispatchable(new EPStatementDispatch(){

                    @Override
                    public void execute() {
                        for (EPStatementDispatch dispatch : dispatchArray) {
                            dispatch.execute();
                        }
                    }
                });
            }
        }
        OutputProcessViewBase selectView = this.outputProcessViewFactory.makeView(resultSetProcessor, agentInstanceContext);
        finalView.addView(selectView);
        finalView = selectView;
        return finalView;
    }

    private JoinPlanResult handleJoin(String[] streamNames, Viewable[] streamViews, ResultSetProcessor resultSetProcessor, AgentInstanceContext agentInstanceContext, List<StopCallback> stopCallbacks, StreamJoinAnalysisResult joinAnalysisResult, boolean isRecoveringResilient) {
        final JoinSetComposerDesc joinSetComposerDesc = this.joinSetComposerPrototype.create(streamViews, false, agentInstanceContext, isRecoveringResilient);
        stopCallbacks.add(new StopCallback(){

            @Override
            public void stop() {
                joinSetComposerDesc.getJoinSetComposer().destroy();
            }
        });
        JoinSetFilter filter = new JoinSetFilter(joinSetComposerDesc.getPostJoinFilterEvaluator());
        OutputProcessViewBase indicatorView = this.outputProcessViewFactory.makeView(resultSetProcessor, agentInstanceContext);
        JoinExecutionStrategyImpl execution = new JoinExecutionStrategyImpl(joinSetComposerDesc.getJoinSetComposer(), filter, indicatorView, agentInstanceContext);
        indicatorView.setJoinExecutionStrategy(execution);
        JoinExecStrategyDispatchable joinStatementDispatch = new JoinExecStrategyDispatchable(execution, this.statementSpec.getStreamSpecs().length);
        agentInstanceContext.getEpStatementAgentInstanceHandle().setOptionalDispatchable(joinStatementDispatch);
        JoinPreloadMethod preloadMethod = joinAnalysisResult.isUnidirectional() ? new JoinPreloadMethodNull() : (!joinSetComposerDesc.getJoinSetComposer().allowsInit() ? new JoinPreloadMethodNull() : new JoinPreloadMethodImpl(streamNames.length, joinSetComposerDesc.getJoinSetComposer()));
        for (int i = 0; i < this.statementSpec.getStreamSpecs().length; ++i) {
            BufferView buffer = new BufferView(i);
            streamViews[i].addView(buffer);
            buffer.setObserver(joinStatementDispatch);
            preloadMethod.setBuffer(buffer, i);
        }
        return new JoinPlanResult(indicatorView, preloadMethod, joinSetComposerDesc);
    }

    private static class JoinPlanResult {
        private final Viewable viewable;
        private final JoinPreloadMethod preloadMethod;
        private final JoinSetComposerDesc joinSetComposerDesc;

        private JoinPlanResult(Viewable viewable, JoinPreloadMethod preloadMethod, JoinSetComposerDesc joinSetComposerDesc) {
            this.viewable = viewable;
            this.preloadMethod = preloadMethod;
            this.joinSetComposerDesc = joinSetComposerDesc;
        }

        public Viewable getViewable() {
            return this.viewable;
        }

        public JoinPreloadMethod getPreloadMethod() {
            return this.preloadMethod;
        }

        public JoinSetComposerDesc getJoinSetComposerDesc() {
            return this.joinSetComposerDesc;
        }
    }
}

