/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.core;

import com.espertech.esper.codegen.core.CodeGenerationHelper;
import java.util.Map;
import java.util.Set;

public class CodegenTypedParam {
    private final String typeName;
    private final Class type;
    private final String name;

    public CodegenTypedParam(String typeName, Class type, String name) {
        if (type == null && typeName == null) {
            throw new IllegalArgumentException("Invalid null type");
        }
        this.typeName = typeName;
        this.type = type;
        this.name = name;
    }

    public CodegenTypedParam(Class type, String name) {
        this(null, type, name);
    }

    public CodegenTypedParam(String type, String name) {
        this(type, null, name);
    }

    public String getName() {
        return this.name;
    }

    public void renderAsParameter(StringBuilder builder, Map<Class, String> imports) {
        if (this.type != null) {
            CodeGenerationHelper.appendClassName(builder, this.type, null, imports);
        } else {
            builder.append(this.typeName);
        }
        builder.append(" ").append(this.name);
    }

    public void mergeClasses(Set<Class> classes) {
        if (this.type != null) {
            classes.add(this.type);
        }
    }

    public void renderAsMember(StringBuilder builder, Map<Class, String> imports) {
        if (this.type != null) {
            CodeGenerationHelper.appendClassName(builder, this.type, null, imports);
        } else {
            builder.append(this.typeName);
        }
        builder.append(" ").append(this.name);
    }

    public void renderType(StringBuilder builder, Map<Class, String> imports) {
        if (this.type != null) {
            CodeGenerationHelper.appendClassName(builder, this.type, null, imports);
        } else {
            builder.append(this.typeName);
        }
    }

    public String toString() {
        return "CodegenTypedParam{typeName='" + this.typeName + '\'' + ", type=" + this.type + ", name='" + this.name + '\'' + '}';
    }
}

