/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.core;

import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenSymbolProvider;
import com.espertech.esper.codegen.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.codegen.core.CodegenNamedParam;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class CodegenNamedMethods {
    private Map<String, CodegenMethodNode> methods;

    public CodegenMethodNode addMethod(Class returnType, String methodName, List<CodegenNamedParam> params, Class generator, CodegenClassScope classScope, Consumer<CodegenMethodNode> code) {
        return this.addMethodWithSymbols(returnType, methodName, params, generator, classScope, code, CodegenSymbolProviderEmpty.INSTANCE);
    }

    public CodegenMethodNode addMethodWithSymbols(Class returnType, String methodName, List<CodegenNamedParam> params, Class generator, CodegenClassScope classScope, Consumer<CodegenMethodNode> code, CodegenSymbolProvider symbolProvider) {
        CodegenMethodNode existing;
        if (this.methods == null) {
            this.methods = new HashMap<String, CodegenMethodNode>();
        }
        if ((existing = this.methods.get(methodName)) != null) {
            if (params.equals(existing.getLocalParams())) {
                return existing;
            }
            throw new IllegalStateException("Method by name '" + methodName + "' already registered");
        }
        CodegenMethodNode method = CodegenMethodNode.makeParentNode(returnType, generator, symbolProvider, classScope).addParam(params);
        this.methods.put(methodName, method);
        code.accept(method);
        return method;
    }

    public Map<String, CodegenMethodNode> getMethods() {
        return this.methods == null ? Collections.emptyMap() : this.methods;
    }

    public CodegenMethodNode getMethod(String name) {
        CodegenMethodNode method = this.methods.get(name);
        if (method == null) {
            throw new IllegalStateException("Method by name '" + method + "' not found");
        }
        return method;
    }
}

