/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.core;

import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.core.CodegenClassMethods;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.codegen.core.CodegenInnerClass;
import com.espertech.esper.codegen.core.CodegenMethod;
import com.espertech.esper.codegen.core.CodegenTypedParam;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodegenClass {
    private final String packageName;
    private final String className;
    private final Class interfaceImplemented;
    private final CodegenCtor optionalCtor;
    private final List<CodegenTypedParam> explicitMembers;
    private final IdentityHashMap<Object, CodegenMember> implicitMembers;
    private final CodegenClassMethods methods;
    private final List<CodegenInnerClass> innerClasses;

    public CodegenClass(Class interfaceClass, String packageName, String className, CodegenClassScope codegenClassScope, List<CodegenTypedParam> explicitMembers, CodegenCtor optionalCtor, CodegenClassMethods methods, List<CodegenInnerClass> innerClasses) {
        this(packageName, className, interfaceClass, explicitMembers, codegenClassScope.getMembers(), optionalCtor, methods, innerClasses);
    }

    private CodegenClass(String packageName, String className, Class interfaceImplemented, List<CodegenTypedParam> explicitMembers, IdentityHashMap<Object, CodegenMember> implicitMembers, CodegenCtor optionalCtor, CodegenClassMethods methods, List<CodegenInnerClass> innerClasses) {
        this.packageName = packageName;
        this.className = className;
        this.interfaceImplemented = interfaceImplemented;
        this.explicitMembers = explicitMembers;
        this.implicitMembers = implicitMembers;
        this.optionalCtor = optionalCtor;
        this.methods = methods;
        this.innerClasses = innerClasses;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public Class getInterfaceImplemented() {
        return this.interfaceImplemented;
    }

    public List<CodegenTypedParam> getExplicitMembers() {
        return this.explicitMembers;
    }

    public IdentityHashMap<Object, CodegenMember> getImplicitMembers() {
        return this.implicitMembers;
    }

    public List<CodegenMethod> getPublicMethods() {
        return this.methods.getPublicMethods();
    }

    public List<CodegenMethod> getPrivateMethods() {
        return this.methods.getPrivateMethods();
    }

    public List<CodegenInnerClass> getInnerClasses() {
        return this.innerClasses;
    }

    public CodegenCtor getOptionalCtor() {
        return this.optionalCtor;
    }

    public Set<Class> getReferencedClasses() {
        HashSet<Class> classes = new HashSet<Class>();
        CodegenClass.addReferencedClasses(this.interfaceImplemented, this.implicitMembers, this.methods, classes);
        CodegenClass.addReferencedClasses(this.explicitMembers, classes);
        if (this.optionalCtor != null) {
            this.optionalCtor.mergeClasses(classes);
        }
        for (CodegenInnerClass inner : this.innerClasses) {
            CodegenClass.addReferencedClasses(inner.getInterfaceImplemented(), inner.getImplicitMembers(), inner.getMethods(), classes);
            CodegenClass.addReferencedClasses(inner.getExplicitMembers(), classes);
            if (inner.getCtor() == null) continue;
            inner.getCtor().mergeClasses(classes);
        }
        return classes;
    }

    private static void addReferencedClasses(Class interfaceImplemented, Map<Object, CodegenMember> members, CodegenClassMethods methods, Set<Class> classes) {
        if (interfaceImplemented != null) {
            classes.add(interfaceImplemented);
        }
        for (Map.Entry<Object, CodegenMember> memberEntry : members.entrySet()) {
            memberEntry.getValue().mergeClasses(classes);
        }
        for (CodegenMethod publicMethod : methods.getPublicMethods()) {
            publicMethod.mergeClasses(classes);
        }
        for (CodegenMethod privateMethod : methods.getPrivateMethods()) {
            privateMethod.mergeClasses(classes);
        }
    }

    private static void addReferencedClasses(List<CodegenTypedParam> names, Set<Class> classes) {
        for (CodegenTypedParam param : names) {
            param.mergeClasses(classes);
        }
    }
}

