/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.compile;

import com.espertech.esper.client.EPException;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.compile.CodeGenerationUtil;
import com.espertech.esper.codegen.compile.CodegenCompilerException;
import com.espertech.esper.codegen.core.CodeGenerationHelper;
import com.espertech.esper.codegen.core.CodegenClass;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.codegen.core.CodegenIndent;
import com.espertech.esper.codegen.core.CodegenInnerClass;
import com.espertech.esper.codegen.core.CodegenMethod;
import com.espertech.esper.codegen.core.CodegenTypedParam;
import com.espertech.esper.codegen.util.CodegenClassUtil;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class CodegenClassGenerator {
    private static final CodegenIndent INDENT = new CodegenIndent(true);

    public static <T> T compile(CodegenClass clazz, EngineImportService engineImportService, Class<T> interfaceClass, Supplier<String> debugInformation) throws CodegenCompilerException {
        LinkedHashSet<CodegenMember> memberSet = new LinkedHashSet<CodegenMember>(clazz.getImplicitMembers().values());
        Set<Class> classes = clazz.getReferencedClasses();
        Map<Class, String> imports = CodegenClassGenerator.compileImports(classes);
        String code = CodegenClassGenerator.generateCode(imports, clazz, memberSet);
        String fullyQualifiedClassName = clazz.getPackageName() + "." + clazz.getClassName();
        Class compiled = engineImportService.getCodegenCompiler().compileClass(code, fullyQualifiedClassName, engineImportService.getClassLoader(), debugInformation);
        Object[] params = new Object[memberSet.size()];
        int count = 0;
        for (CodegenMember member : memberSet) {
            params[count++] = member.getObject();
        }
        try {
            return interfaceClass.cast(compiled.getConstructors()[0].newInstance(params));
        }
        catch (Exception ex) {
            throw new EPException("Failed to instantiate code-generated class: " + ex.getMessage(), ex);
        }
    }

    private static Map<Class, String> compileImports(Set<Class> classes) {
        HashMap<Class, String> imports = new HashMap<Class, String>();
        HashMap<String, Class> assignments = new HashMap<String, Class>();
        for (Class clazz : classes) {
            if (clazz == null || clazz.getEnclosingClass() != null) continue;
            if (clazz.isArray()) {
                CodegenClassGenerator.compileImports(CodegenClassUtil.getComponentTypeOutermost(clazz), imports, assignments);
                continue;
            }
            CodegenClassGenerator.compileImports(clazz, imports, assignments);
        }
        return imports;
    }

    private static void compileImports(Class clazz, Map<Class, String> imports, Map<String, Class> assignments) {
        if (clazz == null || clazz.isPrimitive()) {
            return;
        }
        try {
            if (clazz.getPackage() != null && clazz.getPackage().getName().equals("java.lang")) {
                imports.put(clazz, clazz.getSimpleName());
                return;
            }
        }
        catch (Throwable r) {
            System.out.println(r);
        }
        if (assignments.containsKey(clazz.getSimpleName())) {
            return;
        }
        imports.put(clazz, clazz.getSimpleName());
        assignments.put(clazz.getSimpleName(), clazz);
    }

    private static String generateCode(Map<Class, String> imports, CodegenClass clazz, Set<CodegenMember> implicitMemberSet) {
        StringBuilder builder = new StringBuilder();
        CodeGenerationUtil.packagedecl(builder, clazz.getPackageName());
        CodeGenerationUtil.importsdecl(builder, imports.keySet());
        CodeGenerationUtil.classimplements(builder, clazz.getClassName(), clazz.getInterfaceImplemented(), true, false, imports);
        CodegenClassGenerator.generateCodeMembers(builder, clazz.getExplicitMembers(), clazz.getOptionalCtor(), implicitMemberSet, imports, 1);
        CodegenClassGenerator.generateCodeCtor(builder, clazz.getClassName(), false, clazz.getOptionalCtor(), implicitMemberSet, imports, 0);
        CodegenClassGenerator.generateCodeMethods(builder, false, clazz.getPublicMethods(), clazz.getPrivateMethods(), imports, 0);
        for (CodegenInnerClass inner : clazz.getInnerClasses()) {
            builder.append("\n");
            INDENT.indent(builder, 1);
            CodeGenerationUtil.classimplements(builder, inner.getClassName(), inner.getInterfaceImplemented(), false, true, imports);
            LinkedHashSet<CodegenMember> innerMembers = new LinkedHashSet<CodegenMember>(inner.getImplicitMembers().values());
            CodegenClassGenerator.generateCodeMembers(builder, inner.getExplicitMembers(), inner.getCtor(), innerMembers, imports, 2);
            CodegenClassGenerator.generateCodeCtor(builder, inner.getClassName(), true, inner.getCtor(), innerMembers, imports, 1);
            CodegenClassGenerator.generateCodeMethods(builder, true, inner.getMethods().getPublicMethods(), inner.getMethods().getPrivateMethods(), imports, 1);
            INDENT.indent(builder, 1);
            builder.append("}\n");
        }
        builder.append("}\n");
        return builder.toString();
    }

    private static void generateCodeMethods(StringBuilder builder, boolean isInnerClass, List<CodegenMethod> publicMethods, List<CodegenMethod> privateMethods, Map<Class, String> imports, int additionalIndent) {
        String delimiter = "";
        for (CodegenMethod publicMethod : publicMethods) {
            builder.append(delimiter);
            publicMethod.render(builder, imports, true, isInnerClass, INDENT, additionalIndent);
            delimiter = "\n";
        }
        for (CodegenMethod method : privateMethods) {
            builder.append(delimiter);
            method.render(builder, imports, false, isInnerClass, INDENT, additionalIndent);
            delimiter = "\n";
        }
    }

    private static void generateCodeCtor(StringBuilder builder, String className, boolean isInnerClass, CodegenCtor optionalCtor, Set<CodegenMember> memberSet, Map<Class, String> imports, int additionalIndent) {
        INDENT.indent(builder, 1 + additionalIndent);
        builder.append("public ").append(className).append("(");
        String delimiter = "";
        if (optionalCtor != null) {
            for (CodegenTypedParam param : optionalCtor.getCtorParams()) {
                builder.append(delimiter);
                param.renderAsParameter(builder, imports);
                delimiter = ",";
            }
        }
        for (CodegenMember member : memberSet) {
            builder.append(delimiter);
            CodeGenerationHelper.appendClassName(builder, member.getMemberClass(), member.getOptionalTypeParam(), imports);
            builder.append(" ");
            member.getMemberId().renderPrefixed(builder, 'p');
            delimiter = ",";
        }
        builder.append("){\n");
        if (optionalCtor != null) {
            for (CodegenTypedParam param : optionalCtor.getCtorParams()) {
                INDENT.indent(builder, 2 + additionalIndent);
                builder.append("this.").append(param.getName()).append("=").append(param.getName()).append(";\n");
            }
        }
        for (CodegenMember member : memberSet) {
            INDENT.indent(builder, 2 + additionalIndent);
            builder.append("this.");
            member.getMemberId().render(builder);
            builder.append("=");
            member.getMemberId().renderPrefixed(builder, 'p');
            builder.append(";\n");
        }
        if (optionalCtor != null) {
            optionalCtor.getBlock().render(builder, imports, isInnerClass, 2 + additionalIndent, INDENT);
        }
        INDENT.indent(builder, 1 + additionalIndent);
        builder.append("}\n");
        builder.append("\n");
    }

    private static void generateCodeMembers(StringBuilder builder, List<CodegenTypedParam> explicitMembers, CodegenCtor optionalCtor, Set<CodegenMember> memberSet, Map<Class, String> imports, int indent) {
        if (optionalCtor != null) {
            for (CodegenTypedParam param : optionalCtor.getCtorParams()) {
                INDENT.indent(builder, indent);
                builder.append("final ");
                param.renderAsMember(builder, imports);
                builder.append(";\n");
            }
        }
        for (CodegenMember member : memberSet) {
            INDENT.indent(builder, indent);
            builder.append("final ");
            CodeGenerationHelper.appendClassName(builder, member.getMemberClass(), member.getOptionalTypeParam(), imports);
            builder.append(" ");
            member.getMemberId().render(builder);
            builder.append(";\n");
        }
        for (CodegenTypedParam param : explicitMembers) {
            INDENT.indent(builder, indent);
            builder.append("final ");
            param.renderType(builder, imports);
            builder.append(" ").append(param.getName());
            builder.append(";\n");
        }
        builder.append("\n");
    }
}

