/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.base;

import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.base.CodegenSymbolProvider;
import com.espertech.esper.codegen.core.CodegenMethod;
import com.espertech.esper.codegen.core.CodegenNamedParam;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CodegenMethodNode
implements CodegenMethodScope {
    private final Class returnType;
    private final CodegenBlock block;
    private final String additionalDebugInfo;
    private final CodegenSymbolProvider optionalSymbolProvider;
    private List<CodegenMethodNode> children = Collections.emptyList();
    private List<CodegenExpressionRef> environment = Collections.emptyList();
    private List<CodegenNamedParam> localParams = Collections.emptyList();
    private Set<String> deepParameters;
    private CodegenMethod assignedMethod;

    protected CodegenMethodNode(Class returnType, Class generator, CodegenSymbolProvider optionalSymbolProvider, CodegenClassScope codegenClassScope) {
        this.returnType = returnType;
        this.optionalSymbolProvider = optionalSymbolProvider;
        this.block = new CodegenBlock(this);
        this.additionalDebugInfo = codegenClassScope.isDebug() ? this.getGeneratorDetail(generator) : generator.getSimpleName();
    }

    public static CodegenMethodNode makeParentNode(Class returnType, Class generator, CodegenSymbolProvider symbolProvider, CodegenClassScope codegenClassScope) {
        if (symbolProvider == null) {
            throw new IllegalArgumentException("No symbol provider");
        }
        return new CodegenMethodNode(returnType, generator, symbolProvider, codegenClassScope);
    }

    @Override
    public CodegenMethodNode makeChild(Class returnType, Class generator, CodegenClassScope codegenClassScope) {
        return this.addChild(new CodegenMethodNode(returnType, generator, null, codegenClassScope));
    }

    @Override
    public CodegenMethodNode makeChildWithScope(Class returnType, Class generator, CodegenSymbolProvider symbolProvider, CodegenClassScope codegenClassScope) {
        return this.addChild(new CodegenMethodNode(returnType, generator, symbolProvider, codegenClassScope));
    }

    @Override
    public CodegenMethodNode addSymbol(CodegenExpressionRef symbol) {
        if (this.environment.isEmpty()) {
            this.environment = new ArrayList<CodegenExpressionRef>(4);
        }
        this.environment.add(symbol);
        return this;
    }

    public void mergeClasses(Set<Class> classes) {
        this.block.mergeClasses(classes);
        classes.add(this.returnType);
    }

    public CodegenSymbolProvider getOptionalSymbolProvider() {
        return this.optionalSymbolProvider;
    }

    public List<CodegenMethodNode> getChildren() {
        return this.children;
    }

    public List<CodegenExpressionRef> getEnvironment() {
        return this.environment;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public String getAdditionalDebugInfo() {
        return this.additionalDebugInfo;
    }

    public CodegenBlock getBlock() {
        return this.block;
    }

    public List<CodegenNamedParam> getLocalParams() {
        return this.localParams;
    }

    public CodegenMethodNode addParam(Class type, String name) {
        if (this.localParams.isEmpty()) {
            this.localParams = new ArrayList<CodegenNamedParam>(4);
        }
        this.localParams.add(new CodegenNamedParam(type, name));
        return this;
    }

    public CodegenMethodNode addParam(List<CodegenNamedParam> params) {
        if (this.localParams.isEmpty()) {
            this.localParams = new ArrayList<CodegenNamedParam>(params.size());
        }
        this.localParams.addAll(params);
        return this;
    }

    public Set<String> getDeepParameters() {
        return this.deepParameters;
    }

    public void setDeepParameters(Set<String> deepParameters) {
        this.deepParameters = deepParameters;
    }

    public CodegenMethod getAssignedMethod() {
        return this.assignedMethod;
    }

    public void setAssignedMethod(CodegenMethod assignedMethod) {
        this.assignedMethod = assignedMethod;
    }

    private String getGeneratorDetail(Class generator) {
        String fullClassName = Thread.currentThread().getStackTrace()[3].getClassName();
        String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        String methodName = Thread.currentThread().getStackTrace()[3].getMethodName();
        int lineNumber = Thread.currentThread().getStackTrace()[3].getLineNumber();
        return generator.getName() + " --- " + className + "." + methodName + "():" + lineNumber;
    }

    private CodegenMethodNode addChild(CodegenMethodNode methodNode) {
        if (this.children.isEmpty()) {
            this.children = new ArrayList<CodegenMethodNode>();
        }
        this.children.add(methodNode);
        return methodNode;
    }
}

