/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.base;

import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMemberId;
import java.util.IdentityHashMap;

public class CodegenClassScope {
    private final boolean debug;
    private final IdentityHashMap<Object, CodegenMember> members = new IdentityHashMap();
    private int currentMemberNumber;

    public CodegenClassScope(boolean debug) {
        this.debug = debug;
    }

    public CodegenClassScope(boolean debug, int currentMemberNumber) {
        this.debug = debug;
        this.currentMemberNumber = currentMemberNumber;
    }

    public <T> CodegenMember makeAddMember(Class<? extends T> clazz, T object) {
        CodegenMember existing = this.members.get(object);
        if (existing != null && object != null) {
            return existing;
        }
        int memberNumber = this.currentMemberNumber++;
        CodegenMember member = new CodegenMember(new CodegenMemberId(memberNumber), clazz, object);
        this.members.put(object != null ? object : new Object(), member);
        return member;
    }

    public IdentityHashMap<Object, CodegenMember> getMembers() {
        return this.members;
    }

    public boolean isDebug() {
        return this.debug;
    }
}

