/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;
import java.util.List;

public class TableAccessExpression
extends ExpressionBase {
    private static final long serialVersionUID = 8878898170678366785L;
    private String tableName;
    private List<Expression> keyExpressions;
    private String optionalColumn;
    private Expression optionalAggregate;

    public TableAccessExpression() {
    }

    public TableAccessExpression(String tableName, List<Expression> keyExpressions, String optionalColumn, Expression optionalAggregate) {
        this.tableName = tableName;
        this.keyExpressions = keyExpressions;
        this.optionalColumn = optionalColumn;
        this.optionalAggregate = optionalAggregate;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write(this.tableName);
        if (this.keyExpressions != null && !this.keyExpressions.isEmpty()) {
            writer.write("[");
            ExpressionBase.toPrecedenceFreeEPL(this.keyExpressions, writer);
            writer.write("]");
        }
        if (this.optionalColumn != null) {
            writer.write(".");
            writer.write(this.optionalColumn);
        }
        if (this.optionalAggregate != null) {
            writer.write(".");
            this.optionalAggregate.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<Expression> getKeyExpressions() {
        return this.keyExpressions;
    }

    public void setKeyExpressions(List<Expression> keyExpressions) {
        this.keyExpressions = keyExpressions;
    }

    public String getOptionalColumn() {
        return this.optionalColumn;
    }

    public void setOptionalColumn(String optionalColumn) {
        this.optionalColumn = optionalColumn;
    }

    public Expression getOptionalAggregate() {
        return this.optionalAggregate;
    }

    public void setOptionalAggregate(Expression optionalAggregate) {
        this.optionalAggregate = optionalAggregate;
    }
}

