/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.ConstantExpression;
import com.espertech.esper.client.soda.DotExpressionItem;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class StaticMethodExpression
extends ExpressionBase {
    private static final long serialVersionUID = -8876482797010708113L;
    private String className;
    private List<DotExpressionItem> chain = new ArrayList<DotExpressionItem>();

    public StaticMethodExpression(String className, String method, Object[] parameters) {
        this.className = className;
        ArrayList<Expression> parameterList = new ArrayList<Expression>();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] instanceof Expression) {
                parameterList.add((Expression)parameters[i]);
                continue;
            }
            parameterList.add(new ConstantExpression(parameters[i]));
        }
        this.chain.add(new DotExpressionItem(method, parameterList, false));
    }

    public List<DotExpressionItem> getChain() {
        return this.chain;
    }

    public void setChain(List<DotExpressionItem> chain) {
        this.chain = chain;
    }

    public StaticMethodExpression(String className, List<DotExpressionItem> chain) {
        this.className = className;
        this.chain = chain;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write(this.className);
        DotExpressionItem.render(this.chain, writer, true);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

