/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.ConstantExpression;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;
import java.util.Locale;

public class RelationalOpExpression
extends ExpressionBase {
    private String operator;
    private static final long serialVersionUID = -4590496481449181068L;

    public RelationalOpExpression() {
    }

    public RelationalOpExpression(String operator) {
        this.operator = operator.trim();
    }

    public RelationalOpExpression(Expression left, String operator, Expression right) {
        this.operator = operator.trim();
        this.addChild(left);
        if (right != null) {
            this.addChild(right);
        } else {
            this.addChild(new ConstantExpression(null));
        }
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        if (this.operator.equals("=")) {
            return ExpressionPrecedenceEnum.EQUALS;
        }
        return ExpressionPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildren().get(0).toEPL(writer, this.getPrecedence());
        if (this.operator.toLowerCase(Locale.ENGLISH).trim().equals("is") || this.operator.toLowerCase(Locale.ENGLISH).trim().equals("is not")) {
            writer.write(32);
            writer.write(this.operator);
            writer.write(32);
        } else {
            writer.write(this.operator);
        }
        this.getChildren().get(1).toEPL(writer, this.getPrecedence());
    }
}

