/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.CrontabParameterExpression;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.Expressions;
import com.espertech.esper.client.soda.Filter;
import com.espertech.esper.client.soda.GuardEnum;
import com.espertech.esper.client.soda.PatternAndExpr;
import com.espertech.esper.client.soda.PatternEveryExpr;
import com.espertech.esper.client.soda.PatternExpr;
import com.espertech.esper.client.soda.PatternFilterExpr;
import com.espertech.esper.client.soda.PatternFollowedByExpr;
import com.espertech.esper.client.soda.PatternGuardExpr;
import com.espertech.esper.client.soda.PatternMatchUntilExpr;
import com.espertech.esper.client.soda.PatternNotExpr;
import com.espertech.esper.client.soda.PatternObserverExpr;
import com.espertech.esper.client.soda.PatternOrExpr;
import com.espertech.esper.client.soda.ScheduleItemType;
import java.util.ArrayList;

public class Patterns {
    public static PatternEveryExpr every(PatternExpr inner) {
        return new PatternEveryExpr(inner);
    }

    public static PatternAndExpr and() {
        return new PatternAndExpr();
    }

    public static PatternAndExpr and(PatternExpr first, PatternExpr second, PatternExpr ... more) {
        return new PatternAndExpr(first, second, more);
    }

    public static PatternOrExpr or(PatternExpr first, PatternExpr second, PatternExpr ... more) {
        return new PatternOrExpr(first, second, more);
    }

    public static PatternOrExpr or() {
        return new PatternOrExpr();
    }

    public static PatternFollowedByExpr followedBy(PatternExpr first, PatternExpr second, PatternExpr ... more) {
        return new PatternFollowedByExpr(first, second, more);
    }

    public static PatternFollowedByExpr followedBy() {
        return new PatternFollowedByExpr();
    }

    public static PatternEveryExpr everyFilter(String eventTypeName) {
        PatternFilterExpr filter = new PatternFilterExpr(Filter.create(eventTypeName));
        return new PatternEveryExpr(filter);
    }

    public static PatternEveryExpr everyFilter(String eventTypeName, String tagName) {
        PatternFilterExpr filter = new PatternFilterExpr(Filter.create(eventTypeName), tagName);
        return new PatternEveryExpr(filter);
    }

    public static PatternEveryExpr everyFilter(Filter filter) {
        PatternFilterExpr inner = new PatternFilterExpr(filter);
        return new PatternEveryExpr(inner);
    }

    public static PatternEveryExpr everyFilter(Filter filter, String tagName) {
        PatternFilterExpr inner = new PatternFilterExpr(filter, tagName);
        return new PatternEveryExpr(inner);
    }

    public static PatternFilterExpr filter(String eventTypeName) {
        return new PatternFilterExpr(Filter.create(eventTypeName));
    }

    public static PatternFilterExpr filter(String eventTypeName, String tagName) {
        return new PatternFilterExpr(Filter.create(eventTypeName), tagName);
    }

    public static PatternFilterExpr filter(Filter filter) {
        return new PatternFilterExpr(filter);
    }

    public static PatternFilterExpr filter(Filter filter, String tagName) {
        return new PatternFilterExpr(filter, tagName);
    }

    public static PatternGuardExpr guard(String namespace, String name, Expression[] parameters, PatternExpr guarded) {
        return new PatternGuardExpr(namespace, name, parameters, guarded);
    }

    public static PatternObserverExpr observer(String namespace, String name, Expression[] parameters) {
        return new PatternObserverExpr(namespace, name, parameters);
    }

    public static PatternGuardExpr timerWithin(double seconds, PatternExpr guarded) {
        return new PatternGuardExpr("timer", "within", new Expression[]{Expressions.constant(seconds)}, guarded);
    }

    public static PatternGuardExpr whileGuard(PatternExpr guarded, Expression expression) {
        return new PatternGuardExpr(GuardEnum.WHILE_GUARD.getNamespace(), GuardEnum.WHILE_GUARD.getName(), new Expression[]{expression}, guarded);
    }

    public static PatternGuardExpr timerWithinMax(double seconds, int max, PatternExpr guarded) {
        return new PatternGuardExpr("timer", "withinmax", new Expression[]{Expressions.constant(seconds), Expressions.constant(max)}, guarded);
    }

    public static PatternObserverExpr timerInterval(double seconds) {
        return new PatternObserverExpr("timer", "interval", new Expression[]{Expressions.constant(seconds)});
    }

    public static PatternNotExpr notFilter(String eventTypeName) {
        return new PatternNotExpr(new PatternFilterExpr(Filter.create(eventTypeName)));
    }

    public static PatternNotExpr notFilter(String name, String tagName) {
        return new PatternNotExpr(new PatternFilterExpr(Filter.create(name), tagName));
    }

    public static PatternNotExpr notFilter(Filter filter) {
        return new PatternNotExpr(new PatternFilterExpr(filter));
    }

    public static PatternNotExpr notFilter(Filter filter, String tagName) {
        return new PatternNotExpr(new PatternFilterExpr(filter, tagName));
    }

    public static PatternNotExpr not(PatternExpr subexpression) {
        return new PatternNotExpr(subexpression);
    }

    public static PatternMatchUntilExpr matchUntil(Expression low, Expression high, PatternExpr match, PatternExpr until) {
        return new PatternMatchUntilExpr(low, high, match, until);
    }

    public static PatternObserverExpr timerAt(Integer minutes, Integer hours, Integer daysOfMonth, Integer month, Integer daysOfWeek, Integer seconds) {
        CrontabParameterExpression wildcard = new CrontabParameterExpression(ScheduleItemType.WILDCARD);
        ArrayList<Expression> parameters = new ArrayList<Expression>();
        parameters.add(minutes == null ? wildcard : Expressions.constant(minutes));
        parameters.add(hours == null ? wildcard : Expressions.constant(hours));
        parameters.add(daysOfMonth == null ? wildcard : Expressions.constant(daysOfMonth));
        parameters.add(month == null ? wildcard : Expressions.constant(month));
        parameters.add(daysOfWeek == null ? wildcard : Expressions.constant(daysOfWeek));
        parameters.add(seconds == null ? wildcard : Expressions.constant(seconds));
        return new PatternObserverExpr("timer", "at", parameters);
    }
}

