/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.ContextDescriptorCondition;
import com.espertech.esper.client.soda.EPStatementFormatter;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;
import java.util.List;

public class ContextDescriptorConditionCrontab
implements ContextDescriptorCondition {
    private static final long serialVersionUID = 5676956299459269157L;
    private List<Expression> crontabExpressions;
    private boolean now;

    public ContextDescriptorConditionCrontab() {
    }

    public ContextDescriptorConditionCrontab(List<Expression> crontabExpressions, boolean now) {
        this.crontabExpressions = crontabExpressions;
        this.now = now;
    }

    public List<Expression> getCrontabExpressions() {
        return this.crontabExpressions;
    }

    public void setCrontabExpressions(List<Expression> crontabExpressions) {
        this.crontabExpressions = crontabExpressions;
    }

    @Override
    public void toEPL(StringWriter writer, EPStatementFormatter formatter) {
        ContextDescriptorConditionCrontab.write(writer, this.crontabExpressions, this.now);
    }

    public boolean isNow() {
        return this.now;
    }

    public void setNow(boolean now) {
        this.now = now;
    }

    private static void write(StringWriter writer, List<Expression> expressions, boolean now) {
        if (now) {
            writer.append("@now and ");
        }
        writer.append("(");
        String delimiter = "";
        for (Expression e : expressions) {
            writer.append(delimiter);
            e.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ", ";
        }
        writer.append(")");
    }
}

