/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;

public class CastExpression
extends ExpressionBase {
    private String typeName;
    private static final long serialVersionUID = -8931072217889088459L;

    public CastExpression() {
    }

    public CastExpression(String typeName) {
        this.typeName = typeName;
    }

    public CastExpression(Expression expressionToCheck, String typeName) {
        this.getChildren().add(expressionToCheck);
        this.typeName = typeName;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write("cast(");
        this.getChildren().get(0).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        writer.write(",");
        writer.write(this.typeName);
        for (int i = 1; i < this.getChildren().size(); ++i) {
            writer.write(",");
            this.getChildren().get(i).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
        writer.write(")");
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
}

