/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.scopetest;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.client.scopetest.ScopeTestHelper;
import com.espertech.esper.collection.UniformPair;
import java.util.LinkedList;
import java.util.List;

public class SupportUpdateListener
implements UpdateListener {
    private final List<EventBean[]> newDataList = new LinkedList<EventBean[]>();
    private final List<EventBean[]> oldDataList = new LinkedList<EventBean[]>();
    private EventBean[] lastNewData;
    private EventBean[] lastOldData;
    private boolean isInvoked;

    public void waitForInvocation(long msecWait) {
        long startTime = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() - startTime > msecWait) {
                throw new RuntimeException("No result received");
            }
            if (this.isInvoked()) {
                return;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public void waitForInvocation(long msecWait, int numberOfNewEvents) {
        long startTime = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() - startTime > msecWait) {
                throw new RuntimeException("No events or less then the number of expected events received, expected " + numberOfNewEvents + " received " + this.getNewDataListFlattened().length);
            }
            EventBean[] events = this.getNewDataListFlattened();
            if (events.length >= numberOfNewEvents) {
                return;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    @Override
    public synchronized void update(EventBean[] newData, EventBean[] oldData) {
        this.oldDataList.add(oldData);
        this.newDataList.add(newData);
        this.lastNewData = newData;
        this.lastOldData = oldData;
        this.isInvoked = true;
    }

    public synchronized void reset() {
        this.oldDataList.clear();
        this.newDataList.clear();
        this.lastNewData = null;
        this.lastOldData = null;
        this.isInvoked = false;
    }

    public EventBean[] getLastNewData() {
        return this.lastNewData;
    }

    public EventBean[] getLastOldData() {
        return this.lastOldData;
    }

    public synchronized EventBean[] getAndResetLastNewData() {
        EventBean[] lastNew = this.lastNewData;
        this.reset();
        return lastNew;
    }

    public synchronized EventBean[] getAndResetLastOldData() {
        EventBean[] lastOld = this.lastOldData;
        this.reset();
        return lastOld;
    }

    public synchronized EventBean assertOneGetNewAndReset() {
        ScopeTestHelper.assertTrue("Listener invocation not received but expected", this.isInvoked);
        ScopeTestHelper.assertEquals("Mismatch in the number of invocations", 1, this.newDataList.size());
        ScopeTestHelper.assertEquals("Mismatch in the number of invocations", 1, this.oldDataList.size());
        if (this.lastNewData == null) {
            ScopeTestHelper.fail("No new-data events received");
        }
        ScopeTestHelper.assertEquals("Mismatch in the number of new-data events", 1, this.lastNewData.length);
        ScopeTestHelper.assertNull("No old-data events are expected but some were received", this.lastOldData);
        EventBean lastNew = this.lastNewData[0];
        this.reset();
        return lastNew;
    }

    public synchronized EventBean assertOneGetOldAndReset() {
        ScopeTestHelper.assertTrue("Listener invocation not received but expected", this.isInvoked);
        ScopeTestHelper.assertEquals("Mismatch in the number of invocations", 1, this.newDataList.size());
        ScopeTestHelper.assertEquals("Mismatch in the number of invocations", 1, this.oldDataList.size());
        if (this.lastOldData == null) {
            ScopeTestHelper.fail("No old-data events received");
        }
        ScopeTestHelper.assertEquals("Mismatch in the number of old-data events", 1, this.lastOldData.length);
        ScopeTestHelper.assertNull("Expected no new-data events", this.lastNewData);
        EventBean lastNew = this.lastOldData[0];
        this.reset();
        return lastNew;
    }

    public synchronized UniformPair<EventBean> assertPairGetIRAndReset() {
        ScopeTestHelper.assertTrue("Listener invocation not received but expected", this.isInvoked);
        ScopeTestHelper.assertEquals("Mismatch in the number of invocations", 1, this.newDataList.size());
        ScopeTestHelper.assertEquals("Mismatch in the number of invocations", 1, this.oldDataList.size());
        if (this.lastNewData == null) {
            ScopeTestHelper.fail("No new-data events received");
        }
        if (this.lastOldData == null) {
            ScopeTestHelper.fail("No old-data events received");
        }
        ScopeTestHelper.assertEquals("Mismatch in the number of new-data events", 1, this.lastNewData.length);
        ScopeTestHelper.assertEquals("Mismatch in the number of old-data events", 1, this.lastOldData.length);
        EventBean lastNew = this.lastNewData[0];
        EventBean lastOld = this.lastOldData[0];
        this.reset();
        return new UniformPair<EventBean>(lastNew, lastOld);
    }

    public synchronized EventBean assertOneGetNew() {
        ScopeTestHelper.assertTrue("Listener invocation not received but expected", this.isInvoked);
        ScopeTestHelper.assertEquals("Mismatch in the number of invocations", 1, this.newDataList.size());
        ScopeTestHelper.assertEquals("Mismatch in the number of invocations", 1, this.oldDataList.size());
        if (this.lastNewData == null) {
            ScopeTestHelper.fail("No new-data events received");
        }
        ScopeTestHelper.assertEquals("Mismatch in the number of new-data events", 1, this.lastNewData.length);
        return this.lastNewData[0];
    }

    public synchronized EventBean assertOneGetOld() {
        ScopeTestHelper.assertTrue("Listener invocation not received but expected", this.isInvoked);
        ScopeTestHelper.assertEquals("Mismatch in the number of invocations", 1, this.newDataList.size());
        ScopeTestHelper.assertEquals("Mismatch in the number of invocations", 1, this.oldDataList.size());
        if (this.lastOldData == null) {
            ScopeTestHelper.fail("No old-data events received");
        }
        ScopeTestHelper.assertEquals("Mismatch in the number of old-data events", 1, this.lastOldData.length);
        return this.lastOldData[0];
    }

    public List<EventBean[]> getNewDataList() {
        return this.newDataList;
    }

    public List<EventBean[]> getOldDataList() {
        return this.oldDataList;
    }

    public boolean isInvoked() {
        return this.isInvoked;
    }

    public synchronized boolean getAndClearIsInvoked() {
        boolean invoked = this.isInvoked;
        this.isInvoked = false;
        return invoked;
    }

    public synchronized boolean getIsInvokedAndReset() {
        boolean invoked = this.isInvoked;
        this.reset();
        return invoked;
    }

    public void setLastNewData(EventBean[] lastNewData) {
        this.lastNewData = lastNewData;
    }

    public void setLastOldData(EventBean[] lastOldData) {
        this.lastOldData = lastOldData;
    }

    public synchronized EventBean[] getNewDataListFlattened() {
        return this.flatten(this.newDataList);
    }

    public synchronized EventBean[] getOldDataListFlattened() {
        return this.flatten(this.oldDataList);
    }

    private EventBean[] flatten(List<EventBean[]> list) {
        int count = 0;
        for (EventBean[] events : list) {
            if (events == null) continue;
            count += events.length;
        }
        EventBean[] array = new EventBean[count];
        count = 0;
        for (EventBean[] events : list) {
            if (events == null) continue;
            for (int i = 0; i < events.length; ++i) {
                array[count++] = events[i];
            }
        }
        return array;
    }

    public synchronized UniformPair<EventBean[]> assertInvokedAndReset() {
        ScopeTestHelper.assertTrue("Listener invocation not received but expected", this.isInvoked);
        ScopeTestHelper.assertEquals("Received more then one invocation", 1, this.getNewDataList().size());
        ScopeTestHelper.assertEquals("Received more then one invocation", 1, this.getOldDataList().size());
        EventBean[] newEvents = this.getLastNewData();
        EventBean[] oldEvents = this.getLastOldData();
        this.reset();
        return new UniformPair<EventBean[]>(newEvents, oldEvents);
    }

    public synchronized UniformPair<EventBean[]> getDataListsFlattened() {
        return new UniformPair<EventBean[]>(this.flatten(this.newDataList), this.flatten(this.oldDataList));
    }

    public synchronized UniformPair<EventBean[]> getAndResetDataListsFlattened() {
        UniformPair<EventBean[]> pair = this.getDataListsFlattened();
        this.reset();
        return pair;
    }

    public static boolean[] getInvokedFlagsAndReset(SupportUpdateListener[] listeners) {
        boolean[] invoked = new boolean[listeners.length];
        for (int i = 0; i < listeners.length; ++i) {
            invoked[i] = listeners[i].getIsInvokedAndReset();
        }
        return invoked;
    }

    public static SupportUpdateListener[] makeListeners(int size) {
        SupportUpdateListener[] listeners = new SupportUpdateListener[size];
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i] = new SupportUpdateListener();
        }
        return listeners;
    }
}

