/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client;

import com.espertech.esper.client.ConfigurationDBRef;
import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.client.ConfigurationEventTypeAvro;
import com.espertech.esper.client.ConfigurationEventTypeLegacy;
import com.espertech.esper.client.ConfigurationEventTypeMap;
import com.espertech.esper.client.ConfigurationEventTypeObjectArray;
import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.ConfigurationMethodRef;
import com.espertech.esper.client.ConfigurationOperations;
import com.espertech.esper.client.ConfigurationParser;
import com.espertech.esper.client.ConfigurationPlugInAggregationFunction;
import com.espertech.esper.client.ConfigurationPlugInAggregationMultiFunction;
import com.espertech.esper.client.ConfigurationPlugInEventRepresentation;
import com.espertech.esper.client.ConfigurationPlugInEventType;
import com.espertech.esper.client.ConfigurationPlugInPatternObject;
import com.espertech.esper.client.ConfigurationPlugInSingleRowFunction;
import com.espertech.esper.client.ConfigurationPlugInView;
import com.espertech.esper.client.ConfigurationPlugInVirtualDataWindow;
import com.espertech.esper.client.ConfigurationPluginLoader;
import com.espertech.esper.client.ConfigurationRevisionEventType;
import com.espertech.esper.client.ConfigurationVariable;
import com.espertech.esper.client.ConfigurationVariantStream;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.Name;
import com.espertech.esper.event.EventTypeUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class Configuration
implements ConfigurationOperations,
ConfigurationInformation,
Serializable {
    private static final long serialVersionUID = -220881974438617882L;
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    public static final String ANNOTATION_IMPORT = Name.class.getPackage().getName() + ".*";
    protected static final String ESPER_DEFAULT_CONFIG = "esper.cfg.xml";
    protected Map<String, String> eventClasses;
    protected Map<String, ConfigurationEventTypeXMLDOM> eventTypesXMLDOM;
    protected Map<String, ConfigurationEventTypeAvro> eventTypesAvro;
    protected Map<String, ConfigurationEventTypeLegacy> eventTypesLegacy;
    protected Map<String, Properties> mapNames;
    protected Map<String, Map<String, Object>> nestableMapNames;
    protected Map<String, Map<String, Object>> nestableObjectArrayNames;
    protected Map<String, ConfigurationEventTypeMap> mapTypeConfigurations;
    protected Map<String, ConfigurationEventTypeObjectArray> objectArrayTypeConfigurations;
    protected List<String> imports;
    protected List<String> annotationImports;
    protected Map<String, ConfigurationDBRef> databaseReferences;
    protected String epServicesContextFactoryClassName;
    protected List<ConfigurationPlugInView> plugInViews;
    protected List<ConfigurationPlugInVirtualDataWindow> plugInVirtualDataWindows;
    protected List<ConfigurationPlugInPatternObject> plugInPatternObjects;
    protected List<ConfigurationPlugInAggregationFunction> plugInAggregationFunctions;
    protected List<ConfigurationPlugInAggregationMultiFunction> plugInAggregationMultiFunctions;
    protected List<ConfigurationPlugInSingleRowFunction> plugInSingleRowFunctions;
    protected List<ConfigurationPluginLoader> pluginLoaders;
    protected ConfigurationEngineDefaults engineDefaults;
    protected Set<String> eventTypeAutoNamePackages;
    protected Map<String, ConfigurationVariable> variables;
    protected Map<String, ConfigurationMethodRef> methodInvocationReferences;
    protected Map<URI, ConfigurationPlugInEventRepresentation> plugInEventRepresentation;
    protected Map<String, ConfigurationPlugInEventType> plugInEventTypes;
    protected URI[] plugInEventTypeResolutionURIs;
    protected Map<String, ConfigurationRevisionEventType> revisionEventTypes;
    protected Map<String, ConfigurationVariantStream> variantStreams;
    protected transient Map<String, Object> transientConfiguration;

    public Configuration() {
        this.reset();
    }

    public void setEPServicesContextFactoryClassName(String epServicesContextFactoryClassName) {
        this.epServicesContextFactoryClassName = epServicesContextFactoryClassName;
    }

    @Override
    public String getEPServicesContextFactoryClassName() {
        return this.epServicesContextFactoryClassName;
    }

    @Override
    public void addPlugInAggregationFunctionFactory(String functionName, String aggregationFactoryClassName) throws ConfigurationException {
        ConfigurationPlugInAggregationFunction entry = new ConfigurationPlugInAggregationFunction();
        entry.setName(functionName);
        entry.setFactoryClassName(aggregationFactoryClassName);
        this.plugInAggregationFunctions.add(entry);
    }

    @Override
    public void addPlugInAggregationMultiFunction(ConfigurationPlugInAggregationMultiFunction config) throws ConfigurationException {
        this.plugInAggregationMultiFunctions.add(config);
    }

    @Override
    public void addPlugInSingleRowFunction(ConfigurationPlugInSingleRowFunction singleRowFunction) {
        this.plugInSingleRowFunctions.add(singleRowFunction);
    }

    @Override
    public void addPlugInSingleRowFunction(String functionName, String className, String methodName) throws ConfigurationException {
        this.addPlugInSingleRowFunction(functionName, className, methodName, ConfigurationPlugInSingleRowFunction.ValueCache.DISABLED);
    }

    @Override
    public void addPlugInSingleRowFunction(String functionName, String className, String methodName, ConfigurationPlugInSingleRowFunction.ValueCache valueCache) throws ConfigurationException {
        this.addPlugInSingleRowFunction(functionName, className, methodName, valueCache, ConfigurationPlugInSingleRowFunction.FilterOptimizable.ENABLED);
    }

    @Override
    public void addPlugInSingleRowFunction(String functionName, String className, String methodName, ConfigurationPlugInSingleRowFunction.FilterOptimizable filterOptimizable) throws ConfigurationException {
        this.addPlugInSingleRowFunction(functionName, className, methodName, ConfigurationPlugInSingleRowFunction.ValueCache.DISABLED, filterOptimizable);
    }

    @Override
    public Map<String, Object> getTransientConfiguration() {
        return this.transientConfiguration;
    }

    public void setTransientConfiguration(Map<String, Object> transientConfiguration) {
        this.transientConfiguration = transientConfiguration;
    }

    public void addPlugInSingleRowFunction(String functionName, String className, String methodName, ConfigurationPlugInSingleRowFunction.ValueCache valueCache, ConfigurationPlugInSingleRowFunction.FilterOptimizable filterOptimizable) throws ConfigurationException {
        this.addPlugInSingleRowFunction(functionName, className, methodName, valueCache, filterOptimizable, false);
    }

    @Override
    public void addPlugInSingleRowFunction(String functionName, String className, String methodName, ConfigurationPlugInSingleRowFunction.ValueCache valueCache, ConfigurationPlugInSingleRowFunction.FilterOptimizable filterOptimizable, boolean rethrowExceptions) throws ConfigurationException {
        ConfigurationPlugInSingleRowFunction entry = new ConfigurationPlugInSingleRowFunction();
        entry.setFunctionClassName(className);
        entry.setFunctionMethodName(methodName);
        entry.setName(functionName);
        entry.setValueCache(valueCache);
        entry.setFilterOptimizable(filterOptimizable);
        entry.setRethrowExceptions(rethrowExceptions);
        this.addPlugInSingleRowFunction(entry);
    }

    @Override
    public boolean isEventTypeExists(String eventTypeName) {
        return this.eventClasses.containsKey(eventTypeName) || this.mapNames.containsKey(eventTypeName) || this.nestableMapNames.containsKey(eventTypeName) || this.nestableObjectArrayNames.containsKey(eventTypeName) || this.eventTypesXMLDOM.containsKey(eventTypeName) || this.eventTypesAvro.containsKey(eventTypeName);
    }

    @Override
    public void addEventType(String eventTypeName, String eventClassName) {
        this.eventClasses.put(eventTypeName, eventClassName);
    }

    @Override
    public void addEventType(String eventTypeName, Class eventClass) {
        this.addEventType(eventTypeName, eventClass.getName());
    }

    @Override
    public void addEventType(Class eventClass) {
        this.addEventType(eventClass.getSimpleName(), eventClass.getName());
    }

    @Override
    public void addEventType(String eventTypeName, Properties typeMap) {
        this.mapNames.put(eventTypeName, typeMap);
    }

    @Override
    public void addEventType(String eventTypeName, Map<String, Object> typeMap) {
        this.nestableMapNames.put(eventTypeName, new LinkedHashMap<String, Object>(typeMap));
    }

    @Override
    public void addEventType(String eventTypeName, Map<String, Object> typeMap, String[] superTypes) {
        this.nestableMapNames.put(eventTypeName, new LinkedHashMap<String, Object>(typeMap));
        if (superTypes != null) {
            for (int i = 0; i < superTypes.length; ++i) {
                this.addMapSuperType(eventTypeName, superTypes[i]);
            }
        }
    }

    @Override
    public void addEventType(String eventTypeName, Map<String, Object> typeMap, ConfigurationEventTypeMap mapConfig) throws ConfigurationException {
        this.nestableMapNames.put(eventTypeName, new LinkedHashMap<String, Object>(typeMap));
        this.mapTypeConfigurations.put(eventTypeName, mapConfig);
    }

    public void addMapSuperType(String mapeventTypeName, String mapSupertypeName) {
        ConfigurationEventTypeMap current = this.mapTypeConfigurations.get(mapeventTypeName);
        if (current == null) {
            current = new ConfigurationEventTypeMap();
            this.mapTypeConfigurations.put(mapeventTypeName, current);
        }
        Set<String> superTypes = current.getSuperTypes();
        superTypes.add(mapSupertypeName);
    }

    public void addObjectArraySuperType(String eventTypeName, String supertypeName) {
        Set<String> superTypes;
        ConfigurationEventTypeObjectArray current = this.objectArrayTypeConfigurations.get(eventTypeName);
        if (current == null) {
            current = new ConfigurationEventTypeObjectArray();
            this.objectArrayTypeConfigurations.put(eventTypeName, current);
        }
        if (!(superTypes = current.getSuperTypes()).isEmpty()) {
            throw new ConfigurationException("Object-array event types may not have multiple supertypes");
        }
        superTypes.add(supertypeName);
    }

    public void addMapConfiguration(String mapeventTypeName, ConfigurationEventTypeMap config) {
        this.mapTypeConfigurations.put(mapeventTypeName, config);
    }

    public void addObjectArrayConfiguration(String objectArrayeventTypeName, ConfigurationEventTypeObjectArray config) {
        this.objectArrayTypeConfigurations.put(objectArrayeventTypeName, config);
    }

    @Override
    public void addEventType(String eventTypeName, ConfigurationEventTypeXMLDOM xmlDOMEventTypeDesc) {
        this.eventTypesXMLDOM.put(eventTypeName, xmlDOMEventTypeDesc);
    }

    @Override
    public void addEventType(String eventTypeName, String[] propertyNames, Object[] propertyTypes) throws ConfigurationException {
        LinkedHashMap<String, Object> propertyTypesMap = EventTypeUtility.validateObjectArrayDef(propertyNames, propertyTypes);
        this.nestableObjectArrayNames.put(eventTypeName, propertyTypesMap);
    }

    @Override
    public void addEventType(String eventTypeName, String[] propertyNames, Object[] propertyTypes, ConfigurationEventTypeObjectArray config) throws ConfigurationException {
        LinkedHashMap<String, Object> propertyTypesMap = EventTypeUtility.validateObjectArrayDef(propertyNames, propertyTypes);
        this.nestableObjectArrayNames.put(eventTypeName, propertyTypesMap);
        this.objectArrayTypeConfigurations.put(eventTypeName, config);
        if (config.getSuperTypes() != null && config.getSuperTypes().size() > 1) {
            throw new ConfigurationException("Object-array event types only allow a single supertype");
        }
    }

    @Override
    public void addRevisionEventType(String revisioneventTypeName, ConfigurationRevisionEventType revisionEventTypeConfig) {
        this.revisionEventTypes.put(revisioneventTypeName, revisionEventTypeConfig);
    }

    public void addDatabaseReference(String name, ConfigurationDBRef configurationDBRef) {
        this.databaseReferences.put(name, configurationDBRef);
    }

    @Override
    public void addEventType(String eventTypeName, String eventClass, ConfigurationEventTypeLegacy legacyEventTypeDesc) {
        this.eventClasses.put(eventTypeName, eventClass);
        this.eventTypesLegacy.put(eventTypeName, legacyEventTypeDesc);
    }

    @Override
    public void addImport(String autoImport) {
        this.imports.add(autoImport);
    }

    @Override
    public void addImport(Class autoImport) {
        this.addImport(autoImport.getName());
    }

    @Override
    public void addAnnotationImport(String autoImport) {
        this.annotationImports.add(autoImport);
    }

    public void addAnnotationImport(Class autoImport) {
        this.addAnnotationImport(autoImport.getName());
    }

    public void removeImport(String name) {
        this.imports.remove(name);
    }

    public void addMethodRef(String className, ConfigurationMethodRef methodInvocationConfig) {
        this.methodInvocationReferences.put(className, methodInvocationConfig);
    }

    public void addMethodRef(Class clazz, ConfigurationMethodRef methodInvocationConfig) {
        this.methodInvocationReferences.put(clazz.getName(), methodInvocationConfig);
    }

    @Override
    public Map<String, String> getEventTypeNames() {
        return this.eventClasses;
    }

    @Override
    public Map<String, Properties> getEventTypesMapEvents() {
        return this.mapNames;
    }

    @Override
    public Map<String, Map<String, Object>> getEventTypesNestableMapEvents() {
        return this.nestableMapNames;
    }

    @Override
    public Map<String, Map<String, Object>> getEventTypesNestableObjectArrayEvents() {
        return this.nestableObjectArrayNames;
    }

    @Override
    public Map<String, ConfigurationEventTypeXMLDOM> getEventTypesXMLDOM() {
        return this.eventTypesXMLDOM;
    }

    @Override
    public Map<String, ConfigurationEventTypeAvro> getEventTypesAvro() {
        return this.eventTypesAvro;
    }

    @Override
    public Map<String, ConfigurationEventTypeLegacy> getEventTypesLegacy() {
        return this.eventTypesLegacy;
    }

    @Override
    public List<String> getImports() {
        return this.imports;
    }

    @Override
    public List<String> getAnnotationImports() {
        return this.annotationImports;
    }

    @Override
    public Map<String, ConfigurationDBRef> getDatabaseReferences() {
        return this.databaseReferences;
    }

    @Override
    public List<ConfigurationPlugInView> getPlugInViews() {
        return this.plugInViews;
    }

    @Override
    public Map<String, ConfigurationEventTypeObjectArray> getObjectArrayTypeConfigurations() {
        return this.objectArrayTypeConfigurations;
    }

    @Override
    public List<ConfigurationPlugInVirtualDataWindow> getPlugInVirtualDataWindows() {
        return this.plugInVirtualDataWindows;
    }

    @Override
    public List<ConfigurationPluginLoader> getPluginLoaders() {
        return this.pluginLoaders;
    }

    @Override
    public List<ConfigurationPlugInAggregationFunction> getPlugInAggregationFunctions() {
        return this.plugInAggregationFunctions;
    }

    @Override
    public List<ConfigurationPlugInAggregationMultiFunction> getPlugInAggregationMultiFunctions() {
        return this.plugInAggregationMultiFunctions;
    }

    @Override
    public List<ConfigurationPlugInSingleRowFunction> getPlugInSingleRowFunctions() {
        return this.plugInSingleRowFunctions;
    }

    @Override
    public List<ConfigurationPlugInPatternObject> getPlugInPatternObjects() {
        return this.plugInPatternObjects;
    }

    @Override
    public Map<String, ConfigurationVariable> getVariables() {
        return this.variables;
    }

    @Override
    public Map<String, ConfigurationMethodRef> getMethodInvocationReferences() {
        return this.methodInvocationReferences;
    }

    @Override
    public Map<String, ConfigurationRevisionEventType> getRevisionEventTypes() {
        return this.revisionEventTypes;
    }

    @Override
    public Map<String, ConfigurationEventTypeMap> getMapTypeConfigurations() {
        return this.mapTypeConfigurations;
    }

    public void addPluginLoader(String loaderName, String className, Properties configuration) {
        this.addPluginLoader(loaderName, className, configuration, null);
    }

    public void addPluginLoader(String loaderName, String className) {
        this.addPluginLoader(loaderName, className, null, null);
    }

    public void addPluginLoader(String loaderName, String className, Properties configuration, String configurationXML) {
        ConfigurationPluginLoader pluginLoader = new ConfigurationPluginLoader();
        pluginLoader.setLoaderName(loaderName);
        pluginLoader.setClassName(className);
        pluginLoader.setConfigProperties(configuration);
        pluginLoader.setConfigurationXML(configurationXML);
        this.pluginLoaders.add(pluginLoader);
    }

    @Override
    public void addPlugInView(String namespace, String name, String viewFactoryClass) {
        ConfigurationPlugInView configurationPlugInView = new ConfigurationPlugInView();
        configurationPlugInView.setNamespace(namespace);
        configurationPlugInView.setName(name);
        configurationPlugInView.setFactoryClassName(viewFactoryClass);
        this.plugInViews.add(configurationPlugInView);
    }

    public void addPlugInVirtualDataWindow(String namespace, String name, String factoryClass) {
        this.addPlugInVirtualDataWindow(namespace, name, factoryClass, null);
    }

    public void addPlugInVirtualDataWindow(String namespace, String name, String factoryClass, Serializable customConfigurationObject) {
        ConfigurationPlugInVirtualDataWindow configurationPlugInVirtualDataWindow = new ConfigurationPlugInVirtualDataWindow();
        configurationPlugInVirtualDataWindow.setNamespace(namespace);
        configurationPlugInVirtualDataWindow.setName(name);
        configurationPlugInVirtualDataWindow.setFactoryClassName(factoryClass);
        configurationPlugInVirtualDataWindow.setConfig(customConfigurationObject);
        this.plugInVirtualDataWindows.add(configurationPlugInVirtualDataWindow);
    }

    public void addPlugInPatternObserver(String namespace, String name, String observerFactoryClass) {
        ConfigurationPlugInPatternObject entry = new ConfigurationPlugInPatternObject();
        entry.setNamespace(namespace);
        entry.setName(name);
        entry.setFactoryClassName(observerFactoryClass);
        entry.setPatternObjectType(ConfigurationPlugInPatternObject.PatternObjectType.OBSERVER);
        this.plugInPatternObjects.add(entry);
    }

    public void addPlugInPatternGuard(String namespace, String name, String guardFactoryClass) {
        ConfigurationPlugInPatternObject entry = new ConfigurationPlugInPatternObject();
        entry.setNamespace(namespace);
        entry.setName(name);
        entry.setFactoryClassName(guardFactoryClass);
        entry.setPatternObjectType(ConfigurationPlugInPatternObject.PatternObjectType.GUARD);
        this.plugInPatternObjects.add(entry);
    }

    @Override
    public void addEventTypeAutoName(String packageName) {
        this.eventTypeAutoNamePackages.add(packageName);
    }

    @Override
    public void addVariable(String variableName, Class type, Object initializationValue) {
        this.addVariable(variableName, type.getName(), initializationValue, false);
    }

    public void addVariable(String variableName, Class type, Object initializationValue, boolean constant) {
        this.addVariable(variableName, type.getName(), initializationValue, constant);
    }

    @Override
    public void addVariable(String variableName, String type, Object initializationValue) throws ConfigurationException {
        this.addVariable(variableName, type, initializationValue, false);
    }

    @Override
    public void addVariable(String variableName, String type, Object initializationValue, boolean constant) throws ConfigurationException {
        ConfigurationVariable configVar = new ConfigurationVariable();
        configVar.setType(type);
        configVar.setInitializationValue(initializationValue);
        configVar.setConstant(constant);
        this.variables.put(variableName, configVar);
    }

    public void addPlugInEventRepresentation(URI eventRepresentationRootURI, String eventRepresentationClassName, Serializable initializer) {
        ConfigurationPlugInEventRepresentation config = new ConfigurationPlugInEventRepresentation();
        config.setEventRepresentationClassName(eventRepresentationClassName);
        config.setInitializer(initializer);
        this.plugInEventRepresentation.put(eventRepresentationRootURI, config);
    }

    public void addPlugInEventRepresentation(URI eventRepresentationRootURI, Class eventRepresentationClass, Serializable initializer) {
        this.addPlugInEventRepresentation(eventRepresentationRootURI, eventRepresentationClass.getName(), initializer);
    }

    @Override
    public void addPlugInEventType(String eventTypeName, URI[] resolutionURIs, Serializable initializer) {
        ConfigurationPlugInEventType config = new ConfigurationPlugInEventType();
        config.setEventRepresentationResolutionURIs(resolutionURIs);
        config.setInitializer(initializer);
        this.plugInEventTypes.put(eventTypeName, config);
    }

    @Override
    public void setPlugInEventTypeResolutionURIs(URI[] urisToResolveName) {
        this.plugInEventTypeResolutionURIs = urisToResolveName;
    }

    @Override
    public URI[] getPlugInEventTypeResolutionURIs() {
        return this.plugInEventTypeResolutionURIs;
    }

    @Override
    public Map<URI, ConfigurationPlugInEventRepresentation> getPlugInEventRepresentation() {
        return this.plugInEventRepresentation;
    }

    @Override
    public Map<String, ConfigurationPlugInEventType> getPlugInEventTypes() {
        return this.plugInEventTypes;
    }

    @Override
    public Set<String> getEventTypeAutoNamePackages() {
        return this.eventTypeAutoNamePackages;
    }

    @Override
    public ConfigurationEngineDefaults getEngineDefaults() {
        return this.engineDefaults;
    }

    @Override
    public void addVariantStream(String varianteventTypeName, ConfigurationVariantStream variantStreamConfig) {
        this.variantStreams.put(varianteventTypeName, variantStreamConfig);
    }

    @Override
    public Map<String, ConfigurationVariantStream> getVariantStreams() {
        return this.variantStreams;
    }

    @Override
    public void updateMapEventType(String mapeventTypeName, Map<String, Object> typeMap) throws ConfigurationException {
        throw new UnsupportedOperationException("Map type update is only available in runtime configuration");
    }

    @Override
    public void updateObjectArrayEventType(String myEvent, String[] namesNew, Object[] typesNew) {
        throw new UnsupportedOperationException("Object-array type update is only available in runtime configuration");
    }

    @Override
    public void replaceXMLEventType(String xmlEventTypeName, ConfigurationEventTypeXMLDOM config) throws ConfigurationException {
        throw new UnsupportedOperationException("XML type update is only available in runtime configuration");
    }

    @Override
    public Set<String> getEventTypeNameUsedBy(String name) {
        throw new UnsupportedOperationException("Get event type by name is only available in runtime configuration");
    }

    @Override
    public boolean isVariantStreamExists(String name) {
        return this.variantStreams.containsKey(name);
    }

    @Override
    public void setMetricsReportingInterval(String stmtGroupName, long newInterval) {
        this.getEngineDefaults().getMetricsReporting().setStatementGroupInterval(stmtGroupName, newInterval);
    }

    @Override
    public void setMetricsReportingStmtEnabled(String statementName) {
        throw new UnsupportedOperationException("Statement metric reporting can only be enabled or disabled at runtime");
    }

    @Override
    public void setMetricsReportingStmtDisabled(String statementName) {
        throw new UnsupportedOperationException("Statement metric reporting can only be enabled or disabled at runtime");
    }

    @Override
    public EventType getEventType(String eventTypeName) {
        throw new UnsupportedOperationException("Obtaining an event type by name is only available at runtime");
    }

    @Override
    public EventType[] getEventTypes() {
        throw new UnsupportedOperationException("Obtaining event types is only available at runtime");
    }

    @Override
    public void setMetricsReportingEnabled() {
        this.getEngineDefaults().getMetricsReporting().setEnableMetricsReporting(true);
    }

    @Override
    public void setMetricsReportingDisabled() {
        this.getEngineDefaults().getMetricsReporting().setEnableMetricsReporting(false);
    }

    @Override
    public void setPatternMaxSubexpressions(Long maxSubexpressions) {
        this.getEngineDefaults().getPatterns().setMaxSubexpressions(maxSubexpressions);
    }

    @Override
    public void setMatchRecognizeMaxStates(Long maxStates) {
        this.getEngineDefaults().getMatchRecognize().setMaxStates(maxStates);
    }

    public Configuration configure() throws EPException {
        this.configure("/esper.cfg.xml");
        return this;
    }

    public Configuration configure(String resource) throws EPException {
        if (log.isDebugEnabled()) {
            log.debug("Configuring from resource: " + resource);
        }
        InputStream stream = Configuration.getConfigurationInputStream(resource);
        ConfigurationParser.doConfigure(this, stream, resource);
        return this;
    }

    protected static InputStream getConfigurationInputStream(String resource) throws EPException {
        return Configuration.getResourceAsStream(resource);
    }

    public Configuration configure(URL url) throws EPException {
        if (log.isDebugEnabled()) {
            log.debug("configuring from url: " + url.toString());
        }
        try {
            ConfigurationParser.doConfigure(this, url.openStream(), url.toString());
            return this;
        }
        catch (IOException ioe) {
            throw new EPException("could not configure from URL: " + url, ioe);
        }
    }

    public Configuration configure(File configFile) throws EPException {
        if (log.isDebugEnabled()) {
            log.debug("configuring from file: " + configFile.getName());
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(configFile);
            ConfigurationParser.doConfigure(this, inputStream, configFile.toString());
        }
        catch (FileNotFoundException fnfe) {
            throw new EPException("could not find file: " + configFile, fnfe);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.debug("Error closing input stream", (Throwable)e);
                }
            }
        }
        return this;
    }

    @Override
    public boolean removeEventType(String eventTypeName, boolean force) throws ConfigurationException {
        this.eventClasses.remove(eventTypeName);
        this.eventTypesXMLDOM.remove(eventTypeName);
        this.eventTypesAvro.remove(eventTypeName);
        this.eventTypesLegacy.remove(eventTypeName);
        this.mapNames.remove(eventTypeName);
        this.nestableMapNames.remove(eventTypeName);
        this.mapTypeConfigurations.remove(eventTypeName);
        this.plugInEventTypes.remove(eventTypeName);
        this.revisionEventTypes.remove(eventTypeName);
        this.variantStreams.remove(eventTypeName);
        return true;
    }

    @Override
    public Set<String> getVariableNameUsedBy(String variableName) {
        throw new UnsupportedOperationException("Get variable use information is only available in runtime configuration");
    }

    @Override
    public boolean removeVariable(String name, boolean force) throws ConfigurationException {
        return this.variables.remove(name) != null;
    }

    @Override
    public void addEventTypeAvro(String eventTypeName, ConfigurationEventTypeAvro avro) {
        this.eventTypesAvro.put(eventTypeName, avro);
    }

    public Configuration configure(Document document) throws EPException {
        if (log.isDebugEnabled()) {
            log.debug("configuring from XML document");
        }
        ConfigurationParser.doConfigure(this, document);
        return this;
    }

    protected static InputStream getResourceAsStream(String resource) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = Configuration.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = Configuration.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new EPException(resource + " not found");
        }
        return stream;
    }

    protected void reset() {
        this.eventClasses = new LinkedHashMap<String, String>();
        this.mapNames = new LinkedHashMap<String, Properties>();
        this.nestableMapNames = new LinkedHashMap<String, Map<String, Object>>();
        this.nestableObjectArrayNames = new LinkedHashMap<String, Map<String, Object>>();
        this.eventTypesXMLDOM = new LinkedHashMap<String, ConfigurationEventTypeXMLDOM>();
        this.eventTypesAvro = new LinkedHashMap<String, ConfigurationEventTypeAvro>();
        this.eventTypesLegacy = new LinkedHashMap<String, ConfigurationEventTypeLegacy>();
        this.databaseReferences = new HashMap<String, ConfigurationDBRef>();
        this.imports = new ArrayList<String>();
        this.annotationImports = new ArrayList<String>(2);
        this.addDefaultImports();
        this.plugInViews = new ArrayList<ConfigurationPlugInView>();
        this.plugInVirtualDataWindows = new ArrayList<ConfigurationPlugInVirtualDataWindow>();
        this.pluginLoaders = new ArrayList<ConfigurationPluginLoader>();
        this.plugInAggregationFunctions = new ArrayList<ConfigurationPlugInAggregationFunction>();
        this.plugInAggregationMultiFunctions = new ArrayList<ConfigurationPlugInAggregationMultiFunction>();
        this.plugInSingleRowFunctions = new ArrayList<ConfigurationPlugInSingleRowFunction>();
        this.plugInPatternObjects = new ArrayList<ConfigurationPlugInPatternObject>();
        this.engineDefaults = new ConfigurationEngineDefaults();
        this.eventTypeAutoNamePackages = new LinkedHashSet<String>();
        this.variables = new HashMap<String, ConfigurationVariable>();
        this.methodInvocationReferences = new HashMap<String, ConfigurationMethodRef>();
        this.plugInEventRepresentation = new LinkedHashMap<URI, ConfigurationPlugInEventRepresentation>();
        this.plugInEventTypes = new LinkedHashMap<String, ConfigurationPlugInEventType>();
        this.revisionEventTypes = new LinkedHashMap<String, ConfigurationRevisionEventType>();
        this.variantStreams = new HashMap<String, ConfigurationVariantStream>();
        this.mapTypeConfigurations = new HashMap<String, ConfigurationEventTypeMap>();
        this.objectArrayTypeConfigurations = new HashMap<String, ConfigurationEventTypeObjectArray>();
        this.transientConfiguration = new HashMap<String, Object>();
    }

    private void addDefaultImports() {
        this.imports.add("java.lang.*");
        this.imports.add("java.math.*");
        this.imports.add("java.text.*");
        this.imports.add("java.util.*");
        this.imports.add(ANNOTATION_IMPORT);
        this.imports.add("com.espertech.esper.dataflow.ops.*");
    }

    public static enum PropertyResolutionStyle {
        CASE_SENSITIVE,
        CASE_INSENSITIVE,
        DISTINCT_CASE_INSENSITIVE;


        public static PropertyResolutionStyle getDefault() {
            return CASE_SENSITIVE;
        }
    }
}

