/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.benchmarks.io;

import com.esotericsoftware.kryo.benchmarks.io.InputOutputState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;

@BenchmarkMode(value={Mode.SingleShotTime})
@Measurement(batchSize=150000000)
public class VariableEncodingBenchmark {
    @Benchmark
    public void writeInt(InputOutputState state) {
        state.reset();
        state.output.writeInt(1234);
    }

    @Benchmark
    public void readInt(ReadInt state) {
        state.reset();
        state.input.readInt();
    }

    @Benchmark
    public void writeVarInt(InputOutputState state) {
        state.reset();
        state.output.writeVarInt(1234, true);
    }

    @Benchmark
    public int readVarInt(ReadVarInt state) {
        state.reset();
        return state.input.readVarInt(true);
    }

    @Benchmark
    public void writeLong(InputOutputState state) {
        state.reset();
        state.output.writeLong(12341234L);
    }

    @Benchmark
    public long readLong(ReadLong state) {
        state.reset();
        return state.input.readLong();
    }

    @Benchmark
    public void writeVarLong(InputOutputState state) {
        state.reset();
        state.output.writeVarLong(12341234L, true);
    }

    @Benchmark
    public long readVarLong(ReadLong state) {
        state.reset();
        return state.input.readVarLong(true);
    }

    @State(value=Scope.Thread)
    public static class ReadInt
    extends InputOutputState {
        public ReadInt() {
            new VariableEncodingBenchmark().writeInt(this);
        }
    }

    @State(value=Scope.Thread)
    public static class ReadVarInt
    extends InputOutputState {
        public ReadVarInt() {
            new VariableEncodingBenchmark().readVarInt(this);
        }
    }

    @State(value=Scope.Thread)
    public static class ReadLong
    extends InputOutputState {
        public ReadLong() {
            new VariableEncodingBenchmark().writeLong(this);
        }
    }

    @State(value=Scope.Thread)
    public static class ReadVarLong
    extends InputOutputState {
        public ReadVarLong() {
            new VariableEncodingBenchmark().writeVarLong(this);
        }
    }
}

