/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.benchmarks.data;

import com.esotericsoftware.kryo.serializers.TaggedFieldSerializer;
import java.util.Arrays;

public class Sample {
    @TaggedFieldSerializer.Tag(value=0)
    public int intValue;
    @TaggedFieldSerializer.Tag(value=1)
    public long longValue;
    @TaggedFieldSerializer.Tag(value=2)
    public float floatValue;
    @TaggedFieldSerializer.Tag(value=3)
    public double doubleValue;
    @TaggedFieldSerializer.Tag(value=4)
    public short shortValue;
    @TaggedFieldSerializer.Tag(value=5)
    public char charValue;
    @TaggedFieldSerializer.Tag(value=6)
    public boolean booleanValue;
    @TaggedFieldSerializer.Tag(value=7)
    public Integer IntValue;
    @TaggedFieldSerializer.Tag(value=8)
    public Long LongValue;
    @TaggedFieldSerializer.Tag(value=9)
    public Float FloatValue;
    @TaggedFieldSerializer.Tag(value=10)
    public Double DoubleValue;
    @TaggedFieldSerializer.Tag(value=11)
    public Short ShortValue;
    @TaggedFieldSerializer.Tag(value=12)
    public Character CharValue;
    @TaggedFieldSerializer.Tag(value=13)
    public Boolean BooleanValue;
    @TaggedFieldSerializer.Tag(value=14)
    public int[] intArray;
    @TaggedFieldSerializer.Tag(value=15)
    public long[] longArray;
    @TaggedFieldSerializer.Tag(value=16)
    public float[] floatArray;
    @TaggedFieldSerializer.Tag(value=17)
    public double[] doubleArray;
    @TaggedFieldSerializer.Tag(value=18)
    public short[] shortArray;
    @TaggedFieldSerializer.Tag(value=19)
    public char[] charArray;
    @TaggedFieldSerializer.Tag(value=20)
    public boolean[] booleanArray;
    @TaggedFieldSerializer.Tag(value=21)
    public String string;
    @TaggedFieldSerializer.Tag(value=22)
    public Sample sample;

    public Sample populate(boolean circularReference) {
        this.intValue = 123;
        this.longValue = 1230000L;
        this.floatValue = 12.345f;
        this.doubleValue = 1.234567;
        this.shortValue = (short)12345;
        this.charValue = (char)33;
        this.booleanValue = true;
        this.IntValue = 321;
        this.LongValue = 3210000L;
        this.FloatValue = Float.valueOf(54.321f);
        this.DoubleValue = 7.654321;
        this.ShortValue = 32100;
        this.CharValue = Character.valueOf('$');
        this.BooleanValue = Boolean.FALSE;
        this.intArray = new int[]{-1234, -123, -12, -1, 0, 1, 12, 123, 1234};
        this.longArray = new long[]{-123400L, -12300L, -1200L, -100L, 0L, 100L, 1200L, 12300L, 123400L};
        this.floatArray = new float[]{-12.34f, -12.3f, -12.0f, -1.0f, 0.0f, 1.0f, 12.0f, 12.3f, 12.34f};
        this.doubleArray = new double[]{-1.234, -1.23, -12.0, -1.0, 0.0, 1.0, 12.0, 1.23, 1.234};
        this.shortArray = new short[]{-1234, -123, -12, -1, 0, 1, 12, 123, 1234};
        this.charArray = "asdfASDF".toCharArray();
        this.booleanArray = new boolean[]{true, false, false, true};
        this.string = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        if (circularReference) {
            this.sample = this;
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.BooleanValue == null ? 0 : this.BooleanValue.hashCode());
        result = 31 * result + (this.CharValue == null ? 0 : this.CharValue.hashCode());
        result = 31 * result + (this.DoubleValue == null ? 0 : this.DoubleValue.hashCode());
        result = 31 * result + (this.FloatValue == null ? 0 : this.FloatValue.hashCode());
        result = 31 * result + (this.IntValue == null ? 0 : this.IntValue.hashCode());
        result = 31 * result + (this.LongValue == null ? 0 : this.LongValue.hashCode());
        result = 31 * result + (this.ShortValue == null ? 0 : this.ShortValue.hashCode());
        result = 31 * result + Arrays.hashCode(this.booleanArray);
        result = 31 * result + (this.booleanValue ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.charArray);
        result = 31 * result + this.charValue;
        result = 31 * result + Arrays.hashCode(this.doubleArray);
        long temp = Double.doubleToLongBits(this.doubleValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + Arrays.hashCode(this.floatArray);
        result = 31 * result + Float.floatToIntBits(this.floatValue);
        result = 31 * result + Arrays.hashCode(this.intArray);
        result = 31 * result + this.intValue;
        result = 31 * result + Arrays.hashCode(this.longArray);
        result = 31 * result + (int)(this.longValue ^ this.longValue >>> 32);
        result = 31 * result + (this.sample == null ? 0 : this.sample.hashCode());
        result = 31 * result + Arrays.hashCode(this.shortArray);
        result = 31 * result + this.shortValue;
        result = 31 * result + (this.string == null ? 0 : this.string.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Sample other = (Sample)object;
        if (this.BooleanValue == null ? other.BooleanValue != null : !this.BooleanValue.equals(other.BooleanValue)) {
            return false;
        }
        if (this.CharValue == null ? other.CharValue != null : !this.CharValue.equals(other.CharValue)) {
            return false;
        }
        if (this.DoubleValue == null ? other.DoubleValue != null : !this.DoubleValue.equals(other.DoubleValue)) {
            return false;
        }
        if (this.FloatValue == null ? other.FloatValue != null : !this.FloatValue.equals(other.FloatValue)) {
            return false;
        }
        if (this.IntValue == null ? other.IntValue != null : !this.IntValue.equals(other.IntValue)) {
            return false;
        }
        if (this.LongValue == null ? other.LongValue != null : !this.LongValue.equals(other.LongValue)) {
            return false;
        }
        if (this.ShortValue == null ? other.ShortValue != null : !this.ShortValue.equals(other.ShortValue)) {
            return false;
        }
        if (!Arrays.equals(this.booleanArray, other.booleanArray)) {
            return false;
        }
        if (this.booleanValue != other.booleanValue) {
            return false;
        }
        if (!Arrays.equals(this.charArray, other.charArray)) {
            return false;
        }
        if (this.charValue != other.charValue) {
            return false;
        }
        if (!Arrays.equals(this.doubleArray, other.doubleArray)) {
            return false;
        }
        if (Double.doubleToLongBits(this.doubleValue) != Double.doubleToLongBits(other.doubleValue)) {
            return false;
        }
        if (!Arrays.equals(this.floatArray, other.floatArray)) {
            return false;
        }
        if (Float.floatToIntBits(this.floatValue) != Float.floatToIntBits(other.floatValue)) {
            return false;
        }
        if (!Arrays.equals(this.intArray, other.intArray)) {
            return false;
        }
        if (this.intValue != other.intValue) {
            return false;
        }
        if (!Arrays.equals(this.longArray, other.longArray)) {
            return false;
        }
        if (this.longValue != other.longValue) {
            return false;
        }
        if (this.sample == null ? other.sample != null : this.sample != this && !this.sample.equals(other.sample)) {
            return false;
        }
        if (!Arrays.equals(this.shortArray, other.shortArray)) {
            return false;
        }
        if (this.shortValue != other.shortValue) {
            return false;
        }
        return !(this.string == null ? other.string != null : !this.string.equals(other.string));
    }
}

