/*
 * Decompiled with CFR 0.152.
 */
package com.epam.parso.impl;

import com.epam.parso.Column;
import com.epam.parso.SasFileProperties;
import com.epam.parso.impl.BinDecompressor;
import com.epam.parso.impl.CharDecompressor;
import com.epam.parso.impl.Decompressor;
import com.epam.parso.impl.SasFileConstants;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SasFileParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SasFileParser.class);
    private static final Map<Long, SubheaderIndexes> SUBHEADER_SIGNATURE_TO_INDEX;
    private static final Map<String, Decompressor> LITERALS_TO_DECOMPRESSOR;
    private final DataInputStream sasFileStream;
    private final Boolean byteOutput;
    private final List<SubheaderPointer> currentPageDataSubheaderPointers = new ArrayList<SubheaderPointer>();
    private final SasFileProperties sasFileProperties = new SasFileProperties();
    private final List<byte[]> columnsNamesBytes = new ArrayList<byte[]>();
    private final List<String> columnsNamesList = new ArrayList<String>();
    private final List<Class<?>> columnsTypesList = new ArrayList();
    private final List<Long> columnsDataOffset = new ArrayList<Long>();
    private final List<Integer> columnsDataLength = new ArrayList<Integer>();
    private final List<Column> columns = new ArrayList<Column>();
    private final Map<SubheaderIndexes, ProcessingSubheader> subheaderIndexToClass;
    private String encoding = "US-ASCII";
    private byte[] cachedPage;
    private int currentPageType;
    private int currentPageBlockCount;
    private int currentPageSubheadersCount;
    private int currentFilePosition;
    private int currentColumnNumber;
    private int currentRowInFileIndex;
    private int currentRowOnPageIndex;
    private Object[] currentRow;
    private boolean eof;

    private SasFileParser(Builder builder) {
        this.sasFileStream = new DataInputStream(builder.sasFileStream);
        this.encoding = builder.encoding;
        this.byteOutput = builder.byteOutput;
        HashMap<SubheaderIndexes, ProcessingSubheader> tmpMap = new HashMap<SubheaderIndexes, ProcessingSubheader>();
        tmpMap.put(SubheaderIndexes.ROW_SIZE_SUBHEADER_INDEX, new RowSizeSubheader());
        tmpMap.put(SubheaderIndexes.COLUMN_SIZE_SUBHEADER_INDEX, new ColumnSizeSubheader());
        tmpMap.put(SubheaderIndexes.SUBHEADER_COUNTS_SUBHEADER_INDEX, new SubheaderCountsSubheader());
        tmpMap.put(SubheaderIndexes.COLUMN_TEXT_SUBHEADER_INDEX, new ColumnTextSubheader());
        tmpMap.put(SubheaderIndexes.COLUMN_NAME_SUBHEADER_INDEX, new ColumnNameSubheader());
        tmpMap.put(SubheaderIndexes.COLUMN_ATTRIBUTES_SUBHEADER_INDEX, new ColumnAttributesSubheader());
        tmpMap.put(SubheaderIndexes.FORMAT_AND_LABEL_SUBHEADER_INDEX, new FormatAndLabelSubheader());
        tmpMap.put(SubheaderIndexes.COLUMN_LIST_SUBHEADER_INDEX, new ColumnListSubheader());
        tmpMap.put(SubheaderIndexes.DATA_SUBHEADER_INDEX, new DataSubheader());
        this.subheaderIndexToClass = Collections.unmodifiableMap(tmpMap);
        try {
            this.getMetadataFromSasFile();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void getMetadataFromSasFile() throws IOException {
        boolean endOfMetadata = false;
        this.processSasFileHeader();
        this.cachedPage = new byte[this.sasFileProperties.getPageLength()];
        while (!endOfMetadata) {
            try {
                this.sasFileStream.readFully(this.cachedPage, 0, this.sasFileProperties.getPageLength());
            }
            catch (EOFException ex) {
                this.eof = true;
                break;
            }
            endOfMetadata = this.processSasFilePageMeta();
        }
    }

    private void processSasFileHeader() throws IOException {
        int align1 = 0;
        int align2 = 0;
        Long[] offsetForAlign = new Long[]{32L, 35L};
        Integer[] lengthForAlign = new Integer[]{1, 1};
        List<byte[]> varsForAlign = this.getBytesFromFile(offsetForAlign, lengthForAlign);
        if (varsForAlign.get(0)[0] == 51) {
            align2 = 4;
            this.sasFileProperties.setU64(true);
        }
        if (varsForAlign.get(1)[0] == 51) {
            align1 = 4;
        }
        int totalAlign = align1 + align2;
        Long[] offset = new Long[]{37L, 70L, 92L, 156L, 164L + (long)align1, 172L + (long)align1, 196L + (long)align1, 200L + (long)align1, 204L + (long)align1, 216L + (long)totalAlign, 224L + (long)totalAlign, 240L + (long)totalAlign, 256L + (long)totalAlign, 272L + (long)totalAlign};
        Integer[] length = new Integer[]{1, 1, 64, 8, 8, 8, 4, 4, 4 + align2, 8, 16, 16, 16, 16};
        List<byte[]> vars = this.getBytesFromFile(offset, length);
        this.sasFileProperties.setEndianness(vars.get(0)[0]);
        String encoding = SasFileConstants.SAS_CHARACTER_ENCODINGS.get(vars.get(1)[0]);
        if (encoding != null) {
            this.encoding = encoding;
        }
        this.sasFileProperties.setEncoding(this.encoding);
        this.sasFileProperties.setName(this.bytesToString(vars.get(2)).trim());
        this.sasFileProperties.setFileType(this.bytesToString(vars.get(3)).trim());
        this.sasFileProperties.setDateCreated(this.bytesToDateTime(vars.get(4)));
        this.sasFileProperties.setDateModified(this.bytesToDateTime(vars.get(5)));
        this.sasFileProperties.setHeaderLength(this.bytesToInt(vars.get(6)));
        this.sasFileProperties.setPageLength(this.bytesToInt(vars.get(7)));
        this.sasFileProperties.setPageCount(this.bytesToLong(vars.get(8)));
        this.sasFileProperties.setSasRelease(this.bytesToString(vars.get(9)).trim());
        this.sasFileProperties.setServerType(this.bytesToString(vars.get(10)).trim());
        this.sasFileProperties.setOsType(this.bytesToString(vars.get(11)).trim());
        if (vars.get(13)[0] != 0) {
            this.sasFileProperties.setOsName(this.bytesToString(vars.get(13)).trim());
        } else {
            this.sasFileProperties.setOsName(this.bytesToString(vars.get(12)).trim());
        }
        if (this.sasFileStream != null) {
            int bytesLeft = this.sasFileProperties.getHeaderLength() - this.currentFilePosition;
            for (long actuallySkipped = 0L; actuallySkipped < (long)bytesLeft; actuallySkipped += this.sasFileStream.skip((long)bytesLeft - actuallySkipped)) {
            }
            this.currentFilePosition = 0;
        }
    }

    private boolean processSasFilePageMeta() throws IOException {
        int bitOffset = this.sasFileProperties.isU64() ? 32 : 16;
        this.readPageHeader();
        ArrayList<SubheaderPointer> subheaderPointers = new ArrayList<SubheaderPointer>();
        if (this.currentPageType == 0 || this.currentPageType == 512) {
            this.processPageMetadata(bitOffset, subheaderPointers);
        }
        return this.currentPageType == 256 || this.currentPageType == 512 || this.currentPageDataSubheaderPointers.size() != 0;
    }

    private void processPageMetadata(int bitOffset, List<SubheaderPointer> subheaderPointers) throws IOException {
        subheaderPointers.clear();
        for (int subheaderPointerIndex = 0; subheaderPointerIndex < this.currentPageSubheadersCount; ++subheaderPointerIndex) {
            SubheaderPointer currentSubheaderPointer = this.processSubheaderPointers((long)bitOffset + 8L, subheaderPointerIndex);
            subheaderPointers.add(currentSubheaderPointer);
            if (currentSubheaderPointer.compression == 1) continue;
            long subheaderSignature = this.readSubheaderSignature(currentSubheaderPointer.offset);
            SubheaderIndexes subheaderIndex = this.chooseSubheaderClass(subheaderSignature, currentSubheaderPointer.compression, currentSubheaderPointer.type);
            if (subheaderIndex != null) {
                if (subheaderIndex != SubheaderIndexes.DATA_SUBHEADER_INDEX) {
                    LOGGER.debug("Subheader process function name: {}", (Object)subheaderIndex);
                    this.subheaderIndexToClass.get((Object)subheaderIndex).processSubheader(subheaderPointers.get(subheaderPointerIndex).offset, subheaderPointers.get(subheaderPointerIndex).length);
                    continue;
                }
                this.currentPageDataSubheaderPointers.add(subheaderPointers.get(subheaderPointerIndex));
                continue;
            }
            LOGGER.debug("Unknown subheader signature");
        }
    }

    private long readSubheaderSignature(Long subheaderPointerOffset) throws IOException {
        int intOrLongLength = this.sasFileProperties.isU64() ? 8 : 4;
        Long[] subheaderOffsetMass = new Long[]{subheaderPointerOffset};
        Integer[] subheaderLengthMass = new Integer[]{intOrLongLength};
        List<byte[]> subheaderSignatureMass = this.getBytesFromFile(subheaderOffsetMass, subheaderLengthMass);
        return this.bytesToLong(subheaderSignatureMass.get(0));
    }

    private SubheaderIndexes chooseSubheaderClass(long subheaderSignature, int compression, int type) {
        SubheaderIndexes subheaderIndex = SUBHEADER_SIGNATURE_TO_INDEX.get(subheaderSignature);
        if (this.sasFileProperties.isCompressed() && subheaderIndex == null && (compression == 4 || compression == 0) && type == 1) {
            subheaderIndex = SubheaderIndexes.DATA_SUBHEADER_INDEX;
        }
        return subheaderIndex;
    }

    private SubheaderPointer processSubheaderPointers(long subheaderPointerOffset, int subheaderPointerIndex) throws IOException {
        int intOrLongLength = this.sasFileProperties.isU64() ? 8 : 4;
        int subheaderPointerLength = this.sasFileProperties.isU64() ? 24 : 12;
        long totalOffset = subheaderPointerOffset + (long)subheaderPointerLength * (long)subheaderPointerIndex;
        Long[] offset = new Long[]{totalOffset, totalOffset + (long)intOrLongLength, totalOffset + 2L * (long)intOrLongLength, totalOffset + 2L * (long)intOrLongLength + 1L};
        Integer[] length = new Integer[]{intOrLongLength, intOrLongLength, 1, 1};
        List<byte[]> vars = this.getBytesFromFile(offset, length);
        long subheaderOffset = this.bytesToLong(vars.get(0));
        long subheaderLength = this.bytesToLong(vars.get(1));
        byte subheaderCompression = vars.get(2)[0];
        byte subheaderType = vars.get(3)[0];
        return new SubheaderPointer(subheaderOffset, subheaderLength, subheaderCompression, subheaderType);
    }

    private String findCompressionLiteral(String src) {
        if (src == null) {
            LOGGER.warn("Null provided as the file compression literal, assuming no compression");
            return null;
        }
        for (String supported : LITERALS_TO_DECOMPRESSOR.keySet()) {
            if (!src.contains(supported)) continue;
            return supported;
        }
        LOGGER.debug("No supported compression literal found, assuming no compression");
        return null;
    }

    Object[] readNext() throws IOException {
        if ((long)this.currentRowInFileIndex++ >= this.sasFileProperties.getRowCount() || this.eof) {
            return null;
        }
        int bitOffset = this.sasFileProperties.isU64() ? 32 : 16;
        switch (this.currentPageType) {
            case 0: {
                SubheaderPointer currentSubheaderPointer = this.currentPageDataSubheaderPointers.get(this.currentRowOnPageIndex++);
                this.subheaderIndexToClass.get((Object)SubheaderIndexes.DATA_SUBHEADER_INDEX).processSubheader(currentSubheaderPointer.offset, currentSubheaderPointer.length);
                if (this.currentRowOnPageIndex != this.currentPageDataSubheaderPointers.size()) break;
                this.readNextPage();
                this.currentRowOnPageIndex = 0;
                break;
            }
            case 512: {
                int subheaderPointerLength = this.sasFileProperties.isU64() ? 24 : 12;
                int alignCorrection = (bitOffset + 8 + this.currentPageSubheadersCount * subheaderPointerLength) % 8;
                this.currentRow = this.processByteArrayWithData((long)(bitOffset + 8 + alignCorrection + this.currentPageSubheadersCount * subheaderPointerLength) + (long)this.currentRowOnPageIndex++ * this.sasFileProperties.getRowLength(), this.sasFileProperties.getRowLength());
                if ((long)this.currentRowOnPageIndex != Math.min(this.sasFileProperties.getRowCount(), this.sasFileProperties.getMixPageRowCount())) break;
                this.readNextPage();
                this.currentRowOnPageIndex = 0;
                break;
            }
            case 256: {
                this.currentRow = this.processByteArrayWithData((long)(bitOffset + 8) + (long)this.currentRowOnPageIndex++ * this.sasFileProperties.getRowLength(), this.sasFileProperties.getRowLength());
                if (this.currentRowOnPageIndex != this.currentPageBlockCount) break;
                this.readNextPage();
                this.currentRowOnPageIndex = 0;
                break;
            }
        }
        return Arrays.copyOf(this.currentRow, this.currentRow.length);
    }

    private void readNextPage() throws IOException {
        this.processNextPage();
        while (this.currentPageType != 0 && this.currentPageType != 512 && this.currentPageType != 256) {
            if (this.eof) {
                return;
            }
            this.processNextPage();
        }
    }

    private void processNextPage() throws IOException {
        int bitOffset = this.sasFileProperties.isU64() ? 32 : 16;
        this.currentPageDataSubheaderPointers.clear();
        try {
            this.sasFileStream.readFully(this.cachedPage, 0, this.sasFileProperties.getPageLength());
        }
        catch (EOFException ex) {
            this.eof = true;
            return;
        }
        this.readPageHeader();
        if (this.currentPageType == 0) {
            ArrayList<SubheaderPointer> subheaderPointers = new ArrayList<SubheaderPointer>();
            this.processPageMetadata(bitOffset, subheaderPointers);
        }
    }

    private void readPageHeader() throws IOException {
        int bitOffset = this.sasFileProperties.isU64() ? 32 : 16;
        Long[] offset = new Long[]{(long)bitOffset + 0L, (long)bitOffset + 2L, (long)bitOffset + 4L};
        Integer[] length = new Integer[]{2, 2, 2};
        List<byte[]> vars = this.getBytesFromFile(offset, length);
        this.currentPageType = this.bytesToShort(vars.get(0));
        LOGGER.debug("Page type: {}", (Object)this.currentPageType);
        this.currentPageBlockCount = this.bytesToShort(vars.get(1));
        LOGGER.debug("Block count: {}", (Object)this.currentPageBlockCount);
        this.currentPageSubheadersCount = this.bytesToShort(vars.get(2));
        LOGGER.debug("Subheader count: {}", (Object)this.currentPageSubheadersCount);
    }

    private Object[] processByteArrayWithData(long rowOffset, long rowLength) {
        int offset;
        byte[] source;
        Object[] rowElements = new Object[(int)this.sasFileProperties.getColumnsCount()];
        if (this.sasFileProperties.isCompressed() && rowLength < this.sasFileProperties.getRowLength()) {
            Decompressor decompressor = LITERALS_TO_DECOMPRESSOR.get(this.sasFileProperties.getCompressionMethod());
            source = decompressor.decompressRow((int)rowOffset, (int)rowLength, (int)this.sasFileProperties.getRowLength(), this.cachedPage);
            offset = 0;
        } else {
            source = this.cachedPage;
            offset = (int)rowOffset;
        }
        int currentColumnIndex = 0;
        while ((long)currentColumnIndex < this.sasFileProperties.getColumnsCount() && this.columnsDataLength.get(currentColumnIndex) != 0) {
            int length = this.columnsDataLength.get(currentColumnIndex);
            if (this.columns.get(currentColumnIndex).getType() == Number.class) {
                byte[] temp = Arrays.copyOfRange(source, offset + (int)this.columnsDataOffset.get(currentColumnIndex).longValue(), offset + (int)this.columnsDataOffset.get(currentColumnIndex).longValue() + length);
                rowElements[currentColumnIndex] = this.columnsDataLength.get(currentColumnIndex) <= 2 ? Integer.valueOf(this.bytesToShort(temp)) : (this.columns.get(currentColumnIndex).getFormat().isEmpty() ? this.convertByteArrayToNumber(temp) : (SasFileConstants.DATE_TIME_FORMAT_STRINGS.contains(this.columns.get(currentColumnIndex).getFormat()) ? this.bytesToDateTime(temp) : (SasFileConstants.DATE_FORMAT_STRINGS.contains(this.columns.get(currentColumnIndex).getFormat()) ? this.bytesToDate(temp) : this.convertByteArrayToNumber(temp))));
            } else {
                byte[] bytes = this.trimBytesArray(source, offset + this.columnsDataOffset.get(currentColumnIndex).intValue(), length);
                if (this.byteOutput.booleanValue()) {
                    rowElements[currentColumnIndex] = bytes;
                } else {
                    try {
                        rowElements[currentColumnIndex] = bytes == null ? null : this.bytesToString(bytes);
                    }
                    catch (UnsupportedEncodingException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            ++currentColumnIndex;
        }
        return rowElements;
    }

    private List<byte[]> getBytesFromFile(Long[] offset, Integer[] length) throws IOException {
        ArrayList<byte[]> vars = new ArrayList<byte[]>();
        if (this.cachedPage == null) {
            for (int i = 0; i < offset.length; ++i) {
                byte[] temp = new byte[length[i].intValue()];
                for (long actuallySkipped = 0L; actuallySkipped < offset[i] - (long)this.currentFilePosition; actuallySkipped += this.sasFileStream.skip(offset[i] - (long)this.currentFilePosition - actuallySkipped)) {
                }
                try {
                    this.sasFileStream.readFully(temp, 0, length[i]);
                }
                catch (EOFException e) {
                    this.eof = true;
                }
                this.currentFilePosition = (int)offset[i].longValue() + length[i];
                vars.add(temp);
            }
        } else {
            for (int i = 0; i < offset.length; ++i) {
                vars.add(Arrays.copyOfRange(this.cachedPage, (int)offset[i].longValue(), (int)offset[i].longValue() + length[i]));
            }
        }
        return vars;
    }

    private long correctLongProcess(ByteBuffer byteBuffer) {
        if (this.sasFileProperties.isU64()) {
            return byteBuffer.getLong();
        }
        return byteBuffer.getInt();
    }

    private ByteBuffer byteArrayToByteBuffer(byte[] data) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        if (this.sasFileProperties.getEndianness() == 0) {
            return byteBuffer;
        }
        return byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    private Object convertByteArrayToNumber(byte[] mass) {
        double resultDouble = this.bytesToDouble(mass);
        if (Double.isNaN(resultDouble) || resultDouble < 1.0E-300 && resultDouble > 0.0) {
            return null;
        }
        long resultLong = Math.round(resultDouble);
        if (Math.abs(resultDouble - (double)resultLong) >= 1.0E-14) {
            return resultDouble;
        }
        return resultLong;
    }

    private int bytesToShort(byte[] bytes) {
        return this.byteArrayToByteBuffer(bytes).getShort();
    }

    private int bytesToInt(byte[] bytes) {
        return this.byteArrayToByteBuffer(bytes).getInt();
    }

    private long bytesToLong(byte[] bytes) {
        return this.correctLongProcess(this.byteArrayToByteBuffer(bytes));
    }

    private String bytesToString(byte[] bytes) throws UnsupportedEncodingException {
        return new String(bytes, this.encoding);
    }

    private String bytesToString(byte[] bytes, int offset, int length) throws UnsupportedEncodingException, StringIndexOutOfBoundsException {
        return new String(bytes, offset, length, this.encoding);
    }

    private Date bytesToDateTime(byte[] bytes) {
        double doubleSeconds = this.bytesToDouble(bytes);
        return Double.isNaN(doubleSeconds) ? null : new Date((long)((doubleSeconds - 3.156192E8) * 1000.0));
    }

    private Date bytesToDate(byte[] bytes) {
        double doubleDays = this.bytesToDouble(bytes);
        return Double.isNaN(doubleDays) ? null : new Date((long)((doubleDays - 3653.0) * 60.0 * 60.0 * 24.0 * 1000.0));
    }

    private double bytesToDouble(byte[] bytes) {
        ByteBuffer original = this.byteArrayToByteBuffer(bytes);
        if (bytes.length < 8) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            if (this.sasFileProperties.getEndianness() == 1) {
                byteBuffer.position(8 - bytes.length);
            }
            byteBuffer.put(original);
            byteBuffer.order(original.order());
            byteBuffer.position(0);
            original = byteBuffer;
        }
        return original.getDouble();
    }

    private byte[] trimBytesArray(byte[] source, int offset, int length) {
        int lengthFromBegin;
        for (lengthFromBegin = offset + length; lengthFromBegin > offset && (source[lengthFromBegin - 1] == 32 || source[lengthFromBegin - 1] == 0 || source[lengthFromBegin - 1] == 9); --lengthFromBegin) {
        }
        if (lengthFromBegin - offset != 0) {
            return Arrays.copyOfRange(source, offset, lengthFromBegin);
        }
        return null;
    }

    List<Column> getColumns() {
        return this.columns;
    }

    SasFileProperties getSasFileProperties() {
        return this.sasFileProperties;
    }

    static /* synthetic */ Object[] access$2502(SasFileParser x0, Object[] x1) {
        x0.currentRow = x1;
        return x1;
    }

    static {
        LITERALS_TO_DECOMPRESSOR = new HashMap<String, Decompressor>();
        HashMap<Long, SubheaderIndexes> tmpMap = new HashMap<Long, SubheaderIndexes>();
        tmpMap.put(-134744073L, SubheaderIndexes.ROW_SIZE_SUBHEADER_INDEX);
        tmpMap.put(-151587082L, SubheaderIndexes.COLUMN_SIZE_SUBHEADER_INDEX);
        tmpMap.put(-1024L, SubheaderIndexes.SUBHEADER_COUNTS_SUBHEADER_INDEX);
        tmpMap.put(-3L, SubheaderIndexes.COLUMN_TEXT_SUBHEADER_INDEX);
        tmpMap.put(-1L, SubheaderIndexes.COLUMN_NAME_SUBHEADER_INDEX);
        tmpMap.put(-4L, SubheaderIndexes.COLUMN_ATTRIBUTES_SUBHEADER_INDEX);
        tmpMap.put(-1026L, SubheaderIndexes.FORMAT_AND_LABEL_SUBHEADER_INDEX);
        tmpMap.put(-2L, SubheaderIndexes.COLUMN_LIST_SUBHEADER_INDEX);
        tmpMap.put(0xF7F7F7F7L, SubheaderIndexes.ROW_SIZE_SUBHEADER_INDEX);
        tmpMap.put(0xF6F6F6F6L, SubheaderIndexes.COLUMN_SIZE_SUBHEADER_INDEX);
        tmpMap.put(-578721386864836608L, SubheaderIndexes.ROW_SIZE_SUBHEADER_INDEX);
        tmpMap.put(-651061559686070272L, SubheaderIndexes.COLUMN_SIZE_SUBHEADER_INDEX);
        tmpMap.put(-578721382569870338L, SubheaderIndexes.ROW_SIZE_SUBHEADER_INDEX);
        tmpMap.put(-651061555391104002L, SubheaderIndexes.COLUMN_SIZE_SUBHEADER_INDEX);
        tmpMap.put(0xFCFFFFFFFFFFFFL, SubheaderIndexes.SUBHEADER_COUNTS_SUBHEADER_INDEX);
        tmpMap.put(-144115188075855873L, SubheaderIndexes.COLUMN_TEXT_SUBHEADER_INDEX);
        tmpMap.put(-1L, SubheaderIndexes.COLUMN_NAME_SUBHEADER_INDEX);
        tmpMap.put(-216172782113783809L, SubheaderIndexes.COLUMN_ATTRIBUTES_SUBHEADER_INDEX);
        tmpMap.put(-73183493944770561L, SubheaderIndexes.FORMAT_AND_LABEL_SUBHEADER_INDEX);
        tmpMap.put(-72057594037927937L, SubheaderIndexes.COLUMN_LIST_SUBHEADER_INDEX);
        SUBHEADER_SIGNATURE_TO_INDEX = Collections.unmodifiableMap(tmpMap);
        LITERALS_TO_DECOMPRESSOR.put("SASYZCRL", CharDecompressor.INSTANCE);
        LITERALS_TO_DECOMPRESSOR.put("SASYZCR2", BinDecompressor.INSTANCE);
    }

    class DataSubheader
    implements ProcessingSubheader {
        DataSubheader() {
        }

        @Override
        public void processSubheader(long subheaderOffset, long subheaderLength) throws IOException {
            SasFileParser.access$2502(SasFileParser.this, SasFileParser.this.processByteArrayWithData(subheaderOffset, subheaderLength));
        }
    }

    class ColumnListSubheader
    implements ProcessingSubheader {
        ColumnListSubheader() {
        }

        @Override
        public void processSubheader(long subheaderOffset, long subheaderLength) throws IOException {
        }
    }

    class FormatAndLabelSubheader
    implements ProcessingSubheader {
        FormatAndLabelSubheader() {
        }

        @Override
        public void processSubheader(long subheaderOffset, long subheaderLength) throws IOException {
            int intOrLongLength = SasFileParser.this.sasFileProperties.isU64() ? 8 : 4;
            Long[] offset = new Long[]{subheaderOffset + 22L + (long)(3 * intOrLongLength), subheaderOffset + 24L + (long)(3 * intOrLongLength), subheaderOffset + 26L + (long)(3 * intOrLongLength), subheaderOffset + 28L + (long)(3 * intOrLongLength), subheaderOffset + 30L + (long)(3 * intOrLongLength), subheaderOffset + 32L + (long)(3 * intOrLongLength)};
            Integer[] length = new Integer[]{2, 2, 2, 2, 2, 2};
            List vars = SasFileParser.this.getBytesFromFile(offset, length);
            int textSubheaderIndexForFormat = Math.min(SasFileParser.this.bytesToShort((byte[])vars.get(0)), SasFileParser.this.columnsNamesBytes.size() - 1);
            int columnFormatOffset = SasFileParser.this.bytesToShort((byte[])vars.get(1));
            int columnFormatLength = SasFileParser.this.bytesToShort((byte[])vars.get(2));
            int textSubheaderIndexForLabel = Math.min(SasFileParser.this.bytesToShort((byte[])vars.get(3)), SasFileParser.this.columnsNamesBytes.size() - 1);
            int columnLabelOffset = SasFileParser.this.bytesToShort((byte[])vars.get(4));
            int columnLabelLength = SasFileParser.this.bytesToShort((byte[])vars.get(5));
            String columnLabel = SasFileParser.this.bytesToString((byte[])SasFileParser.this.columnsNamesBytes.get(textSubheaderIndexForLabel), columnLabelOffset, columnLabelLength).intern();
            String columnFormat = SasFileParser.this.bytesToString((byte[])SasFileParser.this.columnsNamesBytes.get(textSubheaderIndexForFormat), columnFormatOffset, columnFormatLength).intern();
            LOGGER.debug("Column format: {}", (Object)columnFormat);
            SasFileParser.this.columns.add(new Column(SasFileParser.this.currentColumnNumber + 1, (String)SasFileParser.this.columnsNamesList.get(SasFileParser.this.columns.size()), columnLabel, columnFormat, (Class)SasFileParser.this.columnsTypesList.get(SasFileParser.this.columns.size()), (Integer)SasFileParser.this.columnsDataLength.get(SasFileParser.this.currentColumnNumber++)));
        }
    }

    class ColumnAttributesSubheader
    implements ProcessingSubheader {
        ColumnAttributesSubheader() {
        }

        @Override
        public void processSubheader(long subheaderOffset, long subheaderLength) throws IOException {
            int intOrLongLength = SasFileParser.this.sasFileProperties.isU64() ? 8 : 4;
            long columnAttributesVectorsCount = (subheaderLength - (long)(2 * intOrLongLength) - 12L) / (long)(intOrLongLength + 8);
            int i = 0;
            while ((long)i < columnAttributesVectorsCount) {
                Long[] offset = new Long[]{subheaderOffset + (long)intOrLongLength + 8L + (long)(i * (intOrLongLength + 8)), subheaderOffset + (long)(2 * intOrLongLength) + 8L + (long)(i * (intOrLongLength + 8)), subheaderOffset + (long)(2 * intOrLongLength) + 14L + (long)(i * (intOrLongLength + 8))};
                Integer[] length = new Integer[]{intOrLongLength, 4, 1};
                List vars = SasFileParser.this.getBytesFromFile(offset, length);
                SasFileParser.this.columnsDataOffset.add(SasFileParser.this.bytesToLong((byte[])vars.get(0)));
                SasFileParser.this.columnsDataLength.add(SasFileParser.this.bytesToInt((byte[])vars.get(1)));
                SasFileParser.this.columnsTypesList.add(((byte[])vars.get(2))[0] == 1 ? Number.class : String.class);
                ++i;
            }
        }
    }

    class ColumnNameSubheader
    implements ProcessingSubheader {
        ColumnNameSubheader() {
        }

        @Override
        public void processSubheader(long subheaderOffset, long subheaderLength) throws IOException {
            int intOrLongLength = SasFileParser.this.sasFileProperties.isU64() ? 8 : 4;
            long columnNamePointersCount = (subheaderLength - (long)(2 * intOrLongLength) - 12L) / 8L;
            int i = 0;
            while ((long)i < columnNamePointersCount) {
                Long[] offset = new Long[]{subheaderOffset + (long)intOrLongLength + (long)(8 * (i + 1)) + 0L, subheaderOffset + (long)intOrLongLength + (long)(8 * (i + 1)) + 2L, subheaderOffset + (long)intOrLongLength + (long)(8 * (i + 1)) + 4L};
                Integer[] length = new Integer[]{2, 2, 2};
                List vars = SasFileParser.this.getBytesFromFile(offset, length);
                int textSubheaderIndex = SasFileParser.this.bytesToShort((byte[])vars.get(0));
                int columnNameOffset = SasFileParser.this.bytesToShort((byte[])vars.get(1));
                int columnNameLength = SasFileParser.this.bytesToShort((byte[])vars.get(2));
                SasFileParser.this.columnsNamesList.add(SasFileParser.this.bytesToString((byte[])SasFileParser.this.columnsNamesBytes.get(textSubheaderIndex), columnNameOffset, columnNameLength).intern());
                ++i;
            }
        }
    }

    class ColumnTextSubheader
    implements ProcessingSubheader {
        ColumnTextSubheader() {
        }

        @Override
        public void processSubheader(long subheaderOffset, long subheaderLength) throws IOException {
            int intOrLongLength = SasFileParser.this.sasFileProperties.isU64() ? 8 : 4;
            Long[] offset = new Long[]{subheaderOffset + (long)intOrLongLength};
            Integer[] length = new Integer[]{2};
            List vars = SasFileParser.this.getBytesFromFile(offset, length);
            short textBlockSize = SasFileParser.this.byteArrayToByteBuffer((byte[])vars.get(0)).getShort();
            offset[0] = subheaderOffset + (long)intOrLongLength;
            length[0] = textBlockSize;
            vars = SasFileParser.this.getBytesFromFile(offset, length);
            SasFileParser.this.columnsNamesBytes.add(vars.get(0));
            if (SasFileParser.this.columnsNamesBytes.size() == 1) {
                byte[] columnName = (byte[])SasFileParser.this.columnsNamesBytes.get(0);
                String compessionLiteral = SasFileParser.this.findCompressionLiteral(SasFileParser.this.bytesToString(columnName));
                SasFileParser.this.sasFileProperties.setCompressionMethod(compessionLiteral);
            }
        }
    }

    class SubheaderCountsSubheader
    implements ProcessingSubheader {
        SubheaderCountsSubheader() {
        }

        @Override
        public void processSubheader(long subheaderOffset, long subheaderLength) throws IOException {
        }
    }

    class ColumnSizeSubheader
    implements ProcessingSubheader {
        ColumnSizeSubheader() {
        }

        @Override
        public void processSubheader(long subheaderOffset, long subheaderLength) throws IOException {
            int intOrLongLength = SasFileParser.this.sasFileProperties.isU64() ? 8 : 4;
            Long[] offset = new Long[]{subheaderOffset + (long)intOrLongLength};
            Integer[] length = new Integer[]{intOrLongLength};
            List vars = SasFileParser.this.getBytesFromFile(offset, length);
            SasFileParser.this.sasFileProperties.setColumnsCount(SasFileParser.this.bytesToLong((byte[])vars.get(0)));
        }
    }

    class RowSizeSubheader
    implements ProcessingSubheader {
        RowSizeSubheader() {
        }

        @Override
        public void processSubheader(long subheaderOffset, long subheaderLength) throws IOException {
            int intOrLongLength = SasFileParser.this.sasFileProperties.isU64() ? 8 : 4;
            Long[] offset = new Long[]{subheaderOffset + (long)(5 * intOrLongLength), subheaderOffset + (long)(6 * intOrLongLength), subheaderOffset + (long)(15 * intOrLongLength)};
            Integer[] length = new Integer[]{intOrLongLength, intOrLongLength, intOrLongLength};
            List vars = SasFileParser.this.getBytesFromFile(offset, length);
            if (SasFileParser.this.sasFileProperties.getRowLength() == 0L) {
                SasFileParser.this.sasFileProperties.setRowLength(SasFileParser.this.bytesToLong((byte[])vars.get(0)));
            }
            if (SasFileParser.this.sasFileProperties.getRowCount() == 0L) {
                SasFileParser.this.sasFileProperties.setRowCount(SasFileParser.this.bytesToLong((byte[])vars.get(1)));
            }
            if (SasFileParser.this.sasFileProperties.getMixPageRowCount() == 0L) {
                SasFileParser.this.sasFileProperties.setMixPageRowCount(SasFileParser.this.bytesToLong((byte[])vars.get(2)));
            }
        }
    }

    class SubheaderPointer {
        private final long offset;
        private final long length;
        private final byte compression;
        private final byte type;

        SubheaderPointer(long offset, long length, byte compression, byte type) {
            this.offset = offset;
            this.length = length;
            this.compression = compression;
            this.type = type;
        }
    }

    static class Builder {
        private InputStream sasFileStream;
        private String encoding = "US-ASCII";
        private Boolean byteOutput = false;

        Builder() {
        }

        Builder sasFileStream(InputStream val) {
            this.sasFileStream = val;
            return this;
        }

        Builder encoding(String val) {
            this.encoding = val;
            return this;
        }

        Builder byteOutput(Boolean val) {
            this.byteOutput = val;
            return this;
        }

        SasFileParser build() {
            return new SasFileParser(this);
        }
    }

    private static interface ProcessingSubheader {
        public void processSubheader(long var1, long var3) throws IOException;
    }

    private static enum SubheaderIndexes {
        ROW_SIZE_SUBHEADER_INDEX,
        COLUMN_SIZE_SUBHEADER_INDEX,
        SUBHEADER_COUNTS_SUBHEADER_INDEX,
        COLUMN_TEXT_SUBHEADER_INDEX,
        COLUMN_NAME_SUBHEADER_INDEX,
        COLUMN_ATTRIBUTES_SUBHEADER_INDEX,
        FORMAT_AND_LABEL_SUBHEADER_INDEX,
        COLUMN_LIST_SUBHEADER_INDEX,
        DATA_SUBHEADER_INDEX;

    }
}

