/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.utils;

import com.epam.healenium.handlers.proxy.SelfHealingProxyInvocationHandler;
import com.epam.healenium.handlers.proxy.WebElementProxyHandler;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StackUtils {
    private static final Logger log = LoggerFactory.getLogger(StackUtils.class);

    public static boolean isAnnotationPresent(Class<? extends Annotation> aClass) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        return StackUtils.findAnnotatedInTrace(trace, aClass).isPresent();
    }

    public static Optional<StackTraceElement> findOriginCaller() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        return StackUtils.findOriginCaller(trace);
    }

    public static Optional<StackTraceElement> findOriginCaller(StackTraceElement[] elements) {
        List<StackTraceElement> elementList = StackUtils.normalize(elements);
        String callerName = StackUtils.getCallerPackageName(elementList);
        if (StringUtils.isBlank((CharSequence)callerName)) {
            return Optional.empty();
        }
        Collections.reverse(elementList);
        return elementList.stream().filter(it -> it.getClassName().startsWith(callerName)).findFirst();
    }

    public static Optional<StackTraceElement> getElementByClass(StackTraceElement[] elements, String targetClass) {
        return Arrays.stream(elements).filter(StackUtils.redundantPackages()).filter(element -> {
            String className = element.getClassName();
            String simpleClassName = className.substring(className.lastIndexOf(46) + 1);
            return simpleClassName.equals(targetClass);
        }).findFirst();
    }

    private static Optional<StackTraceElement> findAnnotatedInTrace(StackTraceElement[] elements, Class<? extends Annotation> clazz) {
        return Arrays.stream(elements).filter(StackUtils.redundantPackages()).filter(it -> {
            try {
                Class<?> aClass = Class.forName(it.getClassName());
                String methodName = it.getMethodName();
                return Arrays.stream(aClass.getMethods()).filter(m -> m.getName().equals(methodName)).anyMatch(m -> {
                    for (Annotation annotation : m.getDeclaredAnnotations()) {
                        if (!clazz.isInstance(annotation)) continue;
                        log.debug("Found at ={},{}", (Object)it.getClassName(), (Object)methodName);
                        return true;
                    }
                    return false;
                });
            }
            catch (ClassNotFoundException ex) {
                log.warn("Failed to check class: {}", (Object)it.getClassName());
                return false;
            }
        }).findFirst();
    }

    private static Predicate<StackTraceElement> redundantPackages() {
        return value -> {
            Stream<String> skippingPackageStream = Stream.of("java.base", "sun.reflect", "java.lang", "org.gradle", "org.junit", "java.util", "com.sun", "com.google", "jdk.internal", "org.openqa", "com.codeborne", "ru.yandex", "jdk.proxy2");
            return skippingPackageStream.noneMatch(s -> value.getClassName().startsWith((String)s));
        };
    }

    private static List<StackTraceElement> normalize(StackTraceElement[] traceElements) {
        List elementList = Arrays.stream(traceElements).filter(StackUtils.redundantPackages()).collect(Collectors.toList());
        Collections.reverse(elementList);
        elementList = ((StreamEx)StreamEx.of(elementList).takeWhile(it -> !it.getClassName().equals(SelfHealingProxyInvocationHandler.class.getName()) && !it.getClassName().equals(WebElementProxyHandler.class.getName()))).toList();
        return elementList.subList(0, elementList.size());
    }

    private static String getCallerPackageName(List<StackTraceElement> traceElements) {
        String result = "";
        try {
            StackTraceElement element = (StackTraceElement)Iterables.getLast(traceElements);
            String className = element.getClassName();
            int dotPos = StackUtils.lastDotPosition(className);
            result = element.getClassName().substring(0, Math.max(dotPos, 0));
        }
        catch (Exception ex) {
            log.warn("Failed to find caller package name", (Throwable)ex);
        }
        return result;
    }

    private static int lastDotPosition(String input) {
        int dot1 = input.indexOf(".");
        int dot2 = input.indexOf(".", dot1 + 1);
        return Math.max(dot1, dot2);
    }

    private StackUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

