/*
 * Decompiled with CFR 0.152.
 */
package com.epages.restdocs.apispec.postman.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "key", "value", "type", "name", "description", "system", "disabled"})
public class Variable {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="A variable ID is a unique user-defined value that identifies the variable within a collection. In traditional terms, this would be a variable name.")
    private String id;
    @JsonProperty(value="key")
    @JsonPropertyDescription(value="A variable key is a human friendly value that identifies the variable within a collection. In traditional terms, this would be a variable name.")
    private String key;
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="The value that a variable holds in this collection. Ultimately, the variables will be replaced by this value, when say running a set of requests from a collection")
    private Object value;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="A variable may have multiple types. This field specifies the type of the variable.")
    private Type type;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Variable name")
    private String name;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="A Description can be a raw text, or be an object, which holds the description along with its format.")
    private String description;
    @JsonProperty(value="system")
    @JsonPropertyDescription(value="When set to true, indicates that this variable has been set by Postman")
    private Boolean system = false;
    @JsonProperty(value="disabled")
    private Boolean disabled = false;

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    @JsonProperty(value="value")
    public Object getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(Object value) {
        this.value = value;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="system")
    public Boolean getSystem() {
        return this.system;
    }

    @JsonProperty(value="system")
    public void setSystem(Boolean system) {
        this.system = system;
    }

    @JsonProperty(value="disabled")
    public Boolean getDisabled() {
        return this.disabled;
    }

    @JsonProperty(value="disabled")
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public static enum Type {
        STRING("string"),
        BOOLEAN("boolean"),
        ANY("any"),
        NUMBER("number");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

