/*
 * Decompiled with CFR 0.152.
 */
package com.epages.restdocs.apispec.openapi2;

import com.epages.restdocs.apispec.openapi2.OptimizedYamlSerializationObjectMapperFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bH\u0002J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/epages/restdocs/apispec/openapi2/ApiSpecificationWriter;", "", "()V", "jsonFormats", "", "", "yamlFormats", "optimizedYaml", "Lcom/fasterxml/jackson/databind/ObjectWriter;", "kotlin.jvm.PlatformType", "serialize", "format", "apiSpecification", "Lio/swagger/models/Swagger;", "supportedFormats", "validateFormat", "", "restdocs-api-spec-openapi-generator"})
public final class ApiSpecificationWriter {
    private static final Set<String> yamlFormats;
    private static final Set<String> jsonFormats;
    @NotNull
    public static final ApiSpecificationWriter INSTANCE;

    @NotNull
    public final String serialize(@NotNull String format, @NotNull Swagger apiSpecification) {
        String string;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)apiSpecification, (String)"apiSpecification");
        this.validateFormat(format);
        if (yamlFormats.contains(format)) {
            String string2 = this.optimizedYaml().writeValueAsString((Object)apiSpecification);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"optimizedYaml().writeVal\u2026sString(apiSpecification)");
        } else {
            String string3 = Json.pretty().writeValueAsString((Object)apiSpecification);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Json.pretty().writeValueAsString(apiSpecification)");
        }
        return string;
    }

    private final ObjectWriter optimizedYaml() {
        return OptimizedYamlSerializationObjectMapperFactory.INSTANCE.createYaml().writer((PrettyPrinter)new DefaultPrettyPrinter());
    }

    @NotNull
    public final Set<String> supportedFormats() {
        return SetsKt.plus(yamlFormats, (Iterable)jsonFormats);
    }

    public final void validateFormat(@NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        if (!this.supportedFormats().contains(format)) {
            throw (Throwable)new IllegalArgumentException("Format '" + format + "' is invalid - supported formats are '" + this.supportedFormats() + '\'');
        }
    }

    private ApiSpecificationWriter() {
    }

    static {
        ApiSpecificationWriter apiSpecificationWriter;
        INSTANCE = apiSpecificationWriter = new ApiSpecificationWriter();
        yamlFormats = SetsKt.setOf((Object[])new String[]{"yaml", "yml"});
        jsonFormats = SetsKt.setOf((Object)"json");
    }
}

