/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client.issuer.bypass;

import com.envimate.httpmate.HttpMate;
import com.envimate.httpmate.HttpMateChainKeys;
import com.envimate.httpmate.chains.MetaData;
import com.envimate.httpmate.client.HttpClientRequest;
import com.envimate.httpmate.client.RawClientResponse;
import com.envimate.httpmate.client.RequestPath;
import com.envimate.httpmate.client.UriString;
import com.envimate.httpmate.client.issuer.Issuer;
import com.envimate.httpmate.client.issuer.bypass.SynchronizationWrapper;
import com.envimate.httpmate.util.Maps;
import com.envimate.httpmate.util.Validators;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class BypassIssuer
implements Issuer {
    private final HttpMate httpMate;

    public static Issuer bypassIssuer(HttpMate httpMate) {
        Validators.validateNotNull((Object)httpMate, (String)"httpMate");
        return new BypassIssuer(httpMate);
    }

    @Override
    public <T> T issue(HttpClientRequest<T> request, Function<RawClientResponse, T> responseMapper) {
        MetaData metaData = MetaData.emptyMetaData();
        RequestPath requestPath = request.path();
        metaData.set(HttpMateChainKeys.RAW_PATH, (Object)requestPath.path());
        Map<String, String> queryParameters = requestPath.queryParameters().stream().collect(Collectors.toMap(queryParameter -> queryParameter.key().encoded(), queryParameter -> queryParameter.value().map(UriString::encoded).orElse("")));
        metaData.set(HttpMateChainKeys.RAW_REQUEST_QUERY_PARAMETERS, queryParameters);
        metaData.set(HttpMateChainKeys.RAW_METHOD, (Object)request.method());
        metaData.set(HttpMateChainKeys.RAW_REQUEST_HEADERS, (Object)Maps.mapToMultiMap(request.headers()));
        request.body().ifPresent(inputStream -> metaData.set(HttpMateChainKeys.REQUEST_BODY_STREAM, inputStream));
        metaData.set(HttpMateChainKeys.IS_HTTP_REQUEST, (Object)true);
        SynchronizationWrapper wrapper = new SynchronizationWrapper();
        this.httpMate.handleRequest(metaData, wrapper::setObject);
        Map responseHeaders = (Map)metaData.get(HttpMateChainKeys.RESPONSE_HEADERS);
        int responseStatus = (Integer)metaData.get(HttpMateChainKeys.RESPONSE_STATUS);
        InputStream responseBody = (InputStream)metaData.get(HttpMateChainKeys.RESPONSE_STREAM);
        RawClientResponse response = RawClientResponse.rawClientResponse(responseStatus, responseHeaders, responseBody);
        return responseMapper.apply(response);
    }

    @Override
    public void close() {
    }

    private BypassIssuer(HttpMate httpMate) {
        this.httpMate = httpMate;
    }
}

