/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client.body.multipart;

import com.envimate.httpmate.client.body.multipart.builder.FileNameStage;
import com.envimate.httpmate.util.Validators;
import java.io.InputStream;
import java.util.Optional;

public final class Part {
    private final String controlName;
    private final String fileName;
    private final InputStream fileContent;

    public static FileNameStage aPartWithTheControlName(String controlName) {
        return fileName -> content -> {
            Validators.validateNotNullNorEmpty((String)controlName, (String)"controlName");
            Validators.validateNotNull((Object)content, (String)"content");
            return new Part(controlName, fileName, content);
        };
    }

    InputStream fileContent() {
        return this.fileContent;
    }

    String controlName() {
        return this.controlName;
    }

    Optional<String> fileName() {
        return Optional.ofNullable(this.fileName);
    }

    public String toString() {
        return "Part(controlName=" + this.controlName + ", fileName=" + this.fileName + ", fileContent=" + this.fileContent + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Part)) {
            return false;
        }
        Part other = (Part)o;
        String this$controlName = this.controlName;
        String other$controlName = other.controlName;
        if (this$controlName == null ? other$controlName != null : !this$controlName.equals(other$controlName)) {
            return false;
        }
        String this$fileName = this.fileName;
        String other$fileName = other.fileName;
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        InputStream this$fileContent = this.fileContent;
        InputStream other$fileContent = other.fileContent;
        return !(this$fileContent == null ? other$fileContent != null : !this$fileContent.equals(other$fileContent));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $controlName = this.controlName;
        result = result * 59 + ($controlName == null ? 43 : $controlName.hashCode());
        String $fileName = this.fileName;
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        InputStream $fileContent = this.fileContent;
        result = result * 59 + ($fileContent == null ? 43 : $fileContent.hashCode());
        return result;
    }

    private Part(String controlName, String fileName, InputStream fileContent) {
        this.controlName = controlName;
        this.fileName = fileName;
        this.fileContent = fileContent;
    }
}

