/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client;

import com.envimate.httpmate.client.UriString;
import com.envimate.httpmate.util.Validators;
import java.util.Objects;
import java.util.Optional;

public final class QueryParameter {
    private final UriString key;
    private final UriString value;

    public static QueryParameter queryParameter(String key, String value) {
        Validators.validateNotNullNorEmpty((String)key, (String)"key");
        Validators.validateNotNull((Object)value, (String)"value");
        return new QueryParameter(UriString.uriString(key), UriString.uriString(value));
    }

    public static QueryParameter queryParameter(String key) {
        Validators.validateNotNullNorEmpty((String)key, (String)"key");
        return new QueryParameter(UriString.uriString(key), null);
    }

    public static QueryParameter parse(String keyValue) {
        Validators.validateNotNull((Object)keyValue, (String)"keyValue");
        if (!keyValue.contains("=")) {
            return QueryParameter.queryParameter(keyValue);
        }
        int splitPosition = keyValue.indexOf(61);
        String key = keyValue.substring(0, splitPosition);
        String value = keyValue.substring(splitPosition + 1);
        return QueryParameter.queryParameter(key, value);
    }

    public String render() {
        if (Objects.isNull(this.value)) {
            return this.key.encoded();
        }
        return String.format("%s=%s", this.key.encoded(), this.value.encoded());
    }

    public UriString key() {
        return this.key;
    }

    public Optional<UriString> value() {
        return Optional.ofNullable(this.value);
    }

    public String toString() {
        return "QueryParameter(key=" + this.key + ", value=" + this.value + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryParameter)) {
            return false;
        }
        QueryParameter other = (QueryParameter)o;
        UriString this$key = this.key;
        UriString other$key = other.key;
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        UriString this$value = this.value;
        UriString other$value = other.value;
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UriString $key = this.key;
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        UriString $value = this.value;
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    private QueryParameter(UriString key, UriString value) {
        this.key = key;
        this.value = value;
    }
}

