/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client;

import com.envimate.httpmate.client.BasePath;
import com.envimate.httpmate.client.ClientResponseMapper;
import com.envimate.httpmate.client.HttpMateClient;
import com.envimate.httpmate.client.RawClientResponse;
import com.envimate.httpmate.client.SimpleHttpResponseObject;
import com.envimate.httpmate.client.UnsupportedTargetTypeException;
import com.envimate.httpmate.client.issuer.Issuer;
import com.envimate.httpmate.filtermap.FilterMapBuilder;
import com.envimate.httpmate.util.Streams;
import com.envimate.httpmate.util.Validators;
import java.io.InputStream;
import java.util.function.Function;
import java.util.function.Predicate;

public final class HttpMateClientBuilder {
    private final Function<BasePath, Issuer> issuer;
    private final FilterMapBuilder<Class<?>, ClientResponseMapper<?>> responseMappers;
    private BasePath basePath = BasePath.basePath("");

    static HttpMateClientBuilder clientBuilder(Function<BasePath, Issuer> issuer) {
        Validators.validateNotNull(issuer, (String)"issuer");
        HttpMateClientBuilder builder = new HttpMateClientBuilder(issuer, FilterMapBuilder.filterMapBuilder());
        builder.withResponseMapping(String.class, (RawClientResponse response, Class<T> targetType) -> {
            if (targetType.equals(String.class)) {
                return Streams.inputStreamToString((InputStream)response.content());
            }
            throw UnsupportedTargetTypeException.unsupportedTargetTypeException(String.class, targetType);
        });
        builder.withResponseMapping(SimpleHttpResponseObject.class, (RawClientResponse response, Class<T> targetType) -> {
            if (targetType.equals(SimpleHttpResponseObject.class)) {
                String body = Streams.inputStreamToString((InputStream)response.content());
                return SimpleHttpResponseObject.httpClientResponse(response.statusCode(), response.headers(), body);
            }
            throw UnsupportedTargetTypeException.unsupportedTargetTypeException(SimpleHttpResponseObject.class, targetType);
        });
        builder.withDefaultResponseMapping((response, targetType) -> {
            throw new RuntimeException(String.format("Cannot map response '%s' to type '%s' because no default response mapper was defined", response.toString(), targetType.getName()));
        });
        return builder;
    }

    public HttpMateClientBuilder withBasePath(String basePath) {
        this.basePath = BasePath.basePath(basePath);
        return this;
    }

    public HttpMateClientBuilder withDefaultResponseMapping(ClientResponseMapper<?> mapper) {
        Validators.validateNotNull(mapper, (String)"mapper");
        this.responseMappers.setDefaultValue(mapper);
        return this;
    }

    public <T> HttpMateClientBuilder withResponseMapping(Class<T> type, ClientResponseMapper<T> mapper) {
        Validators.validateNotNull(type, (String)"type");
        Validators.validateNotNull(mapper, (String)"mapper");
        return this.withResponseMapping(HttpMateClientBuilder.subtype(type), mapper);
    }

    public <T> HttpMateClientBuilder withResponseMapping(Predicate<Class<T>> filter, ClientResponseMapper<T> mapper) {
        Validators.validateNotNull(filter, (String)"filter");
        Validators.validateNotNull(mapper, (String)"mapper");
        this.responseMappers.put(filter, mapper);
        return this;
    }

    public HttpMateClient build() {
        Issuer issuer = this.issuer.apply(this.basePath);
        return HttpMateClient.httpMateClient(issuer, this.basePath, this.responseMappers.build());
    }

    private static <T> Predicate<Class<T>> subtype(Class<T> type) {
        return type::isAssignableFrom;
    }

    public String toString() {
        return "HttpMateClientBuilder(issuer=" + this.issuer + ", responseMappers=" + this.responseMappers + ", basePath=" + this.basePath + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpMateClientBuilder)) {
            return false;
        }
        HttpMateClientBuilder other = (HttpMateClientBuilder)o;
        Function<BasePath, Issuer> this$issuer = this.issuer;
        Function<BasePath, Issuer> other$issuer = other.issuer;
        if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
            return false;
        }
        FilterMapBuilder<Class<?>, ClientResponseMapper<?>> this$responseMappers = this.responseMappers;
        FilterMapBuilder<Class<?>, ClientResponseMapper<?>> other$responseMappers = other.responseMappers;
        if (this$responseMappers == null ? other$responseMappers != null : !this$responseMappers.equals(other$responseMappers)) {
            return false;
        }
        BasePath this$basePath = this.basePath;
        BasePath other$basePath = other.basePath;
        return !(this$basePath == null ? other$basePath != null : !((Object)this$basePath).equals(other$basePath));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Function<BasePath, Issuer> $issuer = this.issuer;
        result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
        FilterMapBuilder<Class<?>, ClientResponseMapper<?>> $responseMappers = this.responseMappers;
        result = result * 59 + ($responseMappers == null ? 43 : $responseMappers.hashCode());
        BasePath $basePath = this.basePath;
        result = result * 59 + ($basePath == null ? 43 : ((Object)$basePath).hashCode());
        return result;
    }

    private HttpMateClientBuilder(Function<BasePath, Issuer> issuer, FilterMapBuilder<Class<?>, ClientResponseMapper<?>> responseMappers) {
        this.issuer = issuer;
        this.responseMappers = responseMappers;
    }
}

