/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client;

import com.envimate.httpmate.HttpMate;
import com.envimate.httpmate.client.BasePath;
import com.envimate.httpmate.client.ClientResponseMapper;
import com.envimate.httpmate.client.HttpClientRequest;
import com.envimate.httpmate.client.HttpClientRequestBuilder;
import com.envimate.httpmate.client.HttpMateClientBuilder;
import com.envimate.httpmate.client.RawClientResponse;
import com.envimate.httpmate.client.clientbuilder.PortStage;
import com.envimate.httpmate.client.issuer.Issuer;
import com.envimate.httpmate.client.issuer.bypass.BypassIssuer;
import com.envimate.httpmate.client.issuer.real.RealIssuer;
import com.envimate.httpmate.filtermap.FilterMap;
import com.envimate.httpmate.util.Validators;

public final class HttpMateClient {
    private final Issuer issuer;
    private final BasePath basePath;
    private final FilterMap<Class<?>, ClientResponseMapper<?>> responseMappers;

    static HttpMateClient httpMateClient(Issuer issuer, BasePath basePath, FilterMap<Class<?>, ClientResponseMapper<?>> responseMappers) {
        Validators.validateNotNull((Object)issuer, (String)"issuer");
        Validators.validateNotNull((Object)basePath, (String)"basePath");
        Validators.validateNotNull(responseMappers, (String)"responseMappers");
        return new HttpMateClient(issuer, basePath, responseMappers);
    }

    public static HttpMateClientBuilder aHttpMateClientBypassingRequestsDirectlyTo(HttpMate httpMate) {
        Validators.validateNotNull((Object)httpMate, (String)"httpMate");
        Issuer issuer = BypassIssuer.bypassIssuer(httpMate);
        return HttpMateClientBuilder.clientBuilder(basePath -> issuer);
    }

    public static PortStage aHttpMateClientForTheHost(String host) {
        Validators.validateNotNullNorEmpty((String)host, (String)"host");
        return port -> protocol -> {
            Validators.validateNotNull((Object)((Object)protocol), (String)"protocol");
            return HttpMateClientBuilder.clientBuilder(basePath -> RealIssuer.realIssuer(protocol, host, port, basePath));
        };
    }

    public static PortStage aHttpMateClientThatReusesConnectionsForTheHost(String host) {
        Validators.validateNotNullNorEmpty((String)host, (String)"host");
        return port -> protocol -> {
            Validators.validateNotNull((Object)((Object)protocol), (String)"protocol");
            return HttpMateClientBuilder.clientBuilder(basePath -> RealIssuer.realIssuerWithConnectionReuse(protocol, host, port, basePath));
        };
    }

    public <T> T issue(HttpClientRequestBuilder<T> requestBuilder) {
        return this.issue(requestBuilder.build());
    }

    public <T> T issue(HttpClientRequest<T> request) {
        Validators.validateNotNull(request, (String)"request");
        return (T)this.issuer.issue(request, this.basePath, response -> {
            Class targetType = request.targetType();
            ClientResponseMapper responseMapper = (ClientResponseMapper)this.responseMappers.get(targetType);
            return responseMapper.map((RawClientResponse)response, targetType);
        });
    }

    private HttpMateClient(Issuer issuer, BasePath basePath, FilterMap<Class<?>, ClientResponseMapper<?>> responseMappers) {
        this.issuer = issuer;
        this.basePath = basePath;
        this.responseMappers = responseMappers;
    }
}

