/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client;

import com.envimate.httpmate.HttpMate;
import com.envimate.httpmate.client.BasePath;
import com.envimate.httpmate.client.ClientResponseMapper;
import com.envimate.httpmate.client.HttpClientRequest;
import com.envimate.httpmate.client.RawClientResponse;
import com.envimate.httpmate.client.clientbuilder.BasePathStage;
import com.envimate.httpmate.client.clientbuilder.PortStage;
import com.envimate.httpmate.client.issuer.Issuer;
import com.envimate.httpmate.client.issuer.bypass.BypassIssuer;
import com.envimate.httpmate.client.issuer.real.RealIssuer;
import com.envimate.httpmate.util.Validators;

public final class HttpMateClient {
    private final Issuer issuer;
    private final BasePath basePath;
    private final ClientResponseMapper responseMapper;

    public static BasePathStage aHttpMateClientBypassingRequestsDirectlyTo(HttpMate httpMate) {
        Validators.validateNotNull((Object)httpMate, (String)"httpMate");
        return basePath -> responseMapper -> {
            Validators.validateNotNull((Object)basePath, (String)"basePath");
            Validators.validateNotNull((Object)responseMapper, (String)"responseMapper");
            Issuer issuer = BypassIssuer.bypassIssuer(httpMate);
            return new HttpMateClient(issuer, BasePath.basePath(basePath), responseMapper);
        };
    }

    public static PortStage aHttpMateClientForTheHost(String host) {
        Validators.validateNotNullNorEmpty((String)host, (String)"host");
        return port -> protocol -> basePath -> responseMapper -> {
            Validators.validateNotNull((Object)((Object)protocol), (String)"protocol");
            Validators.validateNotNull((Object)basePath, (String)"basePath");
            Validators.validateNotNull((Object)responseMapper, (String)"responseMapper");
            Issuer issuer = RealIssuer.realIssuer(protocol, host, port, BasePath.basePath(basePath));
            return new HttpMateClient(issuer, BasePath.basePath(basePath), responseMapper);
        };
    }

    public static PortStage aHttpMateClientThatReusesConnectionsForTheHost(String host) {
        Validators.validateNotNullNorEmpty((String)host, (String)"host");
        return port -> protocol -> basePath -> responseMapper -> {
            Validators.validateNotNull((Object)((Object)protocol), (String)"protocol");
            Validators.validateNotNull((Object)basePath, (String)"basePath");
            Validators.validateNotNull((Object)responseMapper, (String)"responseMapper");
            Issuer issuer = RealIssuer.realIssuerWithConnectionReuse(protocol, host, port, BasePath.basePath(basePath));
            return new HttpMateClient(issuer, BasePath.basePath(basePath), responseMapper);
        };
    }

    public <T> T issue(HttpClientRequest<T> request) {
        Validators.validateNotNull(request, (String)"request");
        return (T)this.issuer.issue(request, this.basePath, response -> this.responseMapper.map((RawClientResponse)response, request.targetType()));
    }

    private HttpMateClient(Issuer issuer, BasePath basePath, ClientResponseMapper responseMapper) {
        this.issuer = issuer;
        this.basePath = basePath;
        this.responseMapper = responseMapper;
    }
}

