/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client;

import com.envimate.httpmate.util.Validators;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;

public final class RawClientResponse {
    private final int statusCode;
    private final Map<String, String> headers;
    private final InputStream content;

    public static RawClientResponse rawClientResponse(int statusCode, Map<String, String> headers, InputStream content) {
        Validators.validateNotNull(headers, (String)"headers");
        Validators.validateNotNull((Object)content, (String)"content");
        return new RawClientResponse(statusCode, headers, content);
    }

    public int statusCode() {
        return this.statusCode;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public Optional<String> header(String key) {
        return Optional.ofNullable(this.headers.get(key));
    }

    public Optional<String> contentType() {
        return this.header("Content-Type");
    }

    public InputStream content() {
        return this.content;
    }

    public String toString() {
        return "RawClientResponse(statusCode=" + this.statusCode + ", headers=" + this.headers + ", content=" + this.content + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawClientResponse)) {
            return false;
        }
        RawClientResponse other = (RawClientResponse)o;
        if (this.statusCode != other.statusCode) {
            return false;
        }
        Map<String, String> this$headers = this.headers;
        Map<String, String> other$headers = other.headers;
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        InputStream this$content = this.content;
        InputStream other$content = other.content;
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.statusCode;
        Map<String, String> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        InputStream $content = this.content;
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    private RawClientResponse(int statusCode, Map<String, String> headers, InputStream content) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.content = content;
    }
}

