/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client.issuer.bypass;

import com.envimate.httpmate.HttpMate;
import com.envimate.httpmate.HttpMateChainKeys;
import com.envimate.httpmate.chains.MetaData;
import com.envimate.httpmate.client.BasePath;
import com.envimate.httpmate.client.HttpClientRequest;
import com.envimate.httpmate.client.RawClientResponse;
import com.envimate.httpmate.client.issuer.Issuer;
import com.envimate.httpmate.client.issuer.bypass.SynchronizationWrapper;
import com.envimate.httpmate.util.Validators;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Function;

public final class BypassIssuer
implements Issuer {
    private final HttpMate httpMate;

    public static Issuer bypassIssuer(HttpMate httpMate) {
        Validators.validateNotNull((Object)httpMate, (String)"httpMate");
        return new BypassIssuer(httpMate);
    }

    @Override
    public <T> T issue(HttpClientRequest<T> request, BasePath basePath, Function<RawClientResponse, T> responseMapper) {
        String fixedPath = basePath.concatenateWithStartingAndTrailingSlash(request.path());
        MetaData metaData = MetaData.emptyMetaData();
        metaData.set(HttpMateChainKeys.RAW_HEADERS, request.headers());
        metaData.set(HttpMateChainKeys.RAW_QUERY_PARAMETERS, request.queryParameters());
        metaData.set(HttpMateChainKeys.RAW_METHOD, (Object)request.method());
        metaData.set(HttpMateChainKeys.RAW_PATH, (Object)fixedPath);
        metaData.set(HttpMateChainKeys.BODY_STREAM, (Object)request.body());
        metaData.set(HttpMateChainKeys.IS_HTTP_REQUEST, (Object)true);
        SynchronizationWrapper wrapper = new SynchronizationWrapper();
        this.httpMate.handleRequest(metaData, wrapper::setObject);
        Map responseHeaders = (Map)metaData.get(HttpMateChainKeys.RESPONSE_HEADERS);
        int responseStatus = (Integer)metaData.get(HttpMateChainKeys.RESPONSE_STATUS);
        InputStream responseBody = (InputStream)metaData.get(HttpMateChainKeys.STREAM_RESPONSE);
        RawClientResponse response = RawClientResponse.rawClientResponse(responseStatus, responseHeaders, responseBody);
        return responseMapper.apply(response);
    }

    private BypassIssuer(HttpMate httpMate) {
        this.httpMate = httpMate;
    }
}

