/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client.issuer.real;

import com.envimate.httpmate.client.BasePath;
import com.envimate.httpmate.client.HttpClientRequest;
import com.envimate.httpmate.client.RawClientResponse;
import com.envimate.httpmate.client.issuer.Issuer;
import com.envimate.httpmate.client.issuer.real.Connection;
import com.envimate.httpmate.client.issuer.real.ConnectionFactory;
import com.envimate.httpmate.client.issuer.real.Endpoint;
import com.envimate.httpmate.client.issuer.real.NormalConnectionFactory;
import com.envimate.httpmate.client.issuer.real.PooledConnectionFactory;
import com.envimate.httpmate.client.issuer.real.Protocol;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestTargetHost;

public final class RealIssuer
implements Issuer {
    private final Endpoint endpoint;
    private final ConnectionFactory connectionFactory;

    public static Issuer realIssuer(Protocol protocol, String host, int port, BasePath basePath) {
        return new RealIssuer(Endpoint.endpoint(protocol, host, port, basePath), NormalConnectionFactory.normalConnectionFactory());
    }

    public static Issuer realIssuerWithConnectionReuse(Protocol protocol, String host, int port, BasePath basePath) {
        return new RealIssuer(Endpoint.endpoint(protocol, host, port, basePath), PooledConnectionFactory.pooledConnectionFactory());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T issue(HttpClientRequest<T> request, BasePath basePath, Function<RawClientResponse, T> responseMapper) {
        String path = request.path();
        Map<String, String> queryParameters = request.queryParameters();
        String url = this.endpoint.toUrl(path, queryParameters);
        String method = request.method();
        BasicHttpEntityEnclosingRequest lowLevelRequest = new BasicHttpEntityEnclosingRequest(method, url);
        request.headers().forEach((arg_0, arg_1) -> ((HttpEntityEnclosingRequest)lowLevelRequest).addHeader(arg_0, arg_1));
        InputStream requestBody = request.body();
        InputStreamEntity entity = new InputStreamEntity(requestBody);
        lowLevelRequest.setEntity((HttpEntity)entity);
        try (Connection connection = this.connectionFactory.getConnectionTo(this.endpoint);){
            HttpProcessor httpProcessor = HttpProcessorBuilder.create().add((HttpRequestInterceptor)new RequestContent()).add((HttpRequestInterceptor)new RequestTargetHost()).build();
            HttpCoreContext context = HttpCoreContext.create();
            context.setTargetHost(new HttpHost(this.endpoint.host()));
            httpProcessor.process((HttpRequest)lowLevelRequest, (HttpContext)context);
            HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
            HttpClientConnection connectionObject = connection.connectionObject();
            HttpResponse response = httpexecutor.execute((HttpRequest)lowLevelRequest, connectionObject, (HttpContext)context);
            int statusCode = response.getStatusLine().getStatusCode();
            HashMap<String, String> headers = new HashMap<String, String>();
            Arrays.stream(response.getAllHeaders()).forEach(header -> headers.put(header.getName().toLowerCase(), header.getValue()));
            InputStream body = response.getEntity().getContent();
            RawClientResponse rawClientResponse = RawClientResponse.rawClientResponse(statusCode, headers, body);
            RawClientResponse t = responseMapper.apply(rawClientResponse);
            return (T)t;
        }
        catch (IOException | HttpException e) {
            throw new RuntimeException(e);
        }
    }

    private RealIssuer(Endpoint endpoint, ConnectionFactory connectionFactory) {
        this.endpoint = endpoint;
        this.connectionFactory = connectionFactory;
    }
}

