/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.messaging;

import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.messaging.Message;
import com.enterprisemath.utils.messaging.Messenger;
import com.enterprisemath.utils.messaging.SystemMessenger;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ProxySystemMessenger
implements SystemMessenger {
    private String target;
    private Messenger messenger;

    private ProxySystemMessenger() {
    }

    @PostConstruct
    private void guardInvariants() {
        ValidationUtils.guardNotEmpty(this.target, "target cannot be empty");
        ValidationUtils.guardNotNull(this.messenger, "messenger cannot be null");
    }

    @Override
    public void send(Message message) {
        this.messenger.send(this.target, message);
    }

    @Override
    public void sendError(String caption, String explanation) {
        Message message = new Message.Builder().setType("error").addParameter("caption", caption).addParameter("explanation", explanation).addParameter("exception.class", "").addParameter("exception.message", "").addParameter("exception.stackTrace", "").build();
        this.messenger.send(this.target, message);
    }

    @Override
    public void sendError(String caption, String explanation, Throwable e) {
        Message message = new Message.Builder().setType("error").addParameter("caption", caption).addParameter("explanation", explanation).addParameter("exception.class", e.getClass().toString()).addParameter("exception.message", e.getMessage()).addParameter("exception.stackTrace", ExceptionUtils.getStackTrace((Throwable)e)).build();
        this.messenger.send(this.target, message);
    }

    @Override
    public void sendError(String caption, String explanation, Map<String, String> exceptionDetails) {
        Message message = new Message.Builder().setType("error").addParameter("caption", caption).addParameter("explanation", explanation).addParameter("exception.class", StringUtils.defaultString((String)exceptionDetails.get("class"))).addParameter("exception.message", StringUtils.defaultString((String)exceptionDetails.get("message"))).addParameter("exception.stackTrace", StringUtils.defaultString((String)exceptionDetails.get("stackTrace"))).build();
        this.messenger.send(this.target, message);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static ProxySystemMessenger create(String target, Messenger messenger) {
        ProxySystemMessenger res = new ProxySystemMessenger();
        res.target = target;
        res.messenger = messenger;
        res.guardInvariants();
        return res;
    }
}

