/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.messaging;

import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.messaging.Attachment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Message {
    private String type;
    private Map<String, String> parameters;
    private List<Attachment> attachments;

    public Message(Builder builder) {
        this.type = builder.type;
        this.parameters = DomainUtils.softCopyUnmodifiableMap(builder.parameters);
        this.attachments = DomainUtils.softCopyUnmodifiableList(builder.attachments);
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotEmpty(this.type, "type cannot be empty");
        ValidationUtils.guardNotEmptyStringInCollection(this.parameters.keySet(), "parameters.keySet cannot have an empty string");
        ValidationUtils.guardNotNull(this.parameters.values(), "values cannot have null element");
        ValidationUtils.guardNotNullCollection(this.attachments, "attachements cannot have null element");
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class Builder {
        private String type;
        private Map<String, String> parameters = new HashMap<String, String>();
        private List<Attachment> attachments = new ArrayList<Attachment>();

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setParameters(Map<String, String> parameters) {
            this.parameters = DomainUtils.softCopyMap(parameters);
            return this;
        }

        public Builder addParameter(String key, String value) {
            this.parameters.put(key, value);
            return this;
        }

        public Builder setAttachments(List<Attachment> attachments) {
            this.attachments = DomainUtils.softCopyList(attachments);
            return this;
        }

        public Builder addAttachment(Attachment attachment) {
            this.attachments.add(attachment);
            return this;
        }

        public Message build() {
            return new Message(this);
        }
    }
}

