/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.image;

import com.enterprisemath.utils.image.ImageAnimation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class GifAnimatorWriter {
    public GifAnimatorWriter(Builder builder) {
        this.guardInvariants();
    }

    private void guardInvariants() {
    }

    public byte[] writeAnimation(ImageAnimation animation) {
        ImageWriter writer = ImageIO.getImageWritersBySuffix("gif").next();
        ImageWriteParam param = writer.getDefaultWriteParam();
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(6);
        IIOMetadata metaData = writer.getDefaultImageMetadata(imageTypeSpecifier, param);
        String metaFormatName = metaData.getNativeMetadataFormatName();
        IIOMetadataNode root = (IIOMetadataNode)metaData.getAsTree(metaFormatName);
        IIOMetadataNode graphicsControlExtensionNode = this.getNode(root, "GraphicControlExtension");
        graphicsControlExtensionNode.setAttribute("disposalMethod", "none");
        graphicsControlExtensionNode.setAttribute("userInputFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("transparentColorFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("delayTime", Integer.toString(animation.getFrameDuration() / 10));
        graphicsControlExtensionNode.setAttribute("transparentColorIndex", "0");
        IIOMetadataNode commentsNode = this.getNode(root, "CommentExtensions");
        commentsNode.setAttribute("CommentExtension", "Created by MAH");
        IIOMetadataNode appEntensionsNode = this.getNode(root, "ApplicationExtensions");
        IIOMetadataNode child = new IIOMetadataNode("ApplicationExtension");
        child.setAttribute("applicationID", "NETSCAPE");
        child.setAttribute("authenticationCode", "2.0");
        int loop = 0;
        child.setUserObject(new byte[]{1, (byte)(loop & 0xFF), (byte)(loop >> 8 & 0xFF)});
        appEntensionsNode.appendChild(child);
        ByteArrayOutputStream os = null;
        ImageInputStream ios = null;
        try {
            os = new ByteArrayOutputStream();
            ios = new MemoryCacheImageOutputStream(os);
            metaData.setFromTree(metaFormatName, root);
            writer.setOutput(ios);
            writer.prepareWriteSequence(null);
            for (int i = 0; i < animation.getNumFrames(); ++i) {
                writer.writeToSequence(new IIOImage(animation.getFrame(i), null, metaData), param);
            }
            writer.endWriteSequence();
            ios.close();
            os.close();
            ios = null;
        }
        catch (IIOInvalidTreeException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (Exception e) {}
            }
            IOUtils.closeQuietly((OutputStream)os);
        }
        return os.toByteArray();
    }

    private IIOMetadataNode getNode(IIOMetadataNode rootNode, String nodeName) {
        int nNodes = rootNode.getLength();
        for (int i = 0; i < nNodes; ++i) {
            if (rootNode.item(i).getNodeName().compareToIgnoreCase(nodeName) != 0) continue;
            return (IIOMetadataNode)rootNode.item(i);
        }
        IIOMetadataNode node = new IIOMetadataNode(nodeName);
        rootNode.appendChild(node);
        return node;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static GifAnimatorWriter create() {
        return new Builder().build();
    }

    public static class Builder {
        public GifAnimatorWriter build() {
            return new GifAnimatorWriter(this);
        }
    }
}

