/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.engine;

import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.ValidationUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TaskRunStopReport {
    private String code;
    private String taskClass;
    private Map<String, String> parameters;
    private Date startTimestamp;
    private Date endTimestamp;

    public TaskRunStopReport(Builder builder) {
        this.code = builder.code;
        this.taskClass = builder.taskClass;
        this.parameters = DomainUtils.softCopyUnmodifiableMap(builder.parameters);
        this.startTimestamp = DomainUtils.copyDate(builder.startTimestamp);
        this.endTimestamp = DomainUtils.copyDate(builder.endTimestamp);
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotEmpty(this.code, "code cannot be empty");
        ValidationUtils.guardNotEmpty(this.taskClass, "taskClass cannot be empty");
        ValidationUtils.guardNotEmptyNullMap(this.parameters, "parameters cannot have empty key or null value");
        ValidationUtils.guardNotNull(this.startTimestamp, "startTimestamp cannot be null");
        ValidationUtils.guardNotNull(this.endTimestamp, "endTimestamp cannot be null");
    }

    public String getCode() {
        return this.code;
    }

    public String getTaskClass() {
        return this.taskClass;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public Date getEndTimestamp() {
        return this.endTimestamp;
    }

    public long getDuration() {
        return this.endTimestamp.getTime() - this.startTimestamp.getTime();
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class Builder {
        private String code;
        private String taskClass;
        private Map<String, String> parameters = new HashMap<String, String>();
        private Date startTimestamp;
        private Date endTimestamp;

        public Builder setCode(String code) {
            this.code = code;
            return this;
        }

        public Builder setTaskClass(String taskClass) {
            this.taskClass = taskClass;
            return this;
        }

        public Builder setParameters(Map<String, String> parameters) {
            this.parameters = DomainUtils.softCopyMap(parameters);
            return this;
        }

        public Builder setStartTimestamp(Date startTimestamp) {
            this.startTimestamp = DomainUtils.copyDate(startTimestamp);
            return this;
        }

        public Builder setEndTimestamp(Date endTimestamp) {
            this.endTimestamp = DomainUtils.copyDate(endTimestamp);
            return this;
        }

        public TaskRunStopReport build() {
            return new TaskRunStopReport(this);
        }
    }
}

