/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.engine;

import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.engine.Task;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TaskRunOrder {
    private String taskClass;
    private Map<String, String> parameters;

    public TaskRunOrder(Builder builder) {
        this.taskClass = builder.taskClass;
        this.parameters = DomainUtils.softCopyUnmodifiableMap(builder.parameters);
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotEmpty(this.taskClass, "taskClass cannot be empty");
        ValidationUtils.guardNotEmptyNullMap(this.parameters, "parameters cannot have empty key or null value");
    }

    public String getTaskClass() {
        return this.taskClass;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Task createTaskInstance() {
        try {
            Class<?> clazz = Class.forName(this.taskClass);
            Method method = clazz.getMethod("create", new Class[0]);
            return (Task)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static TaskRunOrder create(String taskClass) {
        return new Builder().setTaskClass(taskClass).build();
    }

    public static TaskRunOrder create(String taskClass, Map<String, String> parameters) {
        return new Builder().setTaskClass(taskClass).setParameters(parameters).build();
    }

    public static class Builder {
        private String taskClass;
        private Map<String, String> parameters = new HashMap<String, String>();

        public Builder setTaskClass(String taskClass) {
            this.taskClass = taskClass;
            return this;
        }

        public Builder setParameters(Map<String, String> parameters) {
            this.parameters = DomainUtils.softCopyMap(parameters);
            return this;
        }

        public Builder addParameter(String key, String value) {
            this.parameters.put(key, value);
            return this;
        }

        public TaskRunOrder build() {
            return new TaskRunOrder(this);
        }
    }
}

